﻿var Matrix33 = function(e)
{
	if ( e )
	{
		this._e = e;
	}
	else
	{
		this._e = [
			1,0,0,
			0,1,0,
			0,0,1];
	}
};

Matrix33.prototype =
{
	identity : function()
	{
		this._e = [
			1,0,0,
			0,1,0,
			0,0,1];
	},
	transpose : function()
	{
		mat = new Matrix33();
		mat._e[0] = this._e[0];
		mat._e[1] = this._e[3];
		mat._e[2] = this._e[6];
		mat._e[3] = this._e[1];
		mat._e[4] = this._e[4];
		mat._e[5] = this._e[7];
		mat._e[6] = this._e[2];
		mat._e[7] = this._e[5];
		mat._e[8] = this._e[8];
		return mat;
	}
}

var Matrix3D = function(e)
{
	if ( e )
	{
		this._e = e;
	}
	else
	{
		this._e = [
			1,0,0,0,
			0,1,0,0,
			0,0,1,0,
			0,0,0,1];
	}
};

Matrix3D.prototype =
{
	identity : function()
	{
		this._e = [
			1,0,0,0,
			0,1,0,0,
			0,0,1,0,
			0,0,0,1];
	},
	translate : function(v)
	{
		var a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;

		a00 = this._e[0]; a01 = this._e[1]; a02 = this._e[ 2]; a03 = this._e[ 3];
		a10 = this._e[4]; a11 = this._e[5]; a12 = this._e[ 6]; a13 = this._e[ 7];
		a20 = this._e[8]; a21 = this._e[9]; a22 = this._e[10]; a23 = this._e[11];

		this._e[0] = a00; this._e[1] = a01; this._e[ 2] = a02; this._e[ 3] = a03;
		this._e[4] = a10; this._e[5] = a11; this._e[ 6] = a12; this._e[ 7] = a13;
		this._e[8] = a20; this._e[9] = a21; this._e[10] = a22; this._e[11] = a23;

		this._e[12] = a00 * v.x + a10 * v.y + a20 * v.z + this._e[12];
		this._e[13] = a01 * v.x + a11 * v.y + a21 * v.z + this._e[13];
		this._e[14] = a02 * v.x + a12 * v.y + a22 * v.z + this._e[14];
		this._e[15] = a03 * v.x + a13 * v.y + a23 * v.z + this._e[15];
	},
	rotateX : function (angle)
	{
		var s = Math.sin(angle);
		var c = Math.cos(angle);
		var a10 = this._e[4];
		var a11 = this._e[5];
		var a12 = this._e[6];
		var a13 = this._e[7];
		var a20 = this._e[8];
		var a21 = this._e[9];
		var a22 = this._e[10];
		var a23 = this._e[11];

		this._e[4] = a10 * c + a20 * s;
		this._e[5] = a11 * c + a21 * s;
		this._e[6] = a12 * c + a22 * s;
		this._e[7] = a13 * c + a23 * s;

		this._e[8] = a10 * -s + a20 * c;
		this._e[9] = a11 * -s + a21 * c;
		this._e[10] = a12 * -s + a22 * c;
		this._e[11] = a13 * -s + a23 * c;
	},
	rotateY : function(angle)
	{
		var s = Math.sin(angle);
		var c = Math.cos(angle);
		var a00 = this._e[0];
		var a01 = this._e[1];
		var a02 = this._e[2];
		var a03 = this._e[3];
		var a20 = this._e[8];
		var a21 = this._e[9];
		var a22 = this._e[10];
		var a23 = this._e[11];

		this._e[0] = a00 * c + a20 * -s;
		this._e[1] = a01 * c + a21 * -s;
		this._e[2] = a02 * c + a22 * -s;
		this._e[3] = a03 * c + a23 * -s;

		this._e[8] = a00 * s + a20 * c;
		this._e[9] = a01 * s + a21 * c;
		this._e[10] = a02 * s + a22 * c;
		this._e[11] = a03 * s + a23 * c;
	},
	rotateZ : function (angle)
	{
		var s = Math.sin(angle);
		var c = Math.cos(angle);
		var a00 = this._e[0];
		var a01 = this._e[1];
		var a02 = this._e[2];
		var a03 = this._e[3];
		var a10 = this._e[4];
		var a11 = this._e[5];
		var a12 = this._e[6];
		var a13 = this._e[7];

		this._e[0] = a00 * c + a10 * s;
		this._e[1] = a01 * c + a11 * s;
		this._e[2] = a02 * c + a12 * s;
		this._e[3] = a03 * c + a13 * s;

		this._e[4] = a00 * -s + a10 * c;
		this._e[5] = a01 * -s + a11 * c;
		this._e[6] = a02 * -s + a12 * c;
		this._e[7] = a03 * -s + a13 * c;
	},
	scale : function (v)
	{
		this._e[ 0] *= v.x;
		this._e[ 1] *= v.x;
		this._e[ 2] *= v.x;
		this._e[ 3] *= v.x;
		this._e[ 4] *= v.y;
		this._e[ 5] *= v.y;
		this._e[ 6] *= v.y;
		this._e[ 7] *= v.y;
		this._e[ 8] *= v.z;
		this._e[ 9] *= v.z;
		this._e[10] *= v.z;
		this._e[11] *= v.z;
	},
	transform : function(v)
	{
        var x = v.x * this._e[0] + v.y * this._e[4] + v.z * this._e[8]  + v.w * this._e[12];
        var y = v.x * this._e[1] + v.y * this._e[5] + v.z * this._e[9]  + v.w * this._e[13];
        var z = v.x * this._e[2] + v.y * this._e[6] + v.z * this._e[10] + v.w * this._e[14];
        var w = v.x * this._e[3] + v.y * this._e[7] + v.z * this._e[11] + v.w * this._e[15];

        return new Vector4D(x,y,z,w);
	},
	multiply : function(a,b)
	{
		this._e[ 0] = a._e[ 0]*b._e[0] + a._e[ 1]*b._e[4] + a._e[ 2]*b._e[ 8] + a._e[ 3]*b._e[12];
		this._e[ 1] = a._e[ 0]*b._e[1] + a._e[ 1]*b._e[5] + a._e[ 2]*b._e[ 9] + a._e[ 3]*b._e[13];
		this._e[ 2] = a._e[ 0]*b._e[2] + a._e[ 1]*b._e[6] + a._e[ 2]*b._e[10] + a._e[ 3]*b._e[14];
		this._e[ 3] = a._e[ 0]*b._e[3] + a._e[ 1]*b._e[7] + a._e[ 2]*b._e[11] + a._e[ 3]*b._e[15];
		this._e[ 4] = a._e[ 4]*b._e[0] + a._e[ 5]*b._e[4] + a._e[ 6]*b._e[ 8] + a._e[ 7]*b._e[12];
		this._e[ 5] = a._e[ 4]*b._e[1] + a._e[ 5]*b._e[5] + a._e[ 6]*b._e[ 9] + a._e[ 7]*b._e[13];
		this._e[ 6] = a._e[ 4]*b._e[2] + a._e[ 5]*b._e[6] + a._e[ 6]*b._e[10] + a._e[ 7]*b._e[14];
		this._e[ 7] = a._e[ 4]*b._e[3] + a._e[ 5]*b._e[7] + a._e[ 6]*b._e[11] + a._e[ 7]*b._e[15];
		this._e[ 8] = a._e[ 8]*b._e[0] + a._e[ 9]*b._e[4] + a._e[10]*b._e[ 8] + a._e[11]*b._e[12];
		this._e[ 9] = a._e[ 8]*b._e[1] + a._e[ 9]*b._e[5] + a._e[10]*b._e[ 9] + a._e[11]*b._e[13];
		this._e[10] = a._e[ 8]*b._e[2] + a._e[ 9]*b._e[6] + a._e[10]*b._e[10] + a._e[11]*b._e[14];
		this._e[11] = a._e[ 8]*b._e[3] + a._e[ 9]*b._e[7] + a._e[10]*b._e[11] + a._e[11]*b._e[15];
		this._e[12] = a._e[12]*b._e[0] + a._e[13]*b._e[4] + a._e[14]*b._e[ 8] + a._e[15]*b._e[12];
		this._e[13] = a._e[12]*b._e[1] + a._e[13]*b._e[5] + a._e[14]*b._e[ 9] + a._e[15]*b._e[13];
		this._e[14] = a._e[12]*b._e[2] + a._e[13]*b._e[6] + a._e[14]*b._e[10] + a._e[15]*b._e[14];
		this._e[15] = a._e[12]*b._e[3] + a._e[13]*b._e[7] + a._e[14]*b._e[11] + a._e[15]*b._e[15];
	},
	lookAtCamera : function(eye, at, up)
	{
		var z2 = eye.subtract(at);
		z2.normalize();

		var x2 = up.crossProduct(z2);
		x2.normalize();

		var y2 = z2.crossProduct(x2);

		this._e = [
			x2.x,y2.x,z2.x,0,
			x2.y,y2.y,z2.y,0,
			x2.z,y2.z,z2.z,0,
			-x2.dotProduct(eye),
			-y2.dotProduct(eye),
			-z2.dotProduct(eye),
			1];
	},
	frustum : function (left, right, bottom, top, near, far)
	{
		var rl = (right - left);
		var tb = (top - bottom);
		var fn = (far - near);
		this._e[ 0] = (near * 2) / rl;
		this._e[ 1] = 0;
		this._e[ 2] = 0;
		this._e[ 3] = 0;
		this._e[ 4] = 0;
		this._e[ 5] = (near * 2) / tb;
		this._e[ 6] = 0;
		this._e[ 7] = 0;
		this._e[ 8] = (right + left) / rl;
		this._e[ 9] = (top + bottom) / tb;
		this._e[10] = -(far + near) / fn;
		this._e[11] = -1;
		this._e[12] = 0;
		this._e[13] = 0;
		this._e[14] = -(far * near * 2) / fn;
		this._e[15] = 0;
	},
	perspective : function (fov, aspect, near, far)
	{
	    var top = near * Math.tan(fov * Math.PI / 360.0);
		var right = top * aspect;
		this.frustum(-right, right, -top, top, near, far);
	},
	ortho : function (left, right, bottom, top, near, far)
	{
		var rl = (right - left),
			tb = (top - bottom),
			fn = (far - near);
		this._e[0] = 2 / rl;
		this._e[1] = 0;
		this._e[2] = 0;
		this._e[3] = 0;
		this._e[4] = 0;
		this._e[5] = 2 / tb;
		this._e[6] = 0;
		this._e[7] = 0;
		this._e[8] = 0;
		this._e[9] = 0;
		this._e[10] = -2 / fn;
		this._e[11] = 0;
		this._e[12] = -(left + right) / rl;
		this._e[13] = -(top + bottom) / tb;
		this._e[14] = -(far + near) / fn;
		this._e[15] = 1;
	},
	transformCamera : function(trans,rotate,scale)
	{
		this.identity();
		this.rotateX(degreeToRadian(rotate.x));	
		this.rotateY(degreeToRadian(rotate.y));
		this.rotateZ(degreeToRadian(rotate.z));
		this.translate(trans);
		this.scale(scale);
	},
	set : function(m)
	{
		for ( var i = 0; i < 16; i++ )
		{
			m._e[i] = this._e[i];
		}

		return m;
	},
	copy : function()
	{
		var m = new Matrix3D();
		for ( var i = 0; i < 16; i++ )
		{
			m._e[i] = this._e[i];
		}
		return m;
	},
	inverseMat33 : function ()
	{
		var a00 = this._e[0], a01 = this._e[1], a02 = this._e[ 2];
		var a10 = this._e[4], a11 = this._e[5], a12 = this._e[ 6];
		var a20 = this._e[8], a21 = this._e[9], a22 = this._e[10];

		var b01 =  a22 * a11 - a12 * a21;
		var b11 = -a22 * a10 + a12 * a20;
		var b21 =  a21 * a10 - a11 * a20;

		var d = a00 * b01 + a01 * b11 + a02 * b21;
		var id;

		if (!d)
		{
			return;
		}
		id = 1 / d;

		var dest = new Matrix33();

		dest._e[0] = b01 * id;
		dest._e[1] = (-a22 * a01 + a02 * a21) * id;
		dest._e[2] = ( a12 * a01 - a02 * a11) * id;
		dest._e[3] = b11 * id;
		dest._e[4] = ( a22 * a00 - a02 * a20) * id;
		dest._e[5] = (-a12 * a00 + a02 * a10) * id;
		dest._e[6] = b21 * id;
		dest._e[7] = (-a21 * a00 + a01 * a20) * id;
		dest._e[8] = ( a11 * a00 - a01 * a10) * id;

		return dest;
	},
	inverse : function(mat)
	{
		var a = mat._e[0],  b = mat._e[1],  c = mat._e[2],  d = mat._e[3],
			e = mat._e[4],  f = mat._e[5],  g = mat._e[6],  h = mat._e[7],
			i = mat._e[8],  j = mat._e[9],  k = mat._e[10], l = mat._e[11],
			m = mat._e[12], n = mat._e[13], o = mat._e[14], p = mat._e[15],
			q = a * f - b * e, r = a * g - c * e,
			s = a * h - d * e, t = b * g - c * f,
			u = b * h - d * f, v = c * h - d * g,
			w = i * n - j * m, x = i * o - k * m,
			y = i * p - l * m, z = j * o - k * n,
			A = j * p - l * n, B = k * p - l * o,
			ivd = 1 / (q * B - r * A + s * z + t * y - u * x + v * w);
		this._e[0]  = ( f * B - g * A + h * z) * ivd;
		this._e[1]  = (-b * B + c * A - d * z) * ivd;
		this._e[2]  = ( n * v - o * u + p * t) * ivd;
		this._e[3]  = (-j * v + k * u - l * t) * ivd;
		this._e[4]  = (-e * B + g * y - h * x) * ivd;
		this._e[5]  = ( a * B - c * y + d * x) * ivd;
		this._e[6]  = (-m * v + o * s - p * r) * ivd;
		this._e[7]  = ( i * v - k * s + l * r) * ivd;
		this._e[8]  = ( e * A - f * y + h * w) * ivd;
		this._e[9]  = (-a * A + b * y - d * w) * ivd;
		this._e[10] = ( m * u - n * s + p * q) * ivd;
		this._e[11] = (-i * u + j * s - l * q) * ivd;
		this._e[12] = (-e * z + f * x - g * w) * ivd;
		this._e[13] = ( a * z - b * x + c * w) * ivd;
		this._e[14] = (-m * t + n * r - o * q) * ivd;
		this._e[15] = ( i * t - j * r + k * q) * ivd;
		return this;
	},
	toString : function()
	{
		return "_e=["
			+this._e[ 0]+","+this._e[ 1]+","+this._e[ 2]+","+this._e[ 3]+","
			+this._e[ 4]+","+this._e[ 5]+","+this._e[ 6]+","+this._e[ 7]+","
			+this._e[ 8]+","+this._e[ 9]+","+this._e[10]+","+this._e[11]+","
			+this._e[12]+","+this._e[13]+","+this._e[14]+","+this._e[15]+"]";
	}
};
