﻿var Model2D = function()
{
};
Model2D.prototype = new Model3D();

Model2D.prototype =
{
	init : function()
	{
		Model3D.prototype.init.call(this);
	},
	setMaterial : function(r,g,b,a,dif,amb,emi,spc,power,texture)
	{
		Model3D.prototype.setMaterial.call(this,r,g,b,a,dif,amb,emi,spc,power,texture);
	},
	setV : function(x,y,z,nx,ny,nz,material)
	{
		Model3D.prototype.setV.call(this,x,y,z,nx,ny,nz,material);
	},
	setI : function(i0,i1,i2)
	{
		Model3D.prototype.setI.call(this,i0,i1,i2);
	},
	setVertex : function(x,y,z,nx,ny,nz,material)
	{
		Model3D.prototype.setVertex.call(this,x,y,z,nx,ny,nz,material);
	},
	setUV : function(u,v)
	{
		Model3D.prototype.setUV.call(this,u,v);
	},
	initBuffers : function()
	{
		Model3D.prototype.initBuffers.call(this);
	},
	getVerticesLength : function(index)
	{
		return Model3D.prototype.getVerticesLength.call(this,index);
	},
	draw : function()
	{
		if ( !this._visible )
		{
			return;
		}
		mvPushMatrix();

		_mvMatrix.identity();
		_mvMatrix.translate(this._pos);

		_gl.uniform1i(_shaderProgram.u_useBone, false);
		_gl.disableVertexAttribArray(_shaderProgram.a_bone);
		_gl.disableVertexAttribArray(_shaderProgram.a_weight);

		var pMatrix = new Matrix3D();
		pMatrix.ortho(-50,50,-50,50,1,-1);
		setMatrixUniforms(pMatrix._e);

		for ( var i = 0; i < this._materials.length; i++ )
		{
			if ( this.getVerticesLength(i) > 0 )
			{
				Model3D.prototype.setVertices.call(this,i);
				_gl.drawArrays(_gl.TRIANGLES, 0, this.getVerticesLength(i) );
			}
		}

		mvPopMatrix();
	},
	intersect : function(origin,dir)
	{
		return false;
	},
	intersectTriangle : function(origin,dir,v0,v1,v2)
	{
		return false;
	},
	mousePick : function(x,y)
	{
		return false;
	},
	setText : function(text)
	{
		return;
	},
	fade : function(time)
	{
		Model3D.prototype.fade.call(this,time);
	},
}
