﻿var TimeLineData = function(word,anim,state,motion,skip,frame,audio,loop,camera)
{
	this._Word = word;
	this._Animation = anim;
	this._State = state;
	this._Motion = motion;
	this._Skip = skip;
	this._Frame = frame;
	this._Audio = audio;
	this._Loop = loop;
	if ( camera == null )
	{
		this._Camera = -1;
	}
	else
	{
		this._Camera = camera;
	}
	this._CheckBox = "";
	this._Prompt = "";
};

TimeLineData.prototype =
{
	init : function()
	{
	},
	getTrans : function()
	{
		return new Vector3D(this._Motion[0],this._Motion[1],this._Motion[2]);
	},
	getRotate : function()
	{
		return new Vector3D(this._Motion[3],this._Motion[4],this._Motion[5]);
	},
	getScale : function()
	{
		return new Vector3D(this._Motion[6],this._Motion[7],this._Motion[8]);
	},
}

var TimeLine = function()
{
	this._name  = [];
	this._data  = [];
	this._data2 = [];
};

TimeLine.prototype =
{
	init : function()
	{
	},
	setT : function(word,anim,state,motion,skip,frame,audio,loop,camera)
	{
		this._data.push(new TimeLineData(word,anim,state,motion,skip,frame,audio,loop,camera));
	},
	setT2 : function(name)
	{
		this._name.push(name);
		this._data2.push(this._data);
		this._data = [];
	},
	getLength : function()
	{
		return this._data2.length;
	},
	getDataLength : function(index)
	{
		if ( index >= 0 && index < this._data2.length )
		{
			return this._data2[index].length;
		}
		return 0;
	},
	isAble : function(index,current)
	{
		if ( index >= 0 && index < this._data2.length
		&& current >= 0 && current < this._data2[index].length )
		{
			return true;
		}
		return false;
	},
	getData : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]
		}
		return new TimeLineData("",-1,0,[0,0,0,0,0,0,1,1,1],0,0,-1,0);
	},
	getWord : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Word;
		}
		return "";
	},
	getAnimation : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Animation;
		}
		return -1;
	},
	getState : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._State;
		}
		return 0;
	},
	getSkip : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Skip;
		}
		return 0;
	},
	getFrame : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Frame;
		}
		return 0;
	},
	getAudio : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Audio;
		}
		return 0;
	},
	getLoop : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Loop;
		}
		return 0;
	},
	getCamera : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Camera;
		}
		return 0;
	},
	getCheckBox : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._CheckBox;
		}
		return "";
	},
	setCheckBox : function(index,current,text)
	{
		if ( this.isAble(index,current) )
		{
			var txt = text.split("￥ｎ");
			if ( txt.length <= 0 || text == "" )
			{
				this._data2[index][current]._CheckBox = "";
				return;
			}
			var index1 = txt[0].indexOf("http");
			var index2 = txt[0].indexOf("./");
			var index3 = txt[0].indexOf("=");
			if ( index1 < 0 && index2 < 0 && index3 > 0 )
			{
				if ( txt[0].indexOf("=") == txt[0].length-1 )
				{
					var str = window.prompt("入力してください",this.getPrompt(index,current));
					str = str.replace( /[A-Za-z0-9-!"#$%&'()=<>,.?_\[\]{}@^~\\]/g, function(s) {
						return String.fromCharCode(s.charCodeAt(0) + 65248);
					});
					this._data2[index][current]._Prompt = str;
					this._data2[index][current]._CheckBox = txt[0]+str;
				}
				else
				{
					this._data2[index][current]._CheckBox = txt[0];
				}
			}
		}
	},
	getPrompt : function(index,current)
	{
		if ( this.isAble(index,current) )
		{
			return this._data2[index][current]._Prompt;
		}
		return "";
	},
	setPrompt : function(index,current,text)
	{
		if ( this.isAble(index,current) )
		{
			this._data2[index][current]._Prompt = text;
		}
	},
}
