const _glslToonVertex = `
attribute vec3 a_VertexPosition;
attribute vec3 a_VertexNormal;
attribute vec2 a_TextureCoord;
attribute vec4 a_Bone;
attribute vec4 a_Weight;
uniform mat4 u_MMatrix;
uniform mat4 u_MVMatrix;
uniform mat4 u_PMatrix;
uniform mat3 u_NMatrix;
uniform mat4 u_BoneMatrix[28];
uniform bool u_UseBone;
varying vec3 v_TransformedNormal;
varying vec4 v_Position;
varying vec2 v_TextureCoord;
varying vec4 v_ReceiverPos;
void main(void)
{
	if (u_UseBone)
	{
		mat4 m = u_BoneMatrix[int(a_Bone.x)]*a_Weight.x;
		m += u_BoneMatrix[int(a_Bone.y)]*a_Weight.y;
		m += u_BoneMatrix[int(a_Bone.z)]*a_Weight.z;
		m += u_BoneMatrix[int(a_Bone.w)]*a_Weight.w;
		v_Position = u_MVMatrix * m * vec4(a_VertexPosition, 1.0);
		v_TransformedNormal = u_NMatrix * mat3(m) * a_VertexNormal;
	}
	else
	{
		v_Position = u_MVMatrix * vec4(a_VertexPosition, 1.0);
		v_TransformedNormal = u_NMatrix * a_VertexNormal;
	}
	gl_Position = u_PMatrix * v_Position;
	v_TextureCoord = a_TextureCoord;
	v_ReceiverPos = u_MMatrix * vec4(a_VertexPosition,1.0);
}
`;

const _glslToonFragment = `
precision mediump float;
uniform sampler2D u_Sampler;
uniform sampler2D u_Shade;
uniform vec4 u_AmbientColor;
uniform float u_Emissive;
uniform float u_Diffuse;
uniform float u_Power;
uniform vec4 u_SpecularColor;
uniform vec4 u_Color;
uniform vec4 u_ShadeColor;
uniform bool u_UseTexture;
uniform float u_CastShadow[64*4];
varying vec3 v_TransformedNormal;
varying vec4 v_Position;
varying vec2 v_TextureCoord;
varying vec4 v_ReceiverPos;
void main(void)
{
	vec3 lightDirection = normalize(vec3(-1,-2,-2));
	vec3 normal = normalize(v_TransformedNormal);
	float lightWeighting = dot(normal,lightDirection);
	vec4 color;
	if ( u_UseTexture )
	{
		if ( lightWeighting <= 0.4 ) {
			color = texture2D(u_Shade,vec2(v_TextureCoord.s,v_TextureCoord.t));
		} else {
			color = texture2D(u_Sampler,vec2(v_TextureCoord.s,v_TextureCoord.t));
		}
		color = vec4(color.rgb,color.a*u_Color.a);
	}
	else
	{
		if ( lightWeighting <= 0.4 ) color = vec4(u_ShadeColor.rgb,u_Color.a);
		else color = vec4(u_Color.rgb,u_Color.a);
	}
	vec4 shadowColor = vec4(0.0,0.0,0.0,0.75);
	for (int i = 0; i < 64; i++) {
		if ( u_CastShadow[i*4+3] <= 0.0 ) continue;
		vec3 pos = vec3(u_CastShadow[i*4],u_CastShadow[i*4+1],u_CastShadow[i*4+2]);
		float dist = length(v_ReceiverPos.xyz - pos);
		float shadowFactor = 1.0 - smoothstep(0.0,u_CastShadow[i*4+3],dist);
		color = mix(color,shadowColor,shadowFactor);
	}
	gl_FragColor = color;
}
`;

