﻿var Vector2D = function(x,y)
{
	this.x = x;
	this.y = y;
};

var Vector3D = function(x,y,z)
{
	this.x = x;
	this.y = y;
	this.z = z;
};

var Vector4D = function(x,y,z,w)
{
	this.x = x;
	this.y = y;
	this.z = z;
	this.w = w;
};

Vector3D.prototype =
{
	length : function()
    {
		return Math.sqrt(this.x*this.x + this.y*this.y + this.z*this.z);
    },
	subtract : function(v)
	{
		var v2 = new Vector3D(0,0,0);

		v2.x = this.x - v.x;
		v2.y = this.y - v.y;
		v2.z = this.z - v.z;

		return v2;
	},
	normalize : function()
	{
		var l = this.length();
		if ( l == 0 )
		{
			this.x = 0;
			this.y = 0;
			this.z = 1;
		}
		else
		{
			this.x /= l;
			this.y /= l;
			this.z /= l;
		}
	},
	dotProduct :function(v)
    {
		return (v.x * this.x + v.y * this.y + v.z * this.z);
    },
	crossProduct : function(v)
	{
		var x = (this.y*v.z) - (this.z*v.y);
		var y = (this.z*v.x) - (this.x*v.z);
		var z = (this.x*v.y) - (this.y*v.x);

		return new Vector3D(x,y,z);
	},
	toString : function()
	{
		return "x="+this.x+",y="+this.y+",z="+this.z;
	}
};