document.write('<script type="text/javascript" src="lib/Vector3D.js"></script>');
document.write('<script type="text/javascript" src="lib/Matrix3D.js"></script>');
document.write('<script type="text/javascript" src="lib/GLSL.js"></script>');
document.write('<script type="text/javascript" src="lib/PsychoVision3D.js"></script>');
document.write('<script type="text/javascript" src="lib/Sprite2D.js"></script>');
document.write('<script type="text/javascript" src="lib/Model3D.js"></script>');
document.write('<script type="text/javascript" src="lib/BoneModel3D.js"></script>');
document.write('<script type="text/javascript" src="lib/Model2D.js"></script>');
document.write('<script type="text/javascript" src="lib/SpriteNumber.js"></script>');
document.write('<script type="text/javascript" src="lib/Material.js"></script>');
document.write('<script type="text/javascript" src="lib/TimeLine.js"></script>');

var _timeLine;
var _models = [];
var _audios = [];
var _current = 0;
var _pre = 0;
var _time = 1.0;
var _fadeTime = -1.0;
var _index = 0;
var _prePreTime = 0;
var _preTimes = [];
var _backTimes = [];
var _back = false;
var _getData = [];
var _elapsedTime = 0.0;
var _mousePos;
var _mouseDelta;
var _mouseButton = false;
var _ext = "";
var _flg = true;

function beginWebGL()
{
	var i;
	var audio = new Audio();
	if (audio.canPlayType("audio/ogg") == 'maybe') { _ext=".ogg"; }
	else if (audio.canPlayType("audio/mp3") == 'maybe') { _ext=".mp3"; }

	_mousePos = new Vector2D(0,0);
	_mouseDelta = new Vector2D(0,0);

	_timeLine = new CartoonWebPlayer(_models,_audios,_ext);

	for ( i = 0; i < _timeLine.getLength(); i++ )
	{
		if ( _timeLine.getState(i,_current) == 2 )
		{
			_models[i]._pos = _timeLine.getData(i,_current).getTrans();
			_models[i]._rotate = _timeLine.getData(i,_current).getRotate();
			_models[i]._scale = _timeLine.getData(i,_current).getScale();
			_models[i].setText(_timeLine.getWord(i,_current),0,"");
			if ( _timeLine._name[i].indexOf("FadeIn") >= 0 )
			{
				_fadeTime = 1;
			}
			else if ( _timeLine._name[i].indexOf("FadeOut") >= 0 )
			{
				_fadeTime = 0;
			}
			if ( _timeLine._name[i].indexOf("BoneModel3D") >= 0 )
			{
				_models[i].playAnimation(_timeLine.getAnimation(i,_current),_timeLine.getLoop(i,_current));
			}
			else if ( _timeLine._name[i].indexOf("Fukidashi") >= 0
			&& _timeLine.getSkip(i,_current) == 2 )
			{
				if ( _timeLine.getCheckBox(i,_current) == "" )
				{
					_models[i]._materials[1].setColor(0.9,0.9,0.9,1);
				}
				else
				{
					_models[i]._materials[1].setColor(0,0,0,1);
				}
			}
			else
			{
				if ( _timeLine._name[i].indexOf("Fukidashi") >= 0 )
				{
					executeEval(_timeLine.getWord(i,_current));
				}
				var a = _timeLine.getAudio(i,_current);
				if ( a >= 0 && a < _audios.length )
				{
					try
					{
						_audios[a].play();
					}
					catch(e)
					{
					}
					if ( _timeLine.getLoop(i,_current) == 1 )
					{
						_audios[a].loop = true;
					}
					else
					{
						_audios[a].loop = false;
					}
				}
			}
		}
	}
}

function drawWebGL()
{
	var i;
	var first = _pre - 1;
	var next = _current + 1;
	if ( first < 0 )
	{
		first = 0;
	}
	if ( next >= _timeLine.getDataLength(0) )
	{
		next = _current;
	}
	var data  = _timeLine.getData(0,first);
	var data2 = _timeLine.getData(0,_pre);
	var data3 = _timeLine.getData(0,_current);
	var data4 = _timeLine.getData(0,next);
	var trans = interpolateSpline(_time,data.getTrans(),data2.getTrans(),data3.getTrans(),data4.getTrans());
	var rotate = interpolateSpline(_time,data.getRotate(),data2.getRotate(),data3.getRotate(),data4.getRotate());
	var scale = interpolateSpline(_time,data.getScale(),data2.getScale(),data3.getScale(),data4.getScale());
	_mvMatrix.transformCamera(trans,rotate,scale);
	for ( i = 1; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("Background") >= 0 )
		{
			_models[i].draw();
		}
	}
	_gl.clear(_gl.DEPTH_BUFFER_BIT);
	for ( i = 1; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("Background") < 0
		&& _timeLine._name[i].indexOf("Effect")     < 0
		&& _timeLine._name[i].indexOf("FadeIn")     < 0
		&& _timeLine._name[i].indexOf("FadeOut")    < 0 )
		{
			data = _timeLine.getData(i,_current);
			_models[i]._pos = data.getTrans();
			_models[i]._rotate = data.getRotate();
			_models[i]._scale = data.getScale();
			var text = _timeLine.getWord(0,_current);
			var txt = text.split("￥ｎ");
			for ( var t = 0; t < txt.length; t++ )
			{
				eval(txt[t]);
			}
			_models[i].draw();
		}
	}
	_gl.clear(_gl.DEPTH_BUFFER_BIT);
	for ( i = 1; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("Effect")  >= 0 )
		{
			if ( _timeLine._name[i].indexOf("EffectBack")  >= 0 )
			{
				_models[i]._pos.z = -0.1;
			}
			else
			{
				_models[i]._pos.z = 0.001*i;
			}
			_models[i].draw();
		}
	}
	for ( i = 1; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("FadeOut")  >= 0 )
		{
			_fadeTime += _elapsed*1000.0/_timeLine._fadeTime;
			if ( _fadeTime > 1 )
			{
				_models[i].fade(1);
				_models[i].draw();
				gotoNext();
			}
			else
			{
				_models[i].fade(_fadeTime);
				_models[i].draw();
			}
		}
	}
	for ( i = 1; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("FadeIn")  >= 0 )
		{
			_fadeTime -= _elapsed*1000.0/_timeLine._fadeTime;
			if ( _fadeTime < 0 )
			{
				_models[i].fade(0);
				_models[i].draw();
				gotoNext(true);
			}
			else
			{
				_models[i].fade(_fadeTime);
				_models[i].draw();
			}
		}
	}
	if ( _back )
	{
		_time -= _elapsed*1000.0/_timeLine._cameraTime;
		if ( _time < 0 )
		{
			_pre = _preTimes[_preTimes.length-1];
			_preTimes.pop();
			_current = _backTimes[_backTimes.length-1];
			_backTimes.pop();
			_models[_index].setText(_timeLine.getWord(_index,_current),2,"");
			for ( j = 0; j < _timeLine.getDataLength(0); j++ )
			{
				var flg = false;
				for ( i = 1; i < _models.length; i++ )
				{
					if ( _timeLine.getState(i,_current) == 2
					&& (_timeLine._name[i].indexOf("FadeIn") >= 0
					|| _timeLine._name[i].indexOf("FadeOut") >= 0) )
					{
						flg = true;
					}
				}
				if ( flg )
				{
					_pre = _preTimes[_preTimes.length-1];
					_preTimes.pop();
					_current = _backTimes[_backTimes.length-1];
					_backTimes.pop();
				}
			}
			_time = 1;
			_back = false;
			for ( i = 0; i < _models.length; i++ )
			{
				if ( _timeLine.getState(i,_current) == 2 )
				{
					_models[i]._pos = _timeLine.getData(i,_current).getTrans();
					_models[i]._rotate = _timeLine.getData(i,_current).getRotate();
					_models[i]._scale = _timeLine.getData(i,_current).getScale();
					if ( _timeLine._name[i].indexOf("BoneModel3D") >= 0 )
					{
						_models[i].playAnimation(_timeLine.getAnimation(i,_current),true);
					}
					else
					{
						_models[i].setText(_timeLine.getWord(i,_current),0,"");
						var a = _timeLine.getAudio(i,_current);
						var loop = _timeLine.getLoop(i,_current);
						playSound(a,loop);
					}
				}
			}
		}
	}
	else
	{
		_time += _elapsed*1000.0/_timeLine._cameraTime;
		if ( _time > 1 )
		{
			_time = 1;
		}
	}
	_elapsedTime += _elapsed;
}

function interpolateSpline(fPercentage,pFirst,pSecond,pThird,pFourth)
{
   	var t = fPercentage;
   	var t2 = t * t;
   	var t3 = t2 * t;

	var m0 = new Vector3D();
	var m1 = new Vector3D();

   	var alpha = 0.0;

    m0.x = ((1 - alpha) / 2.0) * 
           ((pSecond.x - pFirst.x) + 
             pThird.x - pSecond.x);

    m1.x = ((1 - alpha) / 2.0) * 
           ((pThird.x - pSecond.x) + 
             pFourth.x - pThird.x);

    var x = (((2 * t3) - (3 * t2) + 1) * pSecond.x) +
                     ((t3 - (2 * t2) + t) * m0.x) +
                     ((t3 - t2) * m1.x) +
                     (((-2 * t3) + (3 * t2)) * pThird.x);

    m0.y = ((1 - alpha) / 2.0) * 
           ((pSecond.y - pFirst.y) + 
             pThird.y - pSecond.y);

    m1.y = ((1 - alpha) / 2.0) * 
           ((pThird.y - pSecond.y) + 
             pFourth.y - pThird.y);

    var y = (((2 * t3) - (3 * t2) + 1) * pSecond.y) +
                     ((t3 - (2 * t2) + t) * m0.y) +
                     ((t3 - t2) * m1.y) +
                     (((-2 * t3) + (3 * t2)) * pThird.y);

    m0.z = ((1 - alpha) / 2.0) * 
           ((pSecond.z - pFirst.z) + 
             pThird.z - pSecond.z);

    m1.z = ((1 - alpha) / 2.0) * 
           ((pThird.z - pSecond.z) + 
             pFourth.z - pThird.z);

    var z = (((2 * t3) - (3 * t2) + 1) * pSecond.z) +
                     ((t3 - (2 * t2) + t) * m0.z) +
                     ((t3 - t2) * m1.z) +
                     (((-2 * t3) + (3 * t2)) * pThird.z);

	return new Vector3D(x,y,z);
}

function getNearest(event)
{
	var distance = 10000000;
	var index = -1;
	for ( var i = 1; i < _models.length; i++ )
	{
		if ( _models[i]._visible
		&& _timeLine.getState(i,_current) == 2
		&& _timeLine._name[i].indexOf("Fukidashi") >= 0
		&& _models[i].mousePick(mouseX(event),mouseY(event)) )
		{
			if ( _models[i]._distance < distance )
			{
				index = i;
				distance = _models[i]._distance;
			}
		}
	}
	return index;
}

function onMouseDown(event)
{
	_mouseButton = true;
	if ( !_back && _time >= 1 )
	{
		var i = getNearest(event);
		if ( i >= 0 && (_fadeTime < 0 || _fadeTime > 1) )
		{
			_index = i;
			_prePreTime = _pre;
			gotoNext();
		}
		for ( i = 1; i < _models.length; i++ )
		{
			if ( _timeLine.getState(i,_current) == 2 && _timeLine._name[i].indexOf("EffectBack") >= 0
			&& mouseX(event) < _gl.viewportWidth/20 && mouseY(event) >= _gl.viewportHeight*9/10 )
			{
				stopAudio();
				if ( _preTimes.length > 0 )
				{
					_time = 1;
					_back = true;
				}
			}
		}
	}
}

function getCheckBox()
{
	var i;
	var text = "";
	for ( i = 0; i < _models.length-1; i++ )
	{
		text = _timeLine.getCheckBox(i,_current);
		if ( text != "" )
		{
			i++;
			break;
		}
	}
	for ( ; i < _models.length; i++ )
	{
		var txt = _timeLine.getCheckBox(i,_current);
		if ( txt != "" )
		text += "&" + txt;
	}
	return text;
}

function stopAudio()
{
	for ( var i = 0; i < _models.length; i++ )
	{
		var a = _timeLine.getAudio(i,_current);
		if ( a >= 0 && a < _audios.length && !_audios[a].loop )
		{
			try
			{
				_audios[a].pause();
			}
			catch(e)
			{
			}
		}
	}
}

function gotoNext(fade)
{
	var text = _timeLine.getWord(_index,_current);
	switch ( _timeLine.getSkip(_index,_current) )
	{
	case 0:
		stopAudio();
		_time = 0;
		_pre = _current;
		_timeLine.setPrompt(_index,_current,_models[_index].setText(text,1,getCheckBox(),_timeLine.getPrompt(_index,_current)));
		_current++;
		break;
	case 1:
		stopAudio();
		_time = 0;
		_pre = _current;
		_timeLine.setPrompt(_index,_current,_models[_index].setText(text,1,getCheckBox(),_timeLine.getPrompt(_index,_current)));
		_current = _timeLine.getFrame(_index,_current);
		if ( _current == 0 )
		{
			_time = 1;
			_getData = [];
		}
		break;
	case 2:
		if ( _timeLine.getCheckBox(_index,_current) == "" )
		{
			_timeLine.setCheckBox(_index,_current,text);
			_models[_index]._materials[1].setColor(0,0,0,1);
		}
		else
		{
			_timeLine.setCheckBox(_index,_current,"");
			_models[_index]._materials[1].setColor(0.9,0.9,0.9,1);
		}
		return;
	case 3:
		return;
	}
	if ( fade )
	{
		_time = 1;
	}
	for ( var i = 0; i < _models.length; i++ )
	{
		if ( _timeLine.getState(i,_current) == 2 )
		{
			_models[i]._pos = _timeLine.getData(i,_current).getTrans();
			_models[i]._rotate = _timeLine.getData(i,_current).getRotate();
			_models[i]._scale = _timeLine.getData(i,_current).getScale();
			if ( _timeLine.getState(i,_current) == 2
			&& _timeLine._name[i].indexOf("FadeIn") >= 0 )
			{
				_fadeTime = 1;
			}
			else if ( _timeLine.getState(i,_current) == 2
			&& _timeLine._name[i].indexOf("FadeOut") >= 0 )
			{
				_fadeTime = 0;
			}
			if ( _timeLine.getState(i,_current) == 2
			&& _timeLine._name[i].indexOf("BoneModel3D") >= 0 )
			{
				_models[i].playAnimation(_timeLine.getAnimation(i,_current),_timeLine.getLoop(i,_current));
			}
			else if ( _timeLine._name[i].indexOf("Fukidashi") >= 0
			&& _timeLine.getSkip(i,_current) == 2 )
			{
				if ( _timeLine.getCheckBox(i,_current) == "" )
				{
					_models[i]._materials[1].setColor(0.9,0.9,0.9,1);
				}
				else
				{
					_models[i]._materials[1].setColor(0,0,0,1);
				}
				_models[i].setText(_timeLine.getWord(i,_current),0,"");
				var time = _timeLine.getCamera(i,_current);
				if ( time >= 0 ) _time = time;
			}
			else
			{
				if ( _timeLine._name[i].indexOf("Fukidashi") >= 0 )
				{
					executeEval(_timeLine.getWord(i,_current));
				}
				_models[i].setText(_timeLine.getWord(i,_current),0,"");
				var time = _timeLine.getCamera(i,_current);
				if ( time >= 0 ) _time = time;
				var a = _timeLine.getAudio(i,_current);
				var loop = _timeLine.getLoop(i,_current);
				playSound(a,loop);
			}
		}
	}
	_preTimes.push(_prePreTime);
	_backTimes.push(_pre);
}

function playSound(a,loop)
{
	if ( _flg ) loadAudio();
	if ( a >= 0 )
	{
		if ( a < _audios.length )
		{
			try
			{
				_audios[a].currentTime = 0;
				_audios[a].play();
			}
			catch (e)
			{
				_audios[a].play();
			}
			if ( loop == 1 )
			{
				_audios[a].loop = true;
			}
			else
			{
				_audios[a].loop = false;
			}
		}
		else for ( a = 0; a < _audios.length; a++ )
		{
			try
			{
				_audios[a].pause();
				_audios[a].loop = false;
			}
			catch (e)
			{
			}
		}
	}
}

function loadAudio()
{
	for ( a = 0; a < _audios.length; a++ )
	{
		_audios[a].load();
	}
	_flg = false;
}

function executeEval(text)
{
	var txt = text.split("￥ｎ");
	if ( txt.length <= 0 )
	{
		return;
	}
	var index = txt[0].indexOf(";");
	if ( index >= 0 )
	{
		if ( index == txt[0].length-1 )
		{
			eval(txt[0]);
		}
	}
}

function onMouseUp(event)
{
	_mouseButton = false;
}

function onMouseMove(event)
{
	_mouseDelta.x = mouseX(event)-_mousePos.x;
	_mouseDelta.y = mouseY(event)-_mousePos.y;
	_mousePos.x = mouseX(event);
	_mousePos.y = mouseY(event);
}

function onKeyDown(event)
{
}

function onKeyUp(event)
{
}
