/********************************************************************************/
/*                                                                              */
/*		Cyberdelia.cpp															*/
/*                                                                              */
/********************************************************************************/

#include "stdafx.h"
#include "Centigrade.h"


/********************************************************************************/
/*                                                                              */
/*		JgfBNgB̎擾											*/
/*                                                                              */
/********************************************************************************/

char* Directory(void)
{
	static int i;
	static char Buffer[256];

	// JgfBNgB̎擾
	GetModuleFileName(NULL,Buffer,256);

	for (i=(int)strlen(Buffer);Buffer[i]!='\\';i--) Buffer[i]=NULL;

	return Buffer;
}

/********************************************************************************/
/*                                                                              */
/*																			*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::Init()
{
	materials.clear();
	models.clear();
	models.push_back(CModel());

	// J̏ݒ
	camera.SetRotate(CVector(20.0f,10.0f,0.0f));
	camera.SetMove(CVector(0.0f,0.0f,-2000.0f));

	angleView = 10.0f;

	bSmooth = TRUE;

	// wiF̏ݒ
	bgColor = RGB(30, 65, 90);

	material_number = 0;

	SetZoom(100);

	SetEditMode(EM_SELECT);
}

/********************************************************************************/
/*                                                                              */
/*		}eÃZbg														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetMaterials()
{
	for( vector<CMaterial>::iterator mat=materials.begin(); mat!=materials.end(); ++mat )
	{
		mat->SetMaterialGL();
	}
}
/********************************************************************************/
/*                                                                              */
/*		쐬																	*/
/*                                                                              */
/********************************************************************************/

int CCentigrade::OnCreate(HWND wnd)
{
	Init();
	// sNZtH[}bg̋Lq
	PIXELFORMATDESCRIPTOR pfd =
	{
		sizeof(PIXELFORMATDESCRIPTOR),
		1,						// Version
		PFD_DRAW_TO_WINDOW |	// Supports GDI
		PFD_SUPPORT_OPENGL |	// Supports OpenGL
		PFD_DOUBLEBUFFER,		// Use double buffering (more efficient drawing)
		PFD_TYPE_RGBA,			// No pallettes
		24, 					// Number of color planes
		 						// in each color buffer
		8,	0,					// for Red-component
		8,	0,					// for Green-component
		8,	0,					// for Blue-component
		8,	0,					// for Alpha-component
		0,						// Number of planes
								// of Accumulation buffer
		16,						// for Red-component
		16,						// for Green-component
		16,						// for Blue-component
		16,						// for Alpha-component
		24, 					// Depth of Z-buffer
		0,						// Depth of Stencil-buffer
		0,						// Depth of Auxiliary-buffer
		0,						// Now is ignored
		0,						// Number of planes
		0,						// Now is ignored
		0,						// Color of transparent mask
		0						// Now is ignored
	};

	hWnd = wnd;

	// EBhEReLXg̎擾
	hDC = ::GetDC(wnd);

	// vł߂sNZtH[}bg̑I
	int iD = ChoosePixelFormat(hDC, &pfd);
	if ( !iD )
	{
		AfxMessageBox("ChoosePixelFormat::Error");
		return -1;
	}

	// sNZtH[}bg̃Zbg
	if ( !SetPixelFormat(hDC, iD, &pfd) )
	{
		AfxMessageBox("SetPixelFormat::Error");
		return -1;
	}

	// OpenGL_OReLXg쐬
	if ( !(hRC = wglCreateContext(hDC)))
	{
		AfxMessageBox("wglCreateContext::Error");
		return -1;
	}

	// OpenGL_OReLXgCN
	if ( !wglMakeCurrent(hDC, hRC))
	{
		AfxMessageBox("wglMakeCurrent::Error");
		return -1;
	}

	// Zobt@[xL
	glEnable(GL_DEPTH_TEST);
	// |S̕Жʂ`L
	glEnable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
	// @xNg̐K
	glEnable(GL_NORMALIZE);
	// Cg0L
	glEnable(GL_LIGHT0);
	// At@uhL
	glEnable(GL_BLEND);
	// uht@NV
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	// eNX`̐ݒ
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	// wiF̐ݒ
	SetBkColor();

	return 0;
}

/********************************************************************************/
/*                                                                              */
/*		j																	*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::OnDestroy()
{
	ReleaseAll();

	//JgReLXg
	wglMakeCurrent(NULL, NULL);
	if(hRC)
	{
		//
		wglDeleteContext(hRC);
	}
	else
	{
		//OpenGL_OReLXgȂ
		AfxMessageBox("Release HGLRC Failed....");
	}
	if(hDC)
	{
		//
		ReleaseDC(hWnd, hDC);
	}
	else
	{
		//foCXReLXgȂ
		AfxMessageBox("Release HDC Failed....");
	}
}

/********************************************************************************/
/*                                                                              */
/*		Cg̐ݒ															*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetLight()
{
	GLfloat lightPosition[]  = {0.0f, 0.0f, 1.0f, 0.0f};
	GLfloat lightAmbient[]   = {1.0f, 1.0f, 1.0f, 1.0f};
	GLfloat lightDiffuse[]   = {1.0f, 1.0f, 1.0f, 1.0f};
	GLfloat lightEmission[]  = {1.0f, 1.0f, 1.0f, 1.0f};
	GLfloat lightSpecular[]  = {1.0f, 1.0f, 1.0f, 1.0f};

	glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, GL_FALSE);
	glLightfv(GL_LIGHT0, GL_POSITION,  lightPosition);
	glLightfv(GL_LIGHT0, GL_AMBIENT,   lightAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE,   lightDiffuse);
	glLightfv(GL_LIGHT0, GL_EMISSION,  lightEmission);
	glLightfv(GL_LIGHT0, GL_SPECULAR,  lightSpecular);
}

/********************************************************************************/
/*                                                                              */
/*		wiF																	*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetBkColor()
{
	GLclampf red	= GetRValue(bgColor)/255.f,
			 green	= GetGValue(bgColor)/255.f,
			 blue	= GetBValue(bgColor)/255.f;

	// NA[wiF̐ݒ
	glClearColor (red, green, blue, 0.f);

	// obNOEhNA[
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

/********************************************************************************/
/*                                                                              */
/*		ʃTCYύXꂽƂ												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::OnSize(int cx, int cy)
{
	width = (float)cx;
	height = (float)cy;
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(angleView, double(cx)/cy, 100.0f, 10000.0f);
	glViewport(0, 0, cx, cy);
}

/********************************************************************************/
/*                                                                              */
/*		OpenGL̃_O													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::Rendering()
{
	wglMakeCurrent (hDC, hRC);

	// wiZobt@̃NA
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	// fr[sɐݒ
	glMatrixMode(GL_MODELVIEW);

	glLoadIdentity();

	// Cg̃Zbg
	SetLight();

	// Jʒüړ
	camera.Translate();
	// JAỎ]
	camera.Rotate();
	// J̃XP[O
	camera.Scale(zoom);

	// Sf̕`
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawPrimitive(bSmooth,materials);
	}

	// obNobt@ƃtgobt@̃XBb`
	SwapBuffers(hDC);
}

/********************************************************************************/
/*                                                                              */
/*		X[YVF[fBOƃtbgVF[fBO̐؂ւ				*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SmoothShading(BOOL bSmooth)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawPrimitive(bSmooth,materials);
	}
}

/********************************************************************************/
/*                                                                              */
/*		eNX`̃Zbg														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::LoadTextures()
{
	for( vector<CMaterial>::iterator mat = materials.begin(); mat != materials.end(); ++mat )
	{
		mat->LoadTextureGL();
	}
}

/********************************************************************************/
/*                                                                              */
/*		CCentigrade::ReleaseAll													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::ReleaseAll()
{
	for ( vector<CMaterial>::iterator mat=materials.begin(); mat!=materials.end(); ++mat )
	{
		mat->ReleaseTextureGL();
	}
}

/********************************************************************************/
/*                                                                              */
/*		CA[t[̕`												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DrawWireFrame(CDC* pDC,ANGLE angle,CPoint center)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawWireFrame(pDC,angle,center,zoom,false);
	}

	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawWireFrame(pDC,angle,center,zoom,true);
	}
}

/********************************************************************************/
/*                                                                              */
/*		SĂ̖@̌vZ														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::CalcNormals()
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->CalcNormals(bSmooth);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̓_̕`															*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DrawVertices(CDC* pDC,ANGLE angle,CPoint center)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawVertices(pDC,angle,center,zoom,false);
	}
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DrawVertices(pDC,angle,center,zoom,true);
	}
}

/********************************************************************************/
/*                                                                              */
/*		IE钷`̘g												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::Rectangle(CDC* pDC,CPoint first,CPoint current)
{
    CPen pen;  // Construct it, then initialize

	if( pen.CreatePen( PS_SOLID, 1, RGB(0,255,0) ) )
    {
        // Select it into the device context
        // Save the old pen at the same time
        CPen* pOldPen = pDC->SelectObject( &pen );

		pDC->MoveTo( first.x, first.y );
		pDC->LineTo( first.x, current.y );
		pDC->LineTo( current.x, current.y );
		pDC->LineTo( current.x, first.y );
		pDC->LineTo( first.x, first.y );

        // Restore the old pen to the device context
        pDC->SelectObject( pOldPen );
    }
	pen.DeleteObject();
}


/********************************************************************************/
/*                                                                              */
/*		_̑IE														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center)
{
	// _̑IE
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->SelectVertices(rect,angle,select,center,zoom);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̈ړ																*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesMove(float x,float y, float z)
{
	x = x/zoom*100;
	y = y/zoom*100;
	z = z/zoom*100;

	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesMove(x,y,z);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesRotate(ANGLE angle,float rotate,CPoint center)
{
	center = CPoint(int(center.x/zoom*100),int(center.y/zoom*100));

	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesRotate(angle,rotate,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesRotate(ANGLE angle,float rotate,CVector center)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesRotate(angle,rotate,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̊gEk														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesSize(ANGLE angle,float size,CPoint center)
{
	center = CPoint(int(center.x/zoom*100),int(center.y/zoom*100));
	size /= zoom;

	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesSize(angle,size,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̃Xgb`														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center)
{
	center = CPoint(int(center.x/zoom*100),int(center.y/zoom*100));
	sizeX /= zoom;
	sizeY /= zoom;

	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesStretch(angle,sizeX,sizeY,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̃Xgb`														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::AddVerticesStretch(CVector v,CVector center)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->AddVerticesStretch(v,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		Obh̕`														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::Grid(CDC* pDC,CRect rect,CPoint center)
{
	CPen pen;  // Construct it, then initialize
    if( pen.CreatePen( PS_SOLID, 1, RGB(192,192,192) ) )
    {
        // Select it into the device context
        // Save the old pen at the same time
        CPen* pOldPen = pDC->SelectObject( &pen );

        // Draw with the pen
		pDC->MoveTo( 0, center.y );
		pDC->LineTo( rect.right, center.y );
		pDC->MoveTo( center.x, 0 );
		pDC->LineTo( center.x, rect.bottom );

        // Restore the old pen to the device context
        pDC->SelectObject( pOldPen );
    }
	pen.DeleteObject();

    if( pen.CreatePen( PS_DOT, 1, RGB(192,192,192) ) )
    {
        // Select it into the device context
        // Save the old pen at the same time
        CPen* pOldPen = pDC->SelectObject( &pen );

		pDC->MoveTo( 0, center.y-(int)zoom );
		pDC->LineTo( rect.right, center.y-(int)zoom );
		pDC->MoveTo( 0, center.y+(int)zoom );
		pDC->LineTo( rect.right, center.y+(int)zoom );
		pDC->MoveTo( center.x-(int)zoom, 0 );
		pDC->LineTo( center.x-(int)zoom, rect.bottom );
		pDC->MoveTo( center.x+(int)zoom, 0 );
		pDC->LineTo( center.x+(int)zoom, rect.bottom );

        // Restore the old pen to the device context
        pDC->SelectObject( pOldPen );
    }
	pen.DeleteObject();

    if( pen.CreatePen( PS_DOT, 1, RGB(192,192,192) ) )
    {
        // Select it into the device context
        // Save the old pen at the same time
        CPen* pOldPen = pDC->SelectObject( &pen );

		pDC->MoveTo( 0, center.y-(int)zoom/2 );
		pDC->LineTo( rect.right, center.y-(int)zoom/2 );
		pDC->MoveTo( 0, center.y+(int)zoom/2 );
		pDC->LineTo( rect.right, center.y+(int)zoom/2 );
		pDC->MoveTo( center.x-(int)zoom/2, 0 );
		pDC->LineTo( center.x-(int)zoom/2, rect.bottom );
		pDC->MoveTo( center.x+(int)zoom/2, 0 );
		pDC->LineTo( center.x+(int)zoom/2, rect.bottom );

        // Restore the old pen to the device context
        pDC->SelectObject( pOldPen );
    }
	pen.DeleteObject();
}

/********************************************************************************/
/*                                                                              */
/*		If̍폜														*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DeleteModel()
{
	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		models.erase(models.begin()+current_model);
	}
}

/********************************************************************************/
/*                                                                              */
/*		I}eA̍폜													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DeleteMaterial()
{
	if ( current_material >= 0 && current_material < (int)materials.size() )
	{
		materials.erase(materials.begin()+current_material);
	}
}
/********************************************************************************/
/*                                                                              */
/*		I}eA̐ݒ													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetMaterial(CMaterial mat)
{
	if ( current_material >= 0 && current_material < (int)materials.size() )
	{
		materials[current_material] = mat;
		materials[current_material].SetMaterialGL();
	}
}

/********************************************************************************/
/*                                                                              */
/*		f̑S_̑I													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SelectModelVertices(bool b)
{
	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		models[current_model].SelectModelVertices(b);
	}
}

/********************************************************************************/
/*                                                                              */
/*		I𒆂̃f̖OύX												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetCurrentModelName(CString name)
{
	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		models[current_model].SetName(name);
	}
}

/********************************************************************************/
/*                                                                              */
/*		I𒆂̃}eA̖OύX											*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetCurrentMaterialName(CString name)
{
	if ( current_material >= 0 && current_material < (int)materials.size() )
	{
		materials[current_material].SetName(name);
	}
}

/********************************************************************************/
/*                                                                              */
/*		̃fƓւ												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::MoveUp()
{
	if ( current_model >= 1 && current_model < (int)models.size() )
	{
		CModel model = models[current_model];
		models[current_model] = models[current_model-1];
		models[current_model-1] = model;
	}
}

/********************************************************************************/
/*                                                                              */
/*		̃fƓւ												*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::MoveDown()
{
	if ( current_model >= 0 && current_model < (int)models.size()-1 )
	{
		CModel model = models[current_model];
		models[current_model] = models[current_model+1];
		models[current_model+1] = model;
	}
}

/********************************************************************************/
/*                                                                              */
/*		̃fƍ													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SynthesisUp()
{
	if ( current_model >= 1 && current_model < (int)models.size() )
	{
		models[current_model-1] += models[current_model];
		models.erase(models.begin()+current_model);
	}
}

/********************************************************************************/
/*                                                                              */
/*		̃fƍ													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SynthesisDown()
{
	if ( current_model >= 0 && current_model < (int)models.size()-1 )
	{
		models[current_model+1] += models[current_model];
		models.erase(models.begin()+current_model);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʂɌ݂̍ގw													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetMaterial()
{
	if ( current_material >= 0 && current_material < (int)materials.size() )
	{
		for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
		{
			model->SetMaterial(materials[current_material].GetNumber());
		}
		SetUV(current_material);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_폜																*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DeleteVertices()
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->DeleteVertices();
		model->FacesVertexBelongsTo();
	}
}

/********************************************************************************/
/*                                                                              */
/*		_SIEI													*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SelectAllVertices(bool b)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->SelectModelVertices(b);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬̕`															*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::DrawMakePolygon(CDC* pDC,ANGLE angle,CPoint center,CRect rect)
{
	CPen pen;

	if( !pen.CreatePen( PS_SOLID, 1, RGB(0,0,255) ) ) return;

	// Select it into the device context
	// Save the old pen at the same time
	CPen* pOldPen = pDC->SelectObject( &pen );

	switch ( angle )
	{
	case ANGLE_TOP:
		pDC->MoveTo(coord.x+center.x,0);
		pDC->LineTo(coord.x+center.x,rect.bottom);
		pDC->MoveTo(0,coord.z+center.y);
		pDC->LineTo(rect.right,coord.z+center.y);
		break;
	case ANGLE_FACE:
		pDC->MoveTo(coord.x+center.x,0);
		pDC->LineTo(coord.x+center.x,rect.bottom);
		pDC->MoveTo(0,coord.y+center.y);
		pDC->LineTo(rect.right,coord.y+center.y);
		break;
	case ANGLE_LEFT:
		pDC->MoveTo(center.x-coord.z,0);
		pDC->LineTo(center.x-coord.z,rect.bottom);
		pDC->MoveTo(0,coord.y+center.y);
		pDC->LineTo(rect.right,coord.y+center.y);
		break;
	}

	// Restore the old pen to the device context
	pDC->SelectObject( pOldPen );

	pen.DeleteObject();

	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		models[current_model].DrawMakePolygon(pDC,angle,center,zoom);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬																	*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::MakePolygon(ANGLE angle,CPoint point,CPoint center)
{
	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		switch( angle )
		{
		case ANGLE_TOP:
			models[current_model].MakePolygon(
				CPoint3(point.x-center.x,-coord.y,point.y-center.y),
				zoom,current_material);
			break;
		case ANGLE_FACE:
			models[current_model].MakePolygon(
				CPoint3(point.x-center.x,center.y-point.y,coord.z),
				zoom,current_material);
			break;
		case ANGLE_LEFT:
			models[current_model].MakePolygon(
				CPoint3(coord.x,center.y-point.y,center.x-point.x),
				zoom,current_material);
			break;
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬																	*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetPolygon()
{
	if ( current_model >= 0 && current_model < (int)models.size() )
	{
		models[current_model].SetPolygon(current_material);
	}
}

/********************************************************************************/
/*                                                                              */
/*		UVW̐ݒ															*/
/*                                                                              */
/********************************************************************************/

void CCentigrade::SetUV(int material_number)
{
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->SetUV(material_number);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ACR̐F															*/
/*                                                                              */
/********************************************************************************/

UINT CCentigrade::GetImageColor(int material)
{
	if ( material >= 0 && material < (int)materials.size() )
	{
		return materials[material].GetImageColor();
	}

	return 1;
}
