/********************************************************************************/
/*                                                                              */
/*		Cyberdelia.h															*/
/*                                                                              */
/********************************************************************************/


#pragma once


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <sys/timeb.h>

#include <GL/gl.h>
#include <GL/glu.h>

#include "DibLib.h"
#include "FileLib.h"

#include <vector>

using namespace std;


#define	TEXTURE_SIZE			256
#define PI						3.14159265359f
#define PI2						(PI*2)
#define DEGREE(val)				(val/360.0f*PI2)
#define ROOT_NAME				"<NULL>"
#define BUFFER_SIZE				512

#define LIST_SEL_STATE (LVIS_FOCUSED|LVIS_SELECTED)

enum ANGLE { ANGLE_TOP,ANGLE_FACE,ANGLE_LEFT };
enum EDIT_MODE { EM_SELECT,EM_MOVE,EM_ROTATE,EM_SIZE,EM_STRETCH,EM_MAKE_POLYGON,EM_MAKE_BOX };
enum UMsg { UM_REDRAW, UM_REDRAW_OPEN_GL, };

char* Directory(void);


/********************************************************************************/
/*                                                                              */
/*		CPoint3\															*/
/*                                                                              */
/********************************************************************************/

typedef struct CPoint3
{
	int x,y,z;
	CPoint3() { x = y = z = 0; }
	CPoint3(int _x,int _y,int _z) { x = _x; y = _y; z = _z; }
} CPoint3;

/********************************************************************************/
/*                                                                              */
/*		ގNX																*/
/*                                                                              */
/********************************************************************************/

#define RELEASEDIB(dib) if( dib != NULL ) { delete dib; dib = NULL; }

class CMaterial : public CObject
{
public:
	CMaterial();
	CMaterial(int material_number);
	CMaterial(int material_number,CString name,float r,float g,float b,float a,float diffuse,
			  float ambient,float emissive,float specular,float power,CString texture_name);
	~CMaterial(){}
	DECLARE_SERIAL(CMaterial)

protected:
	int number;
	CString name;
	float r, g, b, a;
	int shader;
	float diffuse;
	float ambient;
	float emissive;
	float specular;
	float power;
	CString texture_name;
	CString alpha_name;
	CString bump_name;
	GLuint texName;
	DibStream* textureGL;
	float dif[4];
	float amb[4];
	float spc[4];
	float emi[4];
	int planes;
	int format;

public:
	void SetNumber(int number) { this->number = number; }
	int GetNumber() const { return number; }
	void SetName(CString name) { this->name = name; }
	CString GetName() { return name; }
	void SetRGBA(float r,float g,float b,float a)
		{ this->r = r; this->g = g; this->b = b; this->a = a; }
	float GetR() const { return r; }
	float GetG() const { return g; }
	float GetB() const { return b; }
	float GetA() const { return a; }
	void SetShader(int shader) { this->shader = shader; }
	int GetShader() { return shader; }
	void SetDiffuse(float diffuse) { this->diffuse = diffuse; }
	float GetDiffuse() { return diffuse; }
	void SetAmbient(float ambient) { this->ambient = ambient; }
	float GetAmbient() { return ambient; }
	void SetEmissive(float emissive) { this->emissive = emissive; }
	float GetEmissive() { return emissive; }
	void SetSpecular(float specular) { this->specular = specular; }
	float GetSpecular() { return specular; }
	float *GetDif() { return dif; }
	float *GetAmb() { return amb; }
	float *GetSpc() { return spc; }
	float *GetEmi() { return emi; }
	void SetPower(float power) { this->power = power; }
	float GetPower() { return power; }
	void SetTextureName(CString texture_name) { this->texture_name = texture_name; }
	CString GetTextureName() const { return texture_name; }
	void SetAlphaName(CString alpha_name) { this->alpha_name = alpha_name; }
	CString GetAlphaName() const { return alpha_name; }
	void SetBumpName(CString bump_name) { this->bump_name = bump_name; }
	CString GetBumpName() const { return bump_name; }
	int GetPlanes() const { return planes; }
	int GetFormat() const { return format; }
	void SetMaterial();
	void SetMaterialGL();
	void LoadTextureGL();
	void ReleaseTextureGL() { glDeleteTextures(1,&texName); RELEASEDIB(textureGL); }
	bool SaveMQOMaterial(FILE *fp);
	UINT GetImageColor();

public:
	CMaterial& operator=(const CMaterial& pt);
	CMaterial (const CMaterial& pt) { *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		WNX																*/
/*                                                                              */
/********************************************************************************/

class CVector : public CObject
{
public:
	CVector(float x, float y, float z) { this->x = x; this->y = y; this->z = z; }
	CVector() { x = 0; y = 0; z = 0; }
	DECLARE_SERIAL(CVector)

protected:
	float x, y, z;

public:
	void SetVector(float x,float y,float z) { this->x = x; this->y = y; this->z = z; }
	void SetX(float x) { this->x = x; }
	void SetY(float y) { this->y = y; }
	void SetZ(float z) { this->z = z; }
	void AddZ(float z) { this->z += z; }
	float GetX() const { return x; }
	float GetY() const { return y; }
	float GetZ() const { return z; }
	void AddVector(float x,float y,float z) { this->x += x; this->y += y; this->z += z; }

	void Translate() { glTranslatef(x,y,z); }
	void Rotate() { glRotatef(x, 1.0f, 0.0f, 0.0f); glRotatef(y, 0.0f, 1.0f, 0.0f); glRotatef(z, 0.0f, 0.0f, 1.0f); }
	void Scale() { glScalef(x,y,z); }
	void Scale(float zoom) { glScalef(zoom/100,zoom/100,zoom/100); }
	void CrossProduct(const CVector& a,const CVector& b);

	void SetNormal() { glNormal3f(-x,-y,-z); }
	void SetVertex() { glVertex3f(x,y,z); }

	float abs(){ return sqrt(x*x + y*y + z*z); }
	void  multiply( float k ){ x*=k; y*=k; z*=k; }
	void  normalize();

	CVector& operator -() { x = -x; y = -y; z = -z; return *this; }
	CVector  operator -(const CVector& pt);
	CVector& operator =(const CVector& pt);
	CVector& operator+=(const CVector& pt);
	CVector& operator-=(const CVector& pt);
	CVector& operator*=(const CVector& pt);
	CVector operator/=( float a );
	bool operator==(const CVector& pt);
	bool operator!=(const CVector& pt);
	CVector (const CVector& pt) { *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		_NX																*/
/*                                                                              */
/********************************************************************************/

class CVertex : public CObject
{
public:
	DECLARE_SERIAL(CVertex)
	CVertex() { pos = CVector(); selected = false; }
	CVertex(CVector pos) { this->pos = pos; selected = false; }
	CVertex(float x, float y, float z) { pos = CVector(x,y,z); selected = false; }

protected:
	CVector pos;
	CVector normal;
	std::vector < int > have_faces;
	bool selected;
	bool flag;

public:
	CVector GetPos() const { return pos; }
	float GetPosX() const { return pos.GetX(); }
	float GetPosY() const { return pos.GetY(); }
	float GetPosZ() const { return pos.GetZ(); }
	void SetPos(CVector v) { pos = v; }
	void SetPosX(float x) { pos.SetX(x); }
	void SetPosY(float y) { pos.SetY(y); }
	void SetPosZ(float z) { pos.SetZ(z); }
	void SetPos(float x,float y,float z) { pos = CVector(x,y,z); }
	void AddPos(float x,float y,float z) { pos += CVector(x,y,z); }
	CVector GetNormal() const { return normal; }
	void SetNormal(CVector v) { normal = v; }
	void PushBackHaveFaces(int f) { have_faces.push_back(f); }
	void ClearHaveFaces() { have_faces.clear(); }
	int GetHaveFacesSize() { return (int)have_faces.size(); }
	int GetHaveFaces(int f) { return have_faces[f]; }
	void Vertex() { pos.SetVertex(); }
	void Normal() { normal.SetNormal(); }
	void Normalize() { normal.normalize(); }
	void AddNormal(const CVector& v) { normal += v; }
	void DrawVertices(CDC* pDC,ANGLE angle,CPoint center,float zoom,CBrush color);
	void SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center,float zoom);
	void AddVerticesMove(float x,float y, float z) { if ( selected ) AddPos(x,y,z); }
	void AddVerticesRotate(ANGLE angle,float rotate,CPoint center);
	void AddVerticesRotate(ANGLE angle,float rotate,CVector center);
	void AddVerticesSize(ANGLE angle,float size,CPoint center);
	void AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center);
	void AddVerticesStretch(CVector v,CVector center);
	void SetSelect(bool select) { selected = select; };
	bool GetSelect() { return selected; };
	void SetFlag(bool f) { flag = f; }
	bool GetFlag() { return flag; }

public:
	CVertex& operator=(const CVertex& pt);
	CVertex (const CVertex& pt){ *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		UVWNX															*/
/*                                                                              */
/********************************************************************************/

class CUV : public CObject
{
public:
	CUV() { u = 0.0; v = 0.0; };
	CUV(float u,float v) { this->u = u; this->v = v; }
	DECLARE_SERIAL(CUV)

private:
	float u,v;

public:
	void SetU(float u) { this->u = u; }
	float GetU() { return u; }
	void SetV(float v) { this->v = v; }
	float GetV() { return v; }
	void SetTexCoord() { glTexCoord2f(u,-v); }

public:
	CUV& operator=(const CUV& pt) { u = pt.u; v = pt.v; return *this; };
	CUV (const CUV& pt) { *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		ʃNX																*/
/*                                                                              */
/********************************************************************************/

class CFace : public CObject
{
public:
	CFace() { selected = false; index.clear(); uv.clear(); }
	~CFace() {}
	DECLARE_SERIAL(CFace)

protected:
	int material;
	std::vector < int > index;
	std::vector < CUV > uv;
	CVector normal;
	bool selected;

public:
	void SetMaterialNumber(int material) { this->material = material; }
	int GetMaterialNumber() const { return material; }
	void AddMaterialNumber(int a) { material += a; }
	void PushBackIndex(int i) { index.push_back(i); }
	int GetIndexSize() const { return (int)index.size(); }
	int GetIndex(int i) const { return index[i]; }
	void SetIndex(int i,int a) { index[i] = a; }
	void AddIndex(int a) { for ( int i = 0; i < (int)index.size(); ++i ) index[i] += a; }
	void AddIndex(int i,int a) { index[i] += a; }
	float GetU(int i) { return uv[i].GetU(); }
	float GetV(int i) { return uv[i].GetV(); }
	int GetUVSize() { return (int)uv.size(); }
	void SetTexCood(int i) { uv[i].SetTexCoord(); }
	void PushBackUV(const CUV& i) { uv.push_back(i); }
	void SetDefaultUV()
	{
		float u[4] = {0,0,1,1}; 
		float v[4] = {0,1,1,0}; 
		for ( int i = 0; i < GetUVSize(); ++i )
		{
			uv[i].SetU(u[i]);
			uv[i].SetV(v[i]);
		}
	}
	void ClearUV() { uv.clear(); }
	void SetNormal(CVector normal) { this->normal = normal; }
	CVector GetNormal() const { return normal; }
	void Normalize() { normal.normalize(); }
	void CrossProduct(const CVector& a,const CVector& b) { normal.CrossProduct(a,b); }
	CFace GetMirrorFace(const CFace& pt,int size);
	void SetSelect(bool b) { selected = b; }
	bool GetSelect() { return selected; }

public:
	CFace& operator=(const CFace& pt);
	CFace (const CFace& pt){ *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		Aj[VNX													*/
/*                                                                              */
/********************************************************************************/

class CAnimation : public CObject
{
public:
	CAnimation() { Init(); }
	DECLARE_SERIAL(CAnimation)

private:
	CVector move;
	CVector rotate;
	CVector scale;
	int key;

public:
	void SetKey(int key) { this->key = key; }
	int GetKey() { return key; }
	int GetAnimationKey() { return key; }
	void SetMove(CVector move) { this->move = move; }
	CVector AddMove(CVector move) { return (this->move += move); }
	CVector AddMove(float x,float y,float z) { return move += CVector(x,y,z); }
	void AddMoveZ(float z) { move.AddZ(z); }
	CVector GetMove() { return move; }
	void SetRotate(CVector rotate) { this->rotate = rotate; }
	CVector AddRotate(CVector rotate) { return (this->rotate += rotate); }
	CVector AddRotate(float x,float y,float z) { return rotate += CVector(x,y,z); }
	CVector GetRotate() { return rotate; }
	void SetScale(CVector scale) { this->scale = scale; }
	CVector AddScale(CVector scale) { return (this->scale += scale); }
	CVector GetScale() { return scale; }
	void Init();
	void SetTransform(const CAnimation& pt);
	void AddTransform();
	void Translate() { move.Translate(); }
	void Rotate() { rotate.Rotate(); }
	void Scale(float zoom) { scale.Scale(zoom); }

public:
	CAnimation& operator=(const CAnimation& pt);
	CAnimation (const CAnimation& pt) { *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		fNX															*/
/*                                                                              */
/********************************************************************************/

class CModel : public CObject
{
public:
	CModel();
	~CModel() {}
	DECLARE_SERIAL(CModel)

protected:
	// f
	CString name;
	// f̐e
	int	parent;
	// e̖O
	CString parent_name;
	// ~[̎
	int mirror_axis;
	float facet;
	// _z
	std::vector < CVertex > vertices;
	// ʔz
	std::vector < CFace > faces;
	// 
	int state;
	// 쐬̖
	CFace polygon;
	std::vector < CVertex > polygon_vertices;

public:
	void SetState(int s) { state = s; }
	UINT AddState(int s) { state += s; if ( state > 3 ) state = 1; return state; }
	UINT GetState() { return state; }
	void SetName(CString name) { this->name = name; }
	CString GetName() { return name; }
	void SetParent(int parent) { this->parent = parent; }
	int GetParent() { return parent; }
	void SetParentName(CString name) { this->parent_name = parent_name; }
	CString GetParentName() { return parent_name; }
	void SetMirrorAxis(int mirror_axis) { this->mirror_axis = mirror_axis; }
	int GetMirrorAxis() { return mirror_axis; }
	void SetFacet(float facet) { this->facet = facet; }
	float GetFacet() { return facet; }
	void PushBackVertex(const CVertex& v) { vertices.push_back(v); }
	void PushBackFace(const CFace& f) { faces.push_back(f); }
	void CalcNormals(BOOL bSmooth);
	void FacesVertexBelongsTo();
	bool Freeze(CModel *model);
	void DrawPrimitive(BOOL bSmooth,std::vector<CMaterial> &materials);
	void DrawWireFrame(CDC* pDC,ANGLE angle,CPoint center,const float zoom,bool select);
	void Line(CDC* pDC,ANGLE angle,const CVertex& v1,const CVertex& v2,CPoint center,float zoom);
	void DrawVertices(CDC* pDC,ANGLE angle,CPoint center,float zoom,bool select);
	void SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center,float zoom);
	void AddVerticesMove(float x,float y, float z);
	void AddVerticesRotate(ANGLE angle,float rotate,CPoint center);
	void AddVerticesRotate(ANGLE angle,float rotate,CVector center);
	void AddVerticesSize(ANGLE angle,float size,CPoint center);
	void AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center);
	void AddVerticesStretch(CVector v,CVector center);
	bool SaveMQOModel(FILE *fp);
	void SelectModelVertices(bool b);
	void SetMaterial(int material_number);
	void DeleteVertices();
	void SetSelectFaces();
	void DrawMakePolygon(CDC* pDC,ANGLE angle,CPoint center,const float zoom);
	void MakePolygon(CPoint3 point,const float zoom,const int material);
	void SetPolygon(int material);
	void SetUV(int material_number);

public:
	CModel& operator=(const CModel& pt);
	CModel& operator+=(CModel& pt);
	CModel (const CModel& pt) { *this = pt; }

// Implementation
public:
	virtual void Serialize(CArchive& ar);
};

/********************************************************************************/
/*                                                                              */
/*		CCentigradeBaseNX(Ǝ_ONX)						*/
/*                                                                              */
/********************************************************************************/

class CCentigrade : public CObject
{
public:
	CCentigrade()  : zoom(0) {};
	~CCentigrade() {};
	DECLARE_SERIAL(CCentigrade)

private:
	HWND  hWnd;
	HGLRC hRC;
	HDC   hDC;

	// fz
	std::vector < CModel > models;
	// }eAz
	std::vector < CMaterial > materials;
	// JW
	CAnimation camera;
	// fԍ
	int   model_number;
	// X[WO
	BOOL  bSmooth;
	float angleView;
	// ʃTCY
	float width,height;
	// }eAԍ
	int	  material_number;
	// wiF
	long  bgColor;
	// Y[
	float zoom;
	// GfBbg[h
	EDIT_MODE edit_mode;
	// ݑI𒆂̃f
	int current_model;
	// ݑI𒆂̃}eA
	int current_material;
	// ʍ쐬̍ۂ̍W
	CPoint3 coord;

public:
	HGLRC GethRC() { return hRC; }
	void Init();
	void SetMaterials();
	void Rendering();
	void OnSize(int cx, int cy);
	void LoadTextures();
	void ReleaseAll();
	void SetLight();
	void SetBkColor();
	void SmoothShading(BOOL bSmooth);
	int OnCreate(HWND hWnd);
	void OnDestroy();
	void ResizeModels(int i) { models.resize(i); }
	CModel* GetModelsBack() { return &models.back(); }
	CModel GetModel(int i) { return models[i]; }
	int GetModelsSize() { return (int)models.size(); }
	void PopBackModel() { models.pop_back(); }
	int GetModelNumber() { return model_number; }
	UINT AddModelState(int i) { return models[i].AddState(1); }
	UINT GetModelState(int i) { return models[i].GetState(); }
	void PushBackMaterial(const CMaterial& mat) { materials.push_back(mat); }
	CMaterial GetMaterial(int i) { return materials[i]; }
	int GetMaterialsSize() { return (int)materials.size(); }
	int GetMaterialNumber() { return material_number; }
	void AddMaterialNumber(int a) { material_number += a; }
	float GetWidth() { return width; }
	float GetHeight() { return height; }
	void PushBackModels(CModel model) { models.push_back(model); }
	void PushBackMaterials(CMaterial mat) { materials.push_back(mat); }
	void SetZoom(float z) { zoom = z; }
	void AddZoom(float z) { zoom += z; if ( zoom < 1 ) zoom = 1; }
	bool LoadMQOFile(const char *file_name);
	bool SaveMQOFile(const char *file_name);
	void DrawWireFrame(CDC* pDC,ANGLE angle,CPoint center);
	void AddCameraMove(float x,float y,float z) { camera.AddMove(x,y,z); }
	void AddCameraRotate(float x,float y,float z) { camera.AddRotate(x,y,z); }
	void CalcNormals();
	void DrawVertices(CDC* pDC,ANGLE angle,CPoint center);
	void Rectangle(CDC* pDC,CPoint first,CPoint current);
	void SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center);
	void SetEditMode(EDIT_MODE mode) { edit_mode = mode; }
	EDIT_MODE GetEditMode() { return edit_mode; }
	void AddVerticesMove(float x,float y, float z);
	void AddVerticesRotate(ANGLE angle,float rotate,CPoint center);
	void AddVerticesRotate(ANGLE angle,float rotate,CVector center);
	void AddVerticesSize(ANGLE angle,float size,CPoint center);
	void AddVerticesSize(CVector v,CVector center);
	void AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center);
	void AddVerticesStretch(CVector v,CVector center);
	void SetCurrentModel(int m) { current_model = m; }
	int GetCurrentModel() { return current_model; }
	int GetCurrentMaterial() { return current_material; }
	void SetCurrentMaterial(int m) { current_material = m; }
	void DeleteModel();
	void DeleteMaterial();
	void SetMaterial();
	void SetMaterial(CMaterial mat);
	CMaterial* GetMaterial() { return &materials[current_material]; }
	// Obh̕`
	void Grid(CDC* pDC,CRect rect,CPoint center);
	void SelectModelVertices(bool b);
	void SetCurrentModelName(CString name);
	void SetCurrentMaterialName(CString name);
	void MoveUp();
	void MoveDown();
	void SynthesisUp();
	void SynthesisDown();
	void ChangeSmooth() { bSmooth = !bSmooth; }
	BOOL GetSmooth() { return bSmooth; }
	void DeleteVertices();
	void SelectAllVertices(bool b);
	void DrawMakePolygon(CDC* pDC,ANGLE angle,CPoint center,CRect rect);
	void MakePolygon(ANGLE angle,CPoint point,CPoint center);
	void SetPolygon();
	void SetCoordX(int x) { coord.x = x; }
	void SetCoordY(int y) { coord.y = y; }
	void SetCoordZ(int z) { coord.z = z; }
	void CCentigrade::SetUV(int material_number);
	UINT GetImageColor(int material);

	// Implementation
public:
	virtual void Serialize(CArchive& ar);
};
