//---------------------------------------------------------------------------
//   DIB Library
//         Copyright(c)1998-2000, O.Mizno     All rights reserved.
//
//     DibLib.h
//          import,export,effect
//---------------------------------------------------------------------------

#ifndef DibLibH
#define DibLibH

#include "Dib.h"

//---------------------------------------------------------------------------
//  load from a file
//---------------------------------------------------------------------------
bool LoadPPM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadPGM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadTGA(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadPNG(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadJPEG(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadIFF(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool LoadTIM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);

//---------------------------------------------------------------------------
//  save to a file
//---------------------------------------------------------------------------
bool SavePPM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SavePGM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SaveTGA(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SavePNG(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SaveJPEG(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SaveIFF(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);
bool SaveTIM(LPCSTR FileName, DibStream *Dib, bool callback(float,void*)=NULL, void *data=NULL);

//---------------------------------------------------------------------------
//  pixel color
//---------------------------------------------------------------------------
WORD DibGetColor16(DibStream *Dib, float x, float y);
DWORD DibGetColor24(DibStream *Dib, float x, float y);
DWORD DibGetColor32(DibStream *Dib, float x, float y);


//---------------------------------------------------------------------------
//  effect
//---------------------------------------------------------------------------

#define DIB_EFFECT_LOOP_X 1
#define DIB_EFFECT_LOOP_Y 2


// DibEffectReverse
typedef struct {
	DWORD dwSize;
} DEReverseInfo, *lpDEReverseInfo;

bool DibEffectReverse(bool callback(float,void*), void *data, DibStream *Dib);
bool DibEffectReverse(bool callback(float,void*), void *data, DibStream *Dib,
	DEReverseInfo *info);

// DibEffectRipple
typedef struct {
	DWORD dwSize;
	float center_x;
	float center_y;
	float wave_length;
	float amplitude;
	float phase;
	DWORD loop;
} DERippleInfo, *lpDERippleInfo;

bool DibEffectRipple(bool callback(float,void*), void *data, DibStream *Dib,
	DERippleInfo *info);
bool DibEffectRipple(bool callback(float,void*), void *data, DibStream *Dib,
	float cx, float cy, float wavelen, float amp, float phase, DWORD loop);

// DibEffectRotate
typedef struct {
	DWORD dwSize;
	float angle;
	DWORD loop;
} DERotateInfo, *lpDERotateInfo;

bool DibEffectRotate(bool callback(float,void*), void *data, DibStream *Dib,
	DERotateInfo *info);
bool DibEffectRotate(bool callback(float,void*), void *data, DibStream *Dib,
	float angle, DWORD loop);


// DibEffectWave
typedef struct {
	DWORD dwSize;
	float wave_length;
	float amplitude;
	float phase;
	float angle;
	DWORD loop;
} DEWaveInfo, *lpDEWaveInfo;

bool DibEffectWave(bool callback(float,void*), void *data, DibStream *Dib,
	DEWaveInfo *info);
bool DibEffectWave(bool callback(float,void*), void *data, DibStream *Dib,
	float wavelen, float amp, float phase, float angle, DWORD loop);


// DibEffectWhirl
typedef struct {
	DWORD dwSize;
	float center_x;
	float center_y;
	float angle;
	DWORD loop;
} DEWhirlInfo, *lpDEWhirlInfo;

bool DibEffectWhirl(bool callback(float,void*), void *data, DibStream *Dib,
	DEWhirlInfo *info);
bool DibEffectWhirl(bool callback(float,void*), void *data, DibStream *Dib,
	float cx, float cy, float angle, DWORD loop);

// DibEffectMozaic
typedef struct {
	DWORD dwSize;
	int pixel;
} DEMozaicInfo, *lpDEMozaicInfo;

bool DibEffectMozaic(bool callback(float,void*), void *data, DibStream *Dib,
	DEMozaicInfo *info);
bool DibEffectMozaic(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel);

// DibEffectDiffuse
typedef struct {
	DWORD dwSize;
	int pixel;
	DWORD loop;
} DEDiffuseInfo, *lpDEDiffuseInfo;

bool DibEffectDiffuse(bool callback(float,void*), void *data, DibStream *Dib,
	DEDiffuseInfo *info);
bool DibEffectDiffuse(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel, DWORD loop);

// DibEffectCompose
typedef struct {
	DWORD dwSize;
	const char *filename;
	DibStream *source;
	float value;
	DWORD type;
} DEComposeInfo, *lpDEComposeInfo;

// for type
#define DIB_COMPOSE_RESIZE 0
#define DIB_COMPOSE_TILE   1

bool DibEffectCompose(bool callback(float,void*), void *data, DibStream *Dib,
	DEComposeInfo *info);
bool DibEffectCompose(bool callback(float,void*), void *data, DibStream *DestDib,
	DibStream *SourceDib, float value, DWORD type);
bool DibEffectCompose(bool callback(float,void*), void *data, DibStream *DestDib,
	const char *filename, float value, DWORD type);

// DibEffectMotionBlur
typedef struct {
	DWORD dwSize;
	int speed;
	float angle;
	DWORD loop;
} DEMotionBlurInfo, *lpDEMotionBlurInfo;

bool DibEffectMotionBlur(bool callback(float,void*), void *data, DibStream *Dib,
	DEMotionBlurInfo *info);
bool DibEffectMotionBlur(bool callback(float,void*), void *data, DibStream *Dib,
	int speed, float angle, DWORD loop);

// DibEffectBlur
typedef struct {
	DWORD dwSize;
	int pixel;
	DWORD loop;
} DEBlurInfo, *lpDEBlurInfo;

bool DibEffectBlur(bool callback(float,void*), void *data, DibStream *Dib,
	DEBlurInfo *info);
bool DibEffectBlur(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel, DWORD loop);

// DibEffectBlurLittle
typedef struct {
	DWORD dwSize;
	DWORD loop;
} DEBlurLittleInfo, *lpDEBlurLittleInfo;

bool DibEffectBlurLittle(bool callback(float,void*), void *data, DibStream *Dib,
	DEBlurLittleInfo *info);
bool DibEffectBlurLittle(bool callback(float,void*), void *data, DibStream *Dib,
	DWORD loop);

// DibEffectSharpLittle
typedef struct {
	DWORD dwSize;
	DWORD loop;
} DESharpLittleInfo, *lpDESharpLittleInfo;

bool DibEffectSharpLittle(bool callback(float,void*), void *data, DibStream *Dib,
	DESharpLittleInfo *info);
bool DibEffectSharpLittle(bool callback(float,void*), void *data, DibStream *Dib,
	DWORD loop);

// DibEffectBright
typedef struct {
	DWORD dwSize;
	int pixel;
	DWORD loop;
} DEBrightInfo, *lpDEBrightInfo;

// DibEffectBrightMax
typedef DEBrightInfo DEBrightMaxInfo;
typedef lpDEBrightInfo lpDEBrightMaxInfo;
bool DibEffectBrightMax(bool callback(float,void*), void *data, DibStream *Dib,
	DEBrightMaxInfo *info);
bool DibEffectBrightMax(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel, DWORD loop);

// DibEffectBrightMin
typedef DEBrightInfo DEBrightMinInfo;
typedef lpDEBrightInfo lpDEBrightMinInfo;
bool DibEffectBrightMin(bool callback(float,void*), void *data, DibStream *Dib,
	DEBrightMinInfo *info);
bool DibEffectBrightMin(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel, DWORD loop);

// DibEffectBrightMiddle
typedef DEBrightInfo DEBrightMiddleInfo;
typedef lpDEBrightInfo lpDEBrightMiddleInfo;
bool DibEffectBrightMiddle(bool callback(float,void*), void *data, DibStream *Dib,
	DEBrightMiddleInfo *info);
bool DibEffectBrightMiddle(bool callback(float,void*), void *data, DibStream *Dib,
	int pixel, DWORD loop);

// DibEffectEmboss
typedef struct {
	DWORD dwSize;
	float power;
	int pixel;
	float angle;
	DWORD loop;
} DEEmbossInfo, *lpDEEmbossInfo;

bool DibEffectEmboss(bool callback(float,void*), void *data, DibStream *Dib,
	DEEmbossInfo *info);
bool DibEffectEmboss(bool callback(float,void*), void *data, DibStream *Dib,
	float power, int pixel, float angle, DWORD loop);

// DibEffectNoise
typedef struct {
	DWORD dwSize;
	int power;
} DENoiseInfo, *lpDENoiseInfo;

bool DibEffectNoise(bool callback(float,void*), void *data, DibStream *Dib,
	DENoiseInfo *info);
bool DibEffectNoise(bool callback(float,void*), void *data, DibStream *Dib,
	int power);

// DibEffectColorNoise
typedef struct {
	DWORD dwSize;
	DWORD color;
	float power;
} DEColorNoiseInfo, *lpDEColorNoiseInfo;

bool DibEffectColorNoise(bool callback(float,void*), void *data, DibStream *Dib,
	DEColorNoiseInfo *info);
bool DibEffectColorNoise(bool callback(float,void*), void *data, DibStream *Dib,
	DibBGRA color, float power);
bool DibEffectColorNoise(bool callback(float,void*), void *data, DibStream *Dib,
	DWORD color, float power);

// DibEffectPickEdge
typedef struct {
	DWORD dwSize;
	DWORD loop;
} DEPickEdgeInfo, *lpDEPickEdgeInfo;

bool DibEffectPickEdge(bool callback(float,void*), void *data, DibStream *Dib,
	DEPickEdgeInfo *info);
bool DibEffectPickEdge(bool callback(float,void*), void *data, DibStream *Dib,
	DWORD loop);

#endif
