/********************************************************************************/
/*                                                                              */
/*		Model.cpp																*/
/*                                                                              */
/********************************************************************************/

#include "stdafx.h"
#include "Centigrade.h"


/********************************************************************************/
/*                                                                              */
/*		CMaterialNX															*/
/*                                                                              */
/********************************************************************************/

CMaterial::CMaterial()
{
	name = "NoMaterial";
	r = 0.8f;
	g = 0.8f;
	b = 0.8f;
	a = 1.0f;
	diffuse = 1.0f;
	ambient = 0.25f;
	emissive = 0.0f;
	specular = 0.0f;
	power = 5.0f;
	texture_name.Empty();
	alpha_name.Empty();
	bump_name.Empty();
	textureGL = NULL;
	planes = 3;
	format = GL_BGR_EXT;
	SetMaterialGL();
}

CMaterial::CMaterial(int material_number)
{
	number = material_number;
	name = "NoMaterial";
	r = 0.8f;
	g = 0.8f;
	b = 0.8f;
	a = 1.0f;
	diffuse = 1.0f;
	ambient = 0.25f;
	emissive = 0.0f;
	specular = 0.0f;
	power = 5.0f;
	texture_name.Empty();
	alpha_name.Empty();
	bump_name.Empty();
	textureGL = NULL;
	planes = 3;
	format = GL_BGR_EXT;
	SetMaterialGL();
}

CMaterial::CMaterial(int material_number,CString name,float r,float g,float b,float a,float diffuse,
					 float ambient,float emissive,float specular,float power,CString texture_name)
{
	this->name = name;
	this->r = r;
	this->g = g;
	this->b = b;
	this->a = a;
	this->diffuse = diffuse;
	this->ambient = ambient;
	this->emissive = emissive;
	this->specular = specular;
	this->power = power;
	this->texture_name = texture_name;
}

CMaterial& CMaterial::operator=(const CMaterial& pt)
{
	number = pt.number;
	name = pt.name;
	r = pt.r;
	g = pt.g;
	b = pt.b;
	a = pt.a;
	diffuse = pt.diffuse;
	ambient = pt.ambient;
	emissive = pt.emissive;
	specular = pt.specular;
	power = pt.power;
	for ( int i = 0; i < 4; ++i )
	{
		dif[i] = pt.dif[i];
		amb[i] = pt.amb[i];
		emi[i] = pt.emi[i];
		spc[i] = pt.spc[i];
	}
	texture_name = pt.texture_name;
	alpha_name = pt.alpha_name;
	bump_name = pt.bump_name;
	texName = pt.texName;
	planes = pt.planes;
	format = pt.format;
	textureGL = pt.textureGL;

	return *this;
}

/********************************************************************************/
/*                                                                              */
/*		}eA̐ݒ														*/
/*                                                                              */
/********************************************************************************/

void CMaterial::SetMaterialGL()
{
	this->dif[0] = r * diffuse;
	this->dif[1] = g * diffuse;
	this->dif[2] = b * diffuse;
	this->dif[3] = a;
	this->amb[0] = r * ambient;
	this->amb[1] = g * ambient;
	this->amb[2] = b * ambient;
	this->amb[3] = a;
	this->spc[0] = specular;
	this->spc[1] = specular;
	this->spc[2] = specular;
	this->spc[3] = a;
	this->emi[0] = r * emissive;
	this->emi[1] = g * emissive;
	this->emi[2] = b * emissive;
	this->emi[3] = a;
}

/********************************************************************************/
/*                                                                              */
/*		eNX`ǂݍ													*/
/*                                                                              */
/********************************************************************************/

void CMaterial::LoadTextureGL()
{
	if ( !texture_name.IsEmpty() )
	{
		bool result = false;
		char filename[BUFFER_SIZE],ext[BUFFER_SIZE];
		textureGL = new DibStream;

		// gqƂɕăeNX`ǂݍ
		sprintf(filename,"%sTEXTURE\\%s",Directory(),texture_name);
		GetFileExtension(ext, filename);
		#define CHK_EXT(e) (_stricmp(ext, e)==0)
			if(CHK_EXT("bmp"))
			{
				result = textureGL->LoadFromFile(filename, DIB_LOAD_ALL);
			}
			else if(CHK_EXT("ppm"))
			{
				result = LoadPPM(filename, textureGL);
			}
			else if(CHK_EXT("pgm"))
			{
				result = LoadPGM(filename, textureGL);
			}
			else if(CHK_EXT("tga"))
			{
				result = LoadTGA(filename, textureGL);
			}
			else if(CHK_EXT("png"))
			{
				result = LoadPNG(filename, textureGL);
			}
			else if(CHK_EXT("jpg"))
			{
				result = LoadJPEG(filename, textureGL);
			}
			else if(CHK_EXT("iff"))
			{
				result = LoadIFF(filename, textureGL);
			}
		#undef CHK_EXT
		if ( result )
		{
//			textureGL->Resize(TEXTURE_SIZE,TEXTURE_SIZE);
			if( textureGL->GetBpp() == 32 )
			{
				planes = 4;
				format = GL_BGRA_EXT;
			}
			else
			{
				textureGL->ChangeBpp(24);
				planes = 3;
				format = GL_BGR_EXT;
			}
			//eNX`IuWFNg̍쐬
			glPixelStorei(GL_UNPACK_ALIGNMENT,1);
			glGenTextures(1,&texName);
			glBindTexture(GL_TEXTURE_2D,texName);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
			glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE );
			glTexImage2D(
				GL_TEXTURE_2D,
				0,
				planes,
				textureGL->GetWidth(),
				textureGL->GetHeight(),
				0,
				format,
				GL_UNSIGNED_BYTE,
				textureGL->GetBuffer());
			glEnable(GL_TEXTURE_2D);
		}
		else
		{
			AfxMessageBox("eNX`̓ǂݍ݂Ɏs܂");
			texture_name.Empty();
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		}eÃZbg														*/
/*                                                                              */
/********************************************************************************/

void CMaterial::SetMaterial()
{
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,   dif);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,   amb);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  spc);
	glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION,  emi);
	glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, power);

	// eNX`̐ݒ
	if ( texture_name.IsEmpty() )
	{
		glDisable(GL_TEXTURE_2D);
	}
	else
	{
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,texName);
	}
}

static UINT color[3][3][3] =
{
	{   // R=0
		{1,5,12},{3,7,12},{10,7,14},
	},{ // R=1
		{2,6,12},{4,8,12},{10,10,14},
	},{ // R=2
		{9,9,13},{11,9,13},{11,11,15}
	}
};

UINT CMaterial::GetImageColor()
{
	int r2,g2,b2;

	if ( r < 0.5f ) r2 = 0;
	else if ( r < 0.75f ) r2 = 1;
	else r2 = 2;

	if ( g < 0.5f ) g2 = 0;
	else if ( g < 0.75f ) g2 = 1;
	else g2 = 2;

	if ( b <0.5f ) b2 = 0;
	else if ( b < 0.75f ) b2 = 1;
	else b2 = 2;

	return color[r2][g2][b2];
}

/********************************************************************************/
/*                                                                              */
/*		CVectorNX															*/
/*                                                                              */
/********************************************************************************/

void  CVector::normalize()
{
	float length = this->abs();
	if ( length == 0 )
	{
		x = 0; y = 0; z = 1.0f;
	}
	else
	{
		this->multiply( 1.0f / length );
	}
}

CVector CVector::operator-(const CVector& pt)
{
	CVector v;
	v.x = x - pt.x;	v.y = y - pt.y;	v.z = z - pt.z;
	return v;
}

CVector& CVector::operator=(const CVector& pt)
{
	x = pt.x;	y = pt.y;	z = pt.z;
	return *this;
}

CVector& CVector::operator+=(const CVector& pt)
{
	x += pt.x;	y += pt.y;	z += pt.z;
	return *this;
}

CVector& CVector::operator-=(const CVector& pt)
{
	x -= pt.x;	y -= pt.y;	z -= pt.z;
	return *this;
}

CVector& CVector::operator*=(const CVector& pt)
{
	x *= pt.x;	y *= pt.y;	z *= pt.z;
	return *this;
}

CVector CVector::operator/=( float a )
{
	x /= a;	y /= a;	z /= a;
	return *this;
}

bool CVector::operator==(const CVector& pt)
{
	if ( x == pt.x && y == pt.y && z == pt.z ) return true;
	return false;
}

bool CVector::operator!=(const CVector& pt)
{
	if ( x != pt.x || y != pt.y || z != pt.z ) return true;
	return false;
}

/********************************************************************************/
/*                                                                              */
/*		Oς̌vZ																*/
/*                                                                              */
/********************************************************************************/

void CVector::CrossProduct(const CVector& a,const CVector& b)
{
	x = a.y*b.z - a.z*b.y;
	y = a.z*b.x - a.x*b.z;
	z = a.x*b.y - a.y*b.x;
}

/********************************************************************************/
/*                                                                              */
/*		CVertexNX															*/
/*                                                                              */
/********************************************************************************/

CVertex& CVertex::operator=(const CVertex& pt)
{
	pos = pt.pos;
	normal = pt.normal;
	have_faces = pt.have_faces;
	selected = pt.selected;

	return *this;
}

/********************************************************************************/
/*                                                                              */
/*		_̓_̕`															*/
/*                                                                              */
/********************************************************************************/

void CVertex::DrawVertices(CDC* pDC,ANGLE angle,CPoint center,float zoom,CBrush color)
{
	int x,y;

	switch ( angle )
	{
	case ANGLE_TOP:
		x = (int)(GetPosX()*zoom/100) + center.x;
		y = (int)(GetPosZ()*zoom/100) + center.y;
		break;
	case ANGLE_FACE:
		x = (int)(GetPosX()*zoom/100) + center.x;
		y =-(int)(GetPosY()*zoom/100) + center.y;
		break;
	case ANGLE_LEFT:
		x =-(int)(GetPosZ()*zoom/100) + center.x;
		y =-(int)(GetPosY()*zoom/100) + center.y;
		break;
	}

	pDC->FillRect(CRect(x-1,y-1,x+2,y+2),&color);
}

/********************************************************************************/
/*                                                                              */
/*		_̑IE														*/
/*                                                                              */
/********************************************************************************/

void CVertex::SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center,float zoom)
{
	int x,y,z;

	switch ( angle )
	{
	case ANGLE_TOP:
		x = (int)(GetPosX()*zoom/100) + center.x;
		z = (int)(GetPosZ()*zoom/100) + center.y;
		if ( rect.left < x && rect.right > x && rect.top < z && rect.bottom > z ) selected = select;
		break;
	case ANGLE_FACE:
		x = (int)(GetPosX()*zoom/100) + center.x;
		y =-(int)(GetPosY()*zoom/100) + center.y;
		if ( rect.left < x && rect.right > x && rect.top < y && rect.bottom > y ) selected = select;
		break;
	case ANGLE_LEFT:
		z =-(int)(GetPosZ()*zoom/100) + center.x;
		y =-(int)(GetPosY()*zoom/100) + center.y;
		if ( rect.left < z && rect.right > z && rect.top < y && rect.bottom > y ) selected = select;
		break;
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CVertex::AddVerticesRotate(ANGLE angle,float rotate,CPoint center)
{
	if ( selected )
	{
		float radian = DEGREE(rotate);
		float cos2 = cos( radian );
		float sin2 = sin( radian );
		float x,y,z;

		switch ( angle )
		{
		case ANGLE_TOP:
			x = GetPosX()-center.x;
			z = GetPosZ()-center.y;
			SetPosX(x*cos2+z*sin2+center.x);
			SetPosZ(z*cos2-x*sin2+center.y);
			break;
		case ANGLE_FACE:
			x = GetPosX()-center.x;
			y = GetPosY()+center.y;
			SetPosX(x*cos2+y*sin2+center.x);
			SetPosY(y*cos2-x*sin2-center.y);
			break;
		case ANGLE_LEFT:
			y = GetPosY()+center.y;
			z = GetPosZ()+center.x;
			SetPosY(y*cos2+z*sin2-center.y);
			SetPosZ(z*cos2-y*sin2-center.x);
			break;
		}
	}
}


/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CVertex::AddVerticesRotate(ANGLE angle,float rotate,CVector center)
{
	if ( selected )
	{
		float radian = DEGREE(rotate);
		float cos2 = cos( radian );
		float sin2 = sin( radian );
		float x,y,z;

		switch ( angle )
		{
		case ANGLE_TOP:
			x = GetPosX()-center.GetX();
			z = GetPosZ()-center.GetZ();
			SetPosX(x*cos2+z*sin2+center.GetX());
			SetPosZ(z*cos2-x*sin2+center.GetZ());
			break;
		case ANGLE_FACE:
			x = GetPosX()-center.GetX();
			y = GetPosY()+center.GetY();
			SetPosX(x*cos2+y*sin2+center.GetX());
			SetPosY(y*cos2-x*sin2-center.GetY());
			break;
		case ANGLE_LEFT:
			y = GetPosY()+center.GetY();
			z = GetPosZ()+center.GetZ();
			SetPosY(y*cos2+z*sin2-center.GetY());
			SetPosZ(z*cos2-y*sin2-center.GetZ());
			break;
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̊gEk														*/
/*                                                                              */
/********************************************************************************/

void CVertex::AddVerticesSize(ANGLE angle,float size,CPoint center)
{
	if ( selected )
	{
		switch ( angle )
		{
		case ANGLE_TOP:
			AddPos((GetPosX()-center.x)*size,GetPosY()*size,(GetPosZ()-center.y)*size);
			break;
		case ANGLE_FACE:
			AddPos((GetPosX()-center.x)*size,(GetPosY()+center.y)*size,GetPosZ()*size);
			break;
		case ANGLE_LEFT:
			AddPos(GetPosX()*size,(GetPosY()+center.y)*size,(GetPosZ()+center.x)*size);
			break;
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̃Xgb`														*/
/*                                                                              */
/********************************************************************************/

void CVertex::AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center)
{
	if ( selected )
	{
		switch ( angle )
		{
		case ANGLE_TOP:
			AddPos((GetPosX()-center.x)*sizeX,0,(GetPosZ()-center.y)*sizeY);
			break;
		case ANGLE_FACE:
			AddPos((GetPosX()-center.x)*sizeX,(GetPosY()+center.y)*sizeY,0);
			break;
		case ANGLE_LEFT:
			AddPos(0,(GetPosY()+center.y)*sizeY,(GetPosZ()+center.x)*sizeX);
			break;
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̃Xgb`														*/
/*                                                                              */
/********************************************************************************/

void CVertex::AddVerticesStretch(CVector v,CVector center)
{
	if ( selected )
	{
		SetPos((GetPosX()-center.GetX())*v.GetX()+center.GetX(),
			   (GetPosY()-center.GetY())*v.GetY()+center.GetY(),
			   (GetPosZ()-center.GetZ())*v.GetZ()+center.GetZ());
	}
}

/********************************************************************************/
/*                                                                              */
/*		CFaceNX																*/
/*                                                                              */
/********************************************************************************/

CFace& CFace::operator=(const CFace& pt)
{
	material = pt.material;
	index = pt.index;
	uv = pt.uv;
	normal = pt.normal;
	selected = pt.selected;

	return *this;
}

/********************************************************************************/
/*                                                                              */
/*		CAnimationNX														*/
/*                                                                              */
/********************************************************************************/

CAnimation& CAnimation::operator=(const CAnimation& pt)
{
	move = pt.move;
	rotate = pt.rotate;
	scale = pt.scale;
	key = pt.key;

	return *this;
}

void CAnimation::Init()
{
	scale = CVector(1.0f,1.0f,1.0f);
	rotate = CVector();
	move = CVector();
	key = false;
}

void CAnimation::SetTransform(const CAnimation& pt)
{
	move = pt.move;
	rotate = pt.rotate;
	scale = pt.scale;
}

/********************************************************************************/
/*                                                                              */
/*		GLXg̃gXtH[												*/
/*                                                                              */
/********************************************************************************/

void CAnimation::AddTransform()
{
	move.Translate();
	rotate.Rotate();
	scale.Scale();
}

/********************************************************************************/
/*                                                                              */
/*		CModelNX															*/
/*                                                                              */
/********************************************************************************/

CModel::CModel()
{
	name = "Model";
	vertices.clear();
	faces.clear();
	parent_name = ROOT_NAME;
	mirror_axis = 0;
	facet = 0;
	state = 1;
	polygon_vertices.clear();
}

/********************************************************************************/
/*                                                                              */
/*		Zq=̃I[o[[h													*/
/*                                                                              */
/********************************************************************************/

CModel& CModel::operator=(const CModel& pt)
{
	name = pt.name;
	parent = pt.parent;
	parent_name = pt.parent_name;
	vertices = pt.vertices;
	faces = pt.faces;
	mirror_axis = pt.mirror_axis;
	state = pt.state;
	polygon_vertices = pt.polygon_vertices;

	return *this;
}

/********************************************************************************/
/*                                                                              */
/*		Zq+=̃I[o[[h												*/
/*                                                                              */
/********************************************************************************/

CModel& CModel::operator+=(CModel& pt)
{
	int i;
	int size = (int)vertices.size();

	for( i = 0; i < (int)pt.faces.size(); ++i )
	{
		faces.push_back(pt.faces[i]);
		faces.back().AddIndex(size);
	}
	for( i = 0; i < (int)pt.vertices.size(); ++i )
	{
		vertices.push_back(pt.vertices[i]);
	}

	return *this;
}

/********************************************************************************/
/*                                                                              */
/*		v~eBu̕`														*/
/*                                                                              */
/********************************************************************************/

void CModel::DrawPrimitive(BOOL bSmooth,std::vector<CMaterial> &materials)
{
	int i;
	CVertex *vertex;
	vector<CFace>::iterator face;

	if ( state == 3 ) return;

	if ( bSmooth )	// X[YEVF[fBO
	{
		glShadeModel(GL_SMOOTH);
	}
	else	// tbgEVF[fBO
	{
		glShadeModel(GL_FLAT);
	}

	// CeBO̗L
	glEnable(GL_LIGHTING);
	// |S[h
	glPolygonMode(GL_FRONT, GL_FILL);

	// }eAPʂŃ_O
	for( vector<CMaterial>::iterator mat = materials.begin(); mat != materials.end(); ++mat )
	{
		for( face = faces.begin(); face != faces.end(); ++face )
		{
			if ( face->GetMaterialNumber() == mat->GetNumber() )
			{
				break;
			}
		}
		if ( face == faces.end() ) continue;

		mat->SetMaterial();

		for( face = faces.begin(); face != faces.end(); ++face )
		{
			if ( face->GetMaterialNumber() == mat->GetNumber() )
			{
				// v~eBu̕`
				switch ( face->GetIndexSize() )
				{
				case 2:
					glBegin(GL_LINES);
					for ( i = 0; i < 2; ++i )
					{
						vertex = &vertices[face->GetIndex(i)];
						vertex->Vertex();
					}
					glEnd();
					break;
				case 3:
					glBegin(GL_TRIANGLES);
					for ( i = 0; i < 3; ++i )
					{
						if ( face->GetUVSize() > i ) face->SetTexCood(i);
						vertex = &vertices[face->GetIndex(i)];
						vertex->Normal();
						vertex->Vertex();
					}
					glEnd();	
					break;
				case 4:
					glBegin(GL_QUADS);
					for ( i = 0; i < 4; ++i )
					{
						if ( face->GetUVSize() > i ) face->SetTexCood(i);
						vertex = &vertices[face->GetIndex(i)];
						vertex->Normal();
						vertex->Vertex();
					}
					glEnd();
					break;
				}
			}
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		@OςvZ														*/
/*                                                                              */
/********************************************************************************/

void CModel::CalcNormals(BOOL bSmooth)
{
	int i;
	CVector a,b;

	if ( bSmooth )	// X[YEVF[fBO
	{
		// ʂƂ̖@
		for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
		{
			if ( face->GetIndexSize() <= 2 ) continue;
			a = vertices[face->GetIndex(0)].GetPos() - vertices[face->GetIndex(1)].GetPos();
			b = vertices[face->GetIndex(0)].GetPos() - vertices[face->GetIndex(2)].GetPos();

			face->CrossProduct(a,b);
		}

		// _Ƃ̖@
		for( vector<CVertex>::iterator vertex=vertices.begin(); vertex!=vertices.end(); ++vertex )
		{
			vertex->SetNormal(CVector());

			for ( i = 0; i < vertex->GetHaveFacesSize(); ++i )
			{
				vertex->AddNormal(faces[vertex->GetHaveFaces(i)].GetNormal());
			}

//			vertex->Normalize();
		}
	}
	else // tbgVF[fBO
	{
		for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
		{
			if ( face->GetIndexSize() <= 2 ) continue;
			a = vertices[face->GetIndex(0)].GetPos() - vertices[face->GetIndex(1)].GetPos();
			b = vertices[face->GetIndex(0)].GetPos() - vertices[face->GetIndex(2)].GetPos();

			face->CrossProduct(a,b);

//			face->Normalize();
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		CA[t[̕`												*/
/*                                                                              */
/********************************************************************************/

void CModel::DrawWireFrame(CDC* pDC,ANGLE angle,CPoint center,const float zoom,bool select)
{
	if ( state == 3 ) return;

	CPen pen;  // Construct it, then initialize
	COLORREF color;

	if ( select ) color = RGB(255,0,0);
	else color = RGB(0,0,0);

	if( !pen.CreatePen( PS_SOLID, 1, color ) ) return;

	// Select it into the device context
	// Save the old pen at the same time
	CPen* pOldPen = pDC->SelectObject( &pen );

	for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
	{
		if ( face->GetSelect() != select ) continue;

		switch ( face->GetIndexSize() )
		{
		case 2:
			Line(pDC,angle,vertices[face->GetIndex(0)].GetPos(),vertices[face->GetIndex(1)].GetPos(),center,zoom);
			break;
		case 3:
			Line(pDC,angle,vertices[face->GetIndex(0)].GetPos(),vertices[face->GetIndex(1)].GetPos(),center,zoom);
			Line(pDC,angle,vertices[face->GetIndex(1)].GetPos(),vertices[face->GetIndex(2)].GetPos(),center,zoom);
			Line(pDC,angle,vertices[face->GetIndex(2)].GetPos(),vertices[face->GetIndex(0)].GetPos(),center,zoom);
			break;
		case 4:
			Line(pDC,angle,vertices[face->GetIndex(0)].GetPos(),vertices[face->GetIndex(1)].GetPos(),center,zoom);
			Line(pDC,angle,vertices[face->GetIndex(1)].GetPos(),vertices[face->GetIndex(2)].GetPos(),center,zoom);
			Line(pDC,angle,vertices[face->GetIndex(2)].GetPos(),vertices[face->GetIndex(3)].GetPos(),center,zoom);
			Line(pDC,angle,vertices[face->GetIndex(3)].GetPos(),vertices[face->GetIndex(0)].GetPos(),center,zoom);
			break;
		}
	}

	// Restore the old pen to the device context
	pDC->SelectObject( pOldPen );

	pen.DeleteObject();
}

/********************************************************************************/
/*                                                                              */
/*		CA[t[̐̕`												*/
/*                                                                              */
/********************************************************************************/

void CModel::Line(CDC* pDC,ANGLE angle,const CVertex& v1,const CVertex& v2,CPoint center,float zoom)
{
	int sx,sy,ex,ey;

	switch ( angle )
	{
	case ANGLE_TOP:
		sx = int(v1.GetPosX()*zoom/100) + center.x;
		sy = int(v1.GetPosZ()*zoom/100) + center.y;
		ex = int(v2.GetPosX()*zoom/100) + center.x;
		ey = int(v2.GetPosZ()*zoom/100) + center.y;
		break;
	case ANGLE_FACE:
		sx = int(v1.GetPosX()*zoom/100) + center.x;
		sy =-int(v1.GetPosY()*zoom/100) + center.y;
		ex = int(v2.GetPosX()*zoom/100) + center.x;
		ey =-int(v2.GetPosY()*zoom/100) + center.y;
		break;
	case ANGLE_LEFT:
		sx =-int(v1.GetPosZ()*zoom/100) + center.x;
		sy =-int(v1.GetPosY()*zoom/100) + center.y;
		ex =-int(v2.GetPosZ()*zoom/100) + center.x;
		ey =-int(v2.GetPosY()*zoom/100) + center.y;
		break;
	}

	pDC->MoveTo( sx, sy );
	pDC->LineTo( ex, ey );
}

/********************************************************************************/
/*                                                                              */
/*		_̓_̕`															*/
/*                                                                              */
/********************************************************************************/

void CModel::DrawVertices(CDC* pDC,ANGLE angle,CPoint center,float zoom,bool select)
{
	if ( state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		if ( vertex->GetSelect() == select )
		{
			vertex->DrawVertices(pDC,angle,center,zoom,(vertex->GetSelect())?RGB(255,0,0):RGB(0,0,0));
		}
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̑IE														*/
/*                                                                              */
/********************************************************************************/

void CModel::SelectVertices(CRect rect,ANGLE angle,bool select,CPoint center,float zoom)
{
	if ( select && ( state == 2 || state == 3 ) ) return;

	rect.NormalizeRect();

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->SelectVertices(rect,angle,select,center,zoom);
	}
	SetSelectFaces();
}

/********************************************************************************/
/*                                                                              */
/*		_̈ړ																*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesMove(float x,float y, float z)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesMove(x,y,z);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesRotate(ANGLE angle,float rotate,CPoint center)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesRotate(angle,rotate,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̉]																*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesRotate(ANGLE angle,float rotate,CVector center)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesRotate(angle,rotate,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̊gEk														*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesSize(ANGLE angle,float size,CPoint center)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesSize(angle,size,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̊gEk														*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesStretch(ANGLE angle,float sizeX,float sizeY,CPoint center)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesStretch(angle,sizeX,sizeY,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		_̊gEk														*/
/*                                                                              */
/********************************************************************************/

void CModel::AddVerticesStretch(CVector v,CVector center)
{
	if ( state == 2 || state == 3 ) return;

	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->AddVerticesStretch(v,center);
	}
}

/********************************************************************************/
/*                                                                              */
/*		f̑S_̑I													*/
/*                                                                              */
/********************************************************************************/

void CModel::SelectModelVertices(bool b)
{
	for( vector<CVertex>::iterator vertex = vertices.begin(); vertex != vertices.end(); ++vertex )
	{
		vertex->SetSelect(b);
	}
	SetSelectFaces();
}

void CModel::SetSelectFaces()
{
	int i;

	for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
	{
		for ( i = 0; i < face->GetIndexSize(); ++i )
		{
			if ( !vertices[face->GetIndex(i)].GetSelect() ) goto next;
		}
		face->SetSelect(true);
		continue;
next:	
		face->SetSelect(false);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʂɌ݂̍ގw													*/
/*                                                                              */
/********************************************************************************/

void CModel::SetMaterial(int material_number)
{
	int i;

	if ( state == 2 || state == 3 ) return;

	for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
	{
		for ( i = 0; i < face->GetIndexSize(); ++i )
		{
			if ( !vertices[face->GetIndex(i)].GetSelect() ) goto next;
		}
		face->SetMaterialNumber(material_number);
next:
		continue;
	}
}

/********************************************************************************/
/*                                                                              */
/*		Iʂ폜															*/
/*                                                                              */
/********************************************************************************/

void CModel::DeleteVertices()
{
	int f,i,v;
	vector<CFace>::iterator face;

	if ( state == 2 || state == 3 ) return;

	// ʂ̍폜
	for( f = (int)faces.size()-1; f >= 0; --f )
	{
		if ( faces[f].GetSelect() ) faces.erase(faces.begin()+f);
	}

	// ǂ̖ʂɂȂ_폜
	for( vector<CVertex>::iterator vert = vertices.begin(); vert != vertices.end(); ++vert )
	{
		vert->SetFlag(false);
	}
	for( face = faces.begin(); face != faces.end(); ++face )
	{
		for ( i = 0; i < face->GetIndexSize(); ++i )
		{
			vertices[face->GetIndex(i)].SetFlag(true);
		}
	}
	for ( v = (int)vertices.size()-1; v >= 0; )
	{
		if ( !vertices[v].GetFlag() )
		{
			vertices.erase(vertices.begin()+v);
			for( face = faces.begin(); face != faces.end(); ++face )
			{
				for ( i = 0; i < face->GetIndexSize(); ++i )
				{
					if ( face->GetIndex(i) > v ) face->AddIndex(i,-1);
				}
			}
		}
		v--;
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬̕`															*/
/*                                                                              */
/********************************************************************************/

void CModel::DrawMakePolygon(CDC* pDC,ANGLE angle,CPoint center,const float zoom)
{
	CPen pen;  // Construct it, then initialize

	if( !pen.CreatePen( PS_SOLID, 1, RGB(0,0,255) ) ) return;

	// Select it into the device context
	// Save the old pen at the same time
	CPen* pOldPen = pDC->SelectObject( &pen );

	int idx,idx2,idx3;

	switch ( polygon.GetIndexSize() )
	{
	case 1:
		idx = polygon.GetIndex(0) - (int)vertices.size();
		if ( idx >= 0 )
		{
			polygon_vertices[idx].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(0)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		break;
	case 2:
		idx = polygon.GetIndex(0) - (int)vertices.size();
		idx2 = polygon.GetIndex(1) - (int)vertices.size();
		Line(pDC,angle,(idx>=0)?polygon_vertices[idx].GetPos():
			vertices[polygon.GetIndex(0)].GetPos(),
			(idx2>=0)?polygon_vertices[idx2].GetPos():
			vertices[polygon.GetIndex(1)].GetPos(),center,zoom);
		if ( idx >= 0 )
		{
			polygon_vertices[idx].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(0)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		if ( idx2 >= 0 )
		{
			polygon_vertices[idx2].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(1)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		break;
	case 3:
		idx = polygon.GetIndex(0) - (int)vertices.size();
		idx2 = polygon.GetIndex(1) - (int)vertices.size();
		idx3 = polygon.GetIndex(2) - (int)vertices.size();
		Line(pDC,angle,(idx>=0)?polygon_vertices[idx].GetPos():
			vertices[polygon.GetIndex(0)].GetPos(),
			(idx2>=0)?polygon_vertices[idx2].GetPos():
			vertices[polygon.GetIndex(1)].GetPos(),center,zoom);
		Line(pDC,angle,(idx2>=0)?polygon_vertices[idx2].GetPos():
			vertices[polygon.GetIndex(1)].GetPos(),
			(idx3>=0)?polygon_vertices[idx3].GetPos():
			vertices[polygon.GetIndex(2)].GetPos(),center,zoom);
		Line(pDC,angle,(idx3>=0)?polygon_vertices[idx3].GetPos():
			vertices[polygon.GetIndex(2)].GetPos(),
			(idx>=0)?polygon_vertices[idx].GetPos():
			vertices[polygon.GetIndex(0)].GetPos(),center,zoom);
		if ( idx >= 0 )
		{
			polygon_vertices[idx].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(0)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		if ( idx2 >= 0 )
		{
			polygon_vertices[idx2].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(1)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		if ( idx3 >= 0 )
		{
			polygon_vertices[idx3].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		else
		{
			vertices[polygon.GetIndex(2)].DrawVertices(pDC,angle,center,zoom,RGB(0,0,255));
		}
		break;
	}

	// Restore the old pen to the device context
	pDC->SelectObject( pOldPen );

	pen.DeleteObject();
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬																	*/
/*                                                                              */
/********************************************************************************/

void CModel::MakePolygon(CPoint3 point,const float zoom,const int material)
{
	if ( state == 2 || state == 3 ) return;

	int v;
	float x = (float)point.x/zoom*100;
	float y = (float)point.y/zoom*100;
	float z = (float)point.z/zoom*100;

	// ߐڂ钸_ꍇ
	for ( v = 0; v < (int)vertices.size(); ++v )
	{
		CVertex *vertex = &vertices[v];
		if ( vertex->GetPosX() > x-5 && vertex->GetPosX() < x+5
		&&   vertex->GetPosY() > y-5 && vertex->GetPosY() < y+5
		&&   vertex->GetPosZ() > z-5 && vertex->GetPosZ() < z+5 )
		{
			polygon.PushBackIndex(v);
			goto end;
		}
	}
	// ߐڂ钸_Ȃꍇ
	polygon.PushBackIndex(v+(int)polygon_vertices.size());
	polygon_vertices.push_back(CVector(x,y,z));

end:

	// CfbNX4ɂȂƁAʂ𐳎ɍ쐬
	if ( polygon.GetIndexSize() == 4 )
	{
		SetPolygon(material);
	}
}

/********************************************************************************/
/*                                                                              */
/*		ʍ쐬																	*/
/*                                                                              */
/********************************************************************************/

void CModel::SetPolygon(int material)
{
	if ( state == 2 || state == 3 ) return;

	// ʂ𐳎ɍ쐬
	if ( polygon.GetIndexSize() )
	{
		polygon.SetMaterialNumber(material);
		faces.push_back(polygon);
		for ( int v = 0; v < (int)polygon_vertices.size(); ++v )
		{
			vertices.push_back(polygon_vertices[v]);
		}
		polygon = CFace();
		polygon_vertices.clear();
		FacesVertexBelongsTo();
	}
}

/********************************************************************************/
/*                                                                              */
/*		UVl̐ݒ																*/
/*                                                                              */
/********************************************************************************/

float u[4] = {0.0f,0.0f,1.0f,1.0f };
float v[4] = {0.0f,1.0f,1.0f,0.0f };

void CModel::SetUV(int material_number)
{
	int i;

	for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
	{
		if ( face->GetMaterialNumber() == material_number && !face->GetUVSize() )
		{
			for ( i = 0; i < face->GetIndexSize(); ++i )
			{
				face->PushBackUV(CUV(u[i],v[i]));
			}
		}
	}
}
