/********************************************************************************/
/*                                                                              */
/*		SaveMQO.cpp : Metasequoia`ŕۑ										*/
/*                                                                              */
/********************************************************************************/

#include "stdafx.h"

#include "Centigrade.h"


bool CCentigrade::SaveMQOFile(const char *filename)
{
	FILE *fp;

	if ( (fp = fopen(filename, "w+t")) == NULL ) return false;

	// NWbg
	fprintf(fp,"Metasequoia Document\n");
	fprintf(fp,"Format Text Ver 1.0\n\n");

	fprintf(fp,"Scene {\n");
	fprintf(fp,"\tpos 0.0000 0.0000 1500.0000\n");
	fprintf(fp,"\tlookat 0.0000 0.0000 0.0000\n");
	fprintf(fp,"\thead -0.3800\n");
	fprintf(fp,"\tpich 0.2300\n");
	fprintf(fp,"\tortho 0\n");
	fprintf(fp,"\tzoom2 5.0000\n");
	fprintf(fp,"\tamb 0.250 0.250 0.250\n");
	fprintf(fp,"}\n");

	// }eA
	fprintf(fp,"Material %d {\n",materials.size());
	for( vector<CMaterial>::iterator mat = materials.begin(); mat != materials.end(); ++mat )
	{
		mat->SaveMQOMaterial(fp);
	}
	fprintf(fp,"}\n");

	// IuWFNg
	for( vector<CModel>::iterator model = models.begin(); model != models.end(); ++model )
	{
		model->SaveMQOModel(fp);
	}

	fprintf(fp,"Eof\n");
	
	fclose(fp);

	return true;
}

/********************************************************************************/
/*                                                                              */
/*		MQOt@C̃}eA̕ۑ											*/
/*                                                                              */
/********************************************************************************/

bool CMaterial::SaveMQOMaterial(FILE *fp)
{
	if ( texture_name.IsEmpty() )
	{
		fprintf(fp,"\t\"%s\" shader(3) col(%f %f %f %f) dif(%f) amb(%f) emi(%f) spc(%f) power(%f)\n",
			name,r,g,b,a,diffuse,ambient,emissive,specular,power);
	}
	else
	{
		fprintf(fp,"\t\"%s\" shader(3) col(%f %f %f %f) dif(%f) amb(%f) emi(%f) spc(%f) power(%f) tex(\"%s\")\n",
			name,r,g,b,a,diffuse,ambient,emissive,specular,power,texture_name);
	}
	return true;
}

/********************************************************************************/
/*                                                                              */
/*		MQOt@C̃IuWFNg̕ۑ											*/
/*                                                                              */
/********************************************************************************/

bool CModel::SaveMQOModel(FILE *fp)
{
	fprintf(fp,"Object \"%s\" {\n",name);
	fprintf(fp,"\tvisible 15\n");
	fprintf(fp,"\tlocking 0\n");
	fprintf(fp,"\tshading 1\n");
	fprintf(fp,"\tfacet 89.5\n");
	fprintf(fp,"\tcolor 0.898 0.498 0.698\n");
	fprintf(fp,"\tcolor_type 0\n");
	// _
	fprintf(fp,"\tvertex %d {\n",vertices.size());
	for( vector<CVertex>::iterator vert = vertices.begin(); vert != vertices.end(); ++vert )
	{
		fprintf(fp,"\t\t%f %f %f\n",vert->GetPosX(),vert->GetPosY(),vert->GetPosZ());
	}
	fprintf(fp,"\t}\n");
	// ʏ
	fprintf(fp,"\tface %d {\n",faces.size());
	for( vector<CFace>::iterator face = faces.begin(); face != faces.end(); ++face )
	{
		switch ( face->GetIndexSize() )
		{
		case 2:
			fprintf(fp,"\t\t2 V(%d %d) M(%d)\n",
				face->GetIndex(0),face->GetIndex(1),face->GetMaterialNumber());
			break;
		case 3:
			if ( face->GetUVSize() )
			{
				fprintf(fp,"\t\t3 V(%d %d %d) M(%d) UV(%f %f %f %f %f %f)\n",
					face->GetIndex(0),face->GetIndex(1),face->GetIndex(2),
					face->GetMaterialNumber(),
					face->GetU(0),face->GetV(0),
					face->GetU(1),face->GetV(1),
					face->GetU(2),face->GetV(2));
			}
			else
			{
				fprintf(fp,"\t\t3 V(%d %d %d) M(%d)\n",
					face->GetIndex(0),face->GetIndex(1),face->GetIndex(2),face->GetMaterialNumber());
			}
			break;
		case 4:
			if ( face->GetUVSize() )
			{
				fprintf(fp,"\t\t4 V(%d %d %d %d) M(%d) UV(%f %f %f %f %f %f %f %f)\n",
					face->GetIndex(0),face->GetIndex(1),face->GetIndex(2),face->GetIndex(3),
					face->GetMaterialNumber(),
					face->GetU(0),face->GetV(0),
					face->GetU(1),face->GetV(1),
					face->GetU(2),face->GetV(2),
					face->GetU(3),face->GetV(3));
			}
			else
			{
				fprintf(fp,"\t\t4 V(%d %d %d %d) M(%d)\n",
					face->GetIndex(0),face->GetIndex(1),face->GetIndex(2),face->GetIndex(3),
					face->GetMaterialNumber());
			}
			break;
		}
	}
	fprintf(fp,"\t}\n");
	fprintf(fp,"}\n");

	return true;
}
