/********************************************************************************/
/*                                                                              */
/*		VACY(CyberdeliaƎ`̕ۑƓǂݍ)						*/
/*                                                                              */
/********************************************************************************/

#include "stdafx.h"
#include "Centigrade.h"


IMPLEMENT_SERIAL(CMaterial, CObject, 0)

void CMaterial::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << number;
		ar << name;
		ar << r;
		ar << g;
		ar << b;
		ar << a;
		ar << diffuse;
		ar << ambient;
		ar << emissive;
		ar << specular;
		ar << power;
		ar << texture_name;
		ar << alpha_name;
		ar << bump_name;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> number;
		ar >> name;
		ar >> r;
		ar >> g;
		ar >> b;
		ar >> a;
		ar >> diffuse;
		ar >> ambient;
		ar >> emissive;
		ar >> specular;
		ar >> power;
		ar >> texture_name;
		ar >> alpha_name;
		ar >> bump_name;
	}
}


IMPLEMENT_SERIAL(CVector, CObject, 0)

void CVector::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << x;
		ar << y;
		ar << z;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> x;
		ar >> y;
		ar >> z;
	}
}


IMPLEMENT_SERIAL(CVertex, CObject, 0)

void CVertex::Serialize(CArchive& ar)
{
	int i,v,face_size;

	pos.Serialize(ar);

	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << (int)have_faces.size();
		for ( i = 0; i < (int)have_faces.size(); ++i )
		{
			ar << have_faces[i];
		}
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> face_size;
		for ( i = 0; i < face_size; ++i )
		{
			ar >> v;
			have_faces.push_back(v);
		}
	}
}


IMPLEMENT_SERIAL(CUV, CObject, 0)

void CUV::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << u;
		ar << v;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> u;
		ar >> v;
	}
}

IMPLEMENT_SERIAL(CFace, CObject, 0)

void CFace::Serialize(CArchive& ar)
{
	int i,size;

	normal.Serialize(ar);

	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << material;
		size = (int)index.size();
		ar << size;
		for ( i = 0; i < size; ++i )
		{
			ar << index[i];
		}
		size = (int)uv.size();
		ar << size;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> material;
		ar >> size;
		index.resize(size);
		for ( i = 0; i < size; ++i )
		{
			ar >> index[i];
		}
		ar >> size;
		uv.resize(size);
	}
	for ( i = 0; i < size; ++i ) uv[i].Serialize(ar);
}


IMPLEMENT_SERIAL(CAnimation, CObject, 0)

void CAnimation::Serialize(CArchive& ar)
{
	move.Serialize(ar);
	rotate.Serialize(ar);
	scale.Serialize(ar);

	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << key;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> key;
	}
}


IMPLEMENT_SERIAL(CModel, CObject, 0)

void CModel::Serialize(CArchive& ar)
{
	int i,v_size,f_size;

	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		ar << name;
		ar << parent;
		ar << parent_name;
		v_size = (int)vertices.size();
		ar << v_size;
		f_size = (int)faces.size();
		ar << f_size;
		ar << facet;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> name;
		ar >> parent;
		ar >> parent_name;
		ar >> v_size;
		vertices.clear();
		vertices.resize(v_size);
		ar >> f_size;
		faces.resize(f_size);
		ar >> facet;
	}
	for ( i = 0; i < v_size; ++i ) vertices[i].Serialize(ar);
	for ( i = 0; i < f_size; ++i ) faces[i].Serialize(ar);
}

IMPLEMENT_SERIAL(CCentigrade, CObject, 0)

void CCentigrade::Serialize(CArchive& ar)
{
	int i,size,m_size;

	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
		size = (int)models.size();
		ar << size;
		m_size = (int)materials.size();
		ar << m_size;
		ar << model_number;
		ar << material_number;
		ar << bSmooth;
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
		ar >> size;
		models.clear();
		models.resize(size);
		ar >> m_size;
		materials.clear();
		materials.resize(m_size);
		ar >> model_number;
		ar >> material_number;
		ar >> bSmooth;
	}
	for ( i = 0; i < size; ++i ) models[i].Serialize(ar);
	camera.Serialize(ar);
	for ( i = 0; i < m_size; ++i ) materials[i].Serialize(ar);
}
