/********************************************************************************/
/*                                                                              */
/*		String																	*/
/*                                                                              */
/********************************************************************************/

#include "stdafx.h"
#include <windows.h>
#include <stdlib.h>
#include "Strings.h"

static const char SepTbl[SEPARATE_TABLE_SIZE] = {
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 1,1,0,0,1,0,0,0, //(),
	0,0,0,0,0,0,0,0, 0,0,1,1,0,1,0,0, //:;=
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,1,0,1,0,0, //[]
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,1,0,1,0,0, //{}
};

//---------------------------------------------------------------------------
//  StringSeparator class
//---------------------------------------------------------------------------
StringSeparator::StringSeparator()
{
	scan = NULL;
	MaxScan = CurCount = 0;

	StringChar = '"';
	memcpy(SeparateTable, SepTbl, SEPARATE_TABLE_SIZE);
}

StringSeparator::~StringSeparator()
{
	if(scan != NULL){
		for(int i=0; i<MaxScan; i++){
			if(scan[i] != NULL) free(scan[i]);
		}
		free(scan);
	}
}

void StringSeparator::GetSeparateTable(char *table)
{
	memcpy(table, SeparateTable, SEPARATE_TABLE_SIZE);
}

void StringSeparator::SetSeparateTable(char *table)
{
	memcpy(SeparateTable, table, SEPARATE_TABLE_SIZE);
}

char StringSeparator::GetStringChar(void)
{
	return StringChar;
}

void StringSeparator::SetStringChar(char ch)
{
	StringChar = ch;
}

bool StringSeparator::SetScan(int index, char *str)
{
	if(index >= MaxScan){
		scan = (char **)realloc(scan, sizeof(char*) * (index+1));
		for(int i=MaxScan; i<=index; i++)
			scan[i] = NULL;
		MaxScan = index+1;
	}

	if(scan[index] != NULL)
		free(scan[index]);

	int len = lstrlen(str) + 1;
	scan[index] = (char *)malloc(len);
	memcpy(scan[index], str, len);

	return true;
}

bool StringSeparator::SetScan(int index, wchar_t *wstr)
{
	int len = WideCharToMultiByte(CP_OEMCP, 0, wstr, -1, NULL, 0, NULL, NULL);
	char *mchar = (char *)malloc(len);
	WideCharToMultiByte(CP_OEMCP, 0, wstr, -1, mchar, len, NULL, NULL);

	SetScan(index, mchar);

	free(mchar);

	return true;
}

int StringSeparator::Separate(const char *str)
{
#if 0
	int widesize;

	widesize = MultiByteToWideChar(CP_OEMCP, MB_PRECOMPOSED, str, -1, NULL, 0);
	if(widesize == 0) return 0;

	wchar_t *widestr = (wchar_t *)malloc(widesize * sizeof(wchar_t));
	MultiByteToWideChar(CP_OEMCP, MB_PRECOMPOSED, str, -1, widestr, widesize);

	int ec=0, len=0;
	int maxlen = 4096;
	wchar_t *buf = (wchar_t *)malloc((maxlen+1) * sizeof(wchar_t));
	wchar_t wch[2], *ptr;
	bool bstr = false;

	for(ptr=widestr; ; ptr++)
	{
		switch(*ptr){
		case 0x0D:
		case 0x0A:
		case 0:
			if(len > 0){
				buf[len] = '\0';
				SetScan(ec++, buf);
			}
			goto GS_EXIT;
		case ' ':
		case 0x09:
			if(bstr) goto ADDCHAR;
			if(len > 0){
				buf[len] = '\0';
				SetScan(ec++, buf);
				len = 0;
			}
			break;
		case '"':
			if(bstr){
				buf[len] = '\0';
				SetScan(ec++, buf);
				len=0; bstr=false;
			} else {
				if(len > 0){
					buf[len] = '\0';
					SetScan(ec++, buf);
					len=0;
				}
				bstr=true;
			}
			break;
		case '=':
		case '(':
		case ')':
		case '[':
		case ']':
		case '{':
		case '}':
		case ';':
		case ',':
			if(bstr) goto ADDCHAR;
			if(len > 0){
				buf[len] = '\0';
				SetScan(ec++, buf);
				len=0;
			}
			wch[0] = *ptr;
			wch[1] = '\0';
			SetScan(ec++, wch);

			break;
		ADDCHAR:
		default:
			if(len < maxlen)
				buf[len++] = *ptr;
			break;
		}
	}

GS_EXIT:
	free(widestr);
	free(buf);

	return ec;

#else

	char *buf;
	const char *ptr;
	int len,maxlen,count;
	bool instr = false;

	maxlen = lstrlen(str) + 1; 
	buf = (char *)malloc(maxlen);
	for(ptr=str,len=count=0; len<maxlen; ptr++)
	{
		if(IsDBCSLeadByte(*ptr)){
			buf[len++] = *ptr++;
			buf[len++] = *ptr;
		} else switch(*ptr){
		case 0x0D:
		case 0x0A:
		case 0:
			if(len > 0){
				buf[len] = '\0';
				SetScan(count++, buf);
			}
			goto GS_EXIT;
		case ' ':
		case 0x09:
			if(instr) goto ADDCHAR;
			if(len > 0){
				buf[len] = '\0';
				SetScan(count++, buf);
				len = 0;
			}
			break;
		default:
			if(*ptr == StringChar){
				if(instr){
					buf[len] = '\0';
					SetScan(count++, buf);
					len=0; instr=false;
				} else {
					if(len > 0){
						buf[len] = '\0';
						SetScan(count++, buf);
						len=0;
					}
					instr=true;
				}
			} else if(*ptr>=0 && SeparateTable[*ptr]){
				if(instr) goto ADDCHAR;
				if(len > 0){
					buf[len] = '\0';
					SetScan(count++, buf);
					len=0;
				}
				buf[0] = *ptr;
				buf[1] = '\0';
				SetScan(count++, buf);
			} else {
ADDCHAR:
				buf[len++] = *ptr;
			}
		}
	}

GS_EXIT:
	free(buf);

	return CurCount = count;
#endif
}

bool StringSeparator::CheckCommand(const char *comstr, int optc)
//optc    count of option strings to need
{
	return (optc<=CurCount && strcmpi(scan[0], comstr) == 0);
}

bool StringSeparator::CheckString(int index, const char *str)
//optc    count of option strings to need
{
	return (index<CurCount && strcmpi(scan[index], str) == 0);
}

int StringSeparator::ToInt(int index)
{
	if(index >= CurCount) return 0;
	return atoi(scan[index]);
}

double StringSeparator::ToDouble(int index)
{
	if(index >= CurCount) return 0;
	return atof(scan[index]);
}


//---------------------------------------------------------------------------
//  FileStringSeparator class
//---------------------------------------------------------------------------
FileStringSeparator::FileStringSeparator(FILE *_fh) : StringSeparator()
{
	fh = _fh;
}

FileStringSeparator::FileStringSeparator(char *filename) : StringSeparator()
{
	fh = fopen(filename, "rb");
	if(fh == NULL) throw;
}

int FileStringSeparator::GetLine(void)
//if file is end, return EOF, or count of elements
{
#if 0
	char *buf = (char *)malloc(8192);
	if(fgets(buf, 8191, fh) != NULL)
		CurCount = Separate(buf);
	else
		CurCount = EOF;
	free(buf);

#else

	BYTE *buf;
	int i,c;
	int maxlen = 4096;
	long fp;

	buf = (BYTE *)malloc(maxlen);
	for(i=0; ; i++)
	{
		if(i >= maxlen-4){
			maxlen *= 2;
			buf = (BYTE *)realloc(buf, maxlen);
		}
		c = fgetc(fh);
		switch(c){
		case EOF:
		GET_EOF:
			buf[i] = 0;
			if(i == 0){
				CurCount=EOF;
				goto EXIT;
			}
			goto LOAD_END;
		case 0x0D:
			buf[i] = 0;
			fp = ftell(fh);
			c = fgetc(fh);
			if(c != 0x0A)
				fseek(fh, fp, SEEK_SET);
			goto LOAD_END;
		case 0x0A:
			buf[i] = 0;
			goto LOAD_END;
		default:
			if(IsDBCSLeadByte((BYTE)c)){
				buf[i++] = (BYTE)c;
				c = fgetc(fh);
				if(c == EOF) goto GET_EOF;
			}
			buf[i] = (BYTE)c;
		}
	}

LOAD_END:
	Separate((char*)buf);
EXIT:
	free(buf);

#endif

	return CurCount;
}

//---------------------------------------------------------------------------
//  AsciiFileString class
//---------------------------------------------------------------------------
AsciiFileString::AsciiFileString(FILE *_fh) : FileStringSeparator(_fh)
{
}

int AsciiFileString::GetLine(void)
//if file is end, return EOF, or count of elements
{
#if 1
	char *buf = (char *)malloc(8192);
	if(fgets(buf, 8191, fh) != NULL)
		CurCount = Separate(buf);
	else
		CurCount = EOF;
	free(buf);

	return CurCount;
#else
	return FileStringSeparator::GetLine();
#endif
}

//---------------------------------------------------------------------------
//  MacFileString class
//---------------------------------------------------------------------------
MacFileString::MacFileString(FILE *_fh) : FileStringSeparator(_fh)
{
}

int MacFileString::GetLine(void)
//if file is end, return EOF, or count of elements
{
	return FileStringSeparator::GetLine();
}


