/********************************************************************************/
/*                                                                              */
/*		Strings.h																*/
/*                                                                              */
/********************************************************************************/

//---------------------------------------------------------------------------
#ifndef StringsH
#define StringsH

#include <stdio.h>
//---------------------------------------------------------------------------

#define SEPARATE_TABLE_SIZE  128

class StringSeparator
{
protected:
	char **scan;
	int MaxScan, CurCount;
	char SeparateTable[SEPARATE_TABLE_SIZE];
	char StringChar;

	bool SetScan(int index, char *str);
	bool SetScan(int index, wchar_t *wstr);
public:
	StringSeparator();
	virtual ~StringSeparator();

	void GetSeparateTable(char *table);
	void SetSeparateTable(char *table);
	char GetStringChar(void);
	void SetStringChar(char ch);

	int Separate(const char *str);

	bool CheckCommand(const char *comstr, int optc);
	bool CheckString(int index, const char *str);

	inline bool chkcom(const char *comstr, int optc) { return CheckCommand(comstr, optc); }
	inline bool chkstr(int index, const char *str) { return CheckString(index, str); }

	int ToInt(int index);
	double ToDouble(int index);
	inline float ToFloat(int index) {return (float)ToDouble(index); }
	inline char *GetString(int index) { return scan[index]; }

	inline int GetCount(void) { return CurCount; }
};

class FileStringSeparator : public StringSeparator
{
protected:
	FILE *fh;
public:
	FileStringSeparator(FILE *_fh);
	FileStringSeparator(char *filename);

	virtual int GetLine(void);
	inline FILE *GetFileHandle(void) {return fh;}
};

class AsciiFileString : public FileStringSeparator
{
public:
	AsciiFileString(FILE *_fh);
	virtual int GetLine(void);
};

class MacFileString : public FileStringSeparator
{
public:
	MacFileString(FILE *_fh);
	virtual int GetLine(void);
};
//---------------------------------------------------------------------------
int GetStrings(char *src, char *dest[], int maxdest);
//---------------------------------------------------------------------------
#endif
