//------------------------------------------------------------------------
//VixarLibrary.h
//------------------------------------------------------------------------

#pragma once

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <sys/timeb.h>
#include <time.h>

#include <d3d9.h>
#include <d3dx9.h>
#include <dinput.h>
#include <dmusici.h>
#include <dsound.h>

#include <vector>
#include <string>
#include <sstream>

using namespace std;

#pragma	comment(lib, "d3d9.lib")
#pragma	comment(lib, "d3dx9.lib")
#pragma comment(lib, "dinput8.lib")
#pragma comment(lib, "dxguid.lib")
#pragma comment(lib, "dsound.lib")
#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "odbc32.lib")
#pragma comment(lib, "odbccp32.lib")
#ifdef NDEBUG
#pragma comment(lib, "VixarLibrary.lib")
#else
#pragma comment(lib, "VixarLibraryD.lib")
#endif

//}Nŉ
#define SAFE_RELEASE(x){ if(x != NULL){ x->Release(); x=NULL; } }
//}Nŉ
#define SAFE_DELETE(p) { if(p != NULL){ delete (p); (p)=NULL; } }
//}Nŉ
#define SAFE_DELETE_ARRAY(p) { if(p != NULL) { delete[] (p);   (p)=NULL; } }

//~[WbNt@C̍ő吔
#define MUSIC_MAX 8
//TEht@C̍ő吔
#define SOUND_MAX 16

//݂̃fBNg擾
char* GetDirectory(void);
//ľܓ
int	round(float value);
//eye猩at̕WAŎ擾
float GetDirRadian(D3DXVECTOR3 eye, D3DXVECTOR3 at);
//eye猩at̕fBO[(x)Ŏ擾
float GetDirDegree(D3DXVECTOR3 eye, D3DXVECTOR3 at);
D3DXMATRIX GetPosture(D3DXVECTOR3* vecUpper,D3DXVECTOR3* vecFront);

//------------------------------------------------------------------------
//}eANX
//------------------------------------------------------------------------
class CMaterial
{
public:
	//RXgN^
	CMaterial();
	//fXgN^
	~CMaterial();

private:
	//}eA
	std::string m_name;
	//ԁE΁EEAt@
	float m_r, m_g, m_b, m_a;
	//Shader
	int m_shader;
	//gU
	float m_diffuse;
	//͌
	float m_ambient;
	//ȏƖ
	float m_emissive;
	//ˌ
	float m_specular;
	//˂̋
	float m_power;
	//eNX`
	std::string m_texture_name;
	//At@eNX`
	std::string m_alpha_name;
	//oveNX`
	std::string m_bump_name;
	//}eAIuWFNg
	D3DMATERIAL9 m_material;
	//eNX`IuWFNg
	LPDIRECT3DTEXTURE9 m_texture;

public:
	//}eAZbg
	void SetName(std::string name);
	//}eA擾
	std::string GetName();
	//ԁE΁EEAt@Zbg
	void SetRGBA(float r,float g,float b,float a);
	//Ԏ擾
	float GetR() const;
	//Ύ擾
	float GetG() const;
	//擾
	float GetB() const;
	//At@擾
	float GetA() const;
	//ShaderZbg
	void SetShader(int shader);
	//Shader擾
	int GetShader();
	//gUZbg
	void SetDiffuse(float diffuse);
	//gU擾
	float GetDiffuse();
	//͌Zbg
	void SetAmbient(float ambient);
	//͌擾
	float GetAmbient();
	//ȏƖZbg
	void SetEmissive(float emissive);
	//ȏƖ擾
	float GetEmissive();
	//ˌZbg
	void SetSpecular(float specular);
	//ˌ擾
	float GetSpecular();
	//˂̋Zbg
	void SetPower(float power);
	//˂̋擾
	float GetPower();
	//eNX`Zbg
	void SetTextureName(std::string texture_name);
	//eNX`擾
	std::string GetTextureName();
	//At@eNX`Zbg
	void SetAlphaName(std::string alpha_name);
	//At@eNX`擾
	std::string GetAlphaName();
	//oveNX`Zbg
	void SetBumpName(std::string bump_name);
	//oveNX`擾
	std::string GetBumpName();
	//}eAIuWFNg擾
	D3DMATERIAL9 *GetMaterial();
	//eNX`IuWFNg擾
	LPDIRECT3DTEXTURE9 GetTexture();
	//}eAZbg
	void SetMaterial();
	//eNX`t@Cǂݍ
	void LoadTexture(LPDIRECT3DDEVICE9 dev);
	//eNX`̉
	void ReleaseTexture();

public:
	//Zq̃I[o[[h
	CMaterial& operator=(const CMaterial& pt);
	//Zq̃I[o[[h
	CMaterial (const CMaterial& pt);
};

//------------------------------------------------------------------------
//_																                                                                              
//------------------------------------------------------------------------
struct NVERTEX
{
	//_W
	float x,y,z;
	//@
	float nx,ny,nz;
	//UVl
	float tu,tv;
};
//_
#define	FVF_NVERTEX (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1)
//_Zbg
void SetNVertex(NVERTEX *v,const D3DXVECTOR3& pos,const D3DXVECTOR3& normal,float tu,float tv);

//------------------------------------------------------------------------
//_NX	
//------------------------------------------------------------------------
class CVertex
{
public:
	//RXgN^
	CVertex();
	//fXgN^
	CVertex (float x, float y, float z);

private:
	//ʒuW
	D3DXVECTOR3 m_pos;
	//@
	D3DXVECTOR3 m_normal;
	//_Lʔz
	vector < UINT > m_have_faces;

public:
	//ʒuZbg
	void SetPos(D3DXVECTOR3 v);
	//ʒu擾
	D3DXVECTOR3 GetPos() const;
	//@Zbg
	void SetNormal(D3DXVECTOR3 v);
	//@擾
	D3DXVECTOR3 GetNormal();
	//_Lʂzɒǉ
	void PushBackHaveFaces(int f);
	//_Lʂz̃TCY擾
	int GetHaveFacesSize();
	//_Lʂz̎擾
	int GetHaveFaces(int f);
	//@̐K
	void Normalize();
	//@Z
	void AddNormal(D3DXVECTOR3 v);

public:
	//Zq̃I[o[[h
	CVertex& operator=(const CVertex& pt);
	//Zq̃I[o[[h
	CVertex(const CVertex& pt);
};

//------------------------------------------------------------------------
//UVWNX
//------------------------------------------------------------------------
class CUV
{
public:
	//RXgN^
	CUV();
	//RXgN^
	CUV(float u,float v);
	//fXgN^
	~CUV();

public:
	//UVW
	float m_u,m_v;

public:
	//Zq̃I[o[[h
	CUV& operator=(const CUV& pt);
	//Zq̃I[o[[h
	CUV (const CUV& pt);
};

//------------------------------------------------------------------------
//ʃNX
//------------------------------------------------------------------------
class CFace
{
public:
	//RXgN^
	CFace();
	//fXgN^
	~CFace();

private:
	//}eAԍ
	int m_material;
	//ʂ̖@
	D3DXVECTOR3 m_normal;
	//_CfbNX
	vector < UINT > m_index;
	//UVW
	vector < CUV > m_uv;
	//_Ƃ̖@
	vector < CVertex > m_vertex;

public:
	//}eAԍZbg
	void SetMaterial(int material);
	//}eAԍ擾
	int GetMaterial() const;
	//_CfbNXǉ
	void PushBackIndex(int i);
	//_CfbNXTCY擾
	int GetIndexSize() const;
	//_CfbNX擾
	UINT GetIndex(UINT i);
	//UW擾
	float GetU(UINT i);
	//VW擾
	float GetV(UINT i);
	//UVWzTCY擾
	int GetUVSize();
	//UVWzɒǉ
	void PushBackUV(const CUV& i);
	//@Zbg
	void SetNormal(D3DXVECTOR3 normal);
	//@擾
	D3DXVECTOR3 GetNormal() const;
	//@̐K
	void Normalize();
	//O
	void CrossProduct(const D3DXVECTOR3& a,const D3DXVECTOR3& b);
	//_ǉ
	void PushBackVertex(CVertex v);
	//_TCYύX
	void ResizeVertex(int i);
	//_TCY擾
	int GetVertexSize();
	//_@Zbg
	void SetVNormal(int i,D3DXVECTOR3 v);
	//_@ǉ
	void AddVNormal(int i,D3DXVECTOR3 v);
	//_@擾
	D3DXVECTOR3 GetVNormal(int i);
	//_ʒǉ
	void PushBackHaveFaces(int i,int f);
	//_ʃTCY擾
	int GetHaveFacesSize(int i);
	//_ʎ擾
	int GetHaveFaces(int i,int f);
	//_@K
	void VNormalize(int i);

public:
	//Zq̃I[o[[h
	CFace& operator=(const CFace& pt);
	//Zq̃I[o[[h
	CFace (const CFace& pt);
};

//------------------------------------------------------------------------
//fNX
//------------------------------------------------------------------------
class CModel
{
public:
	//RXgN^
	CModel();
	//fXgN^
	~CModel();

private:
	//f
	std::string m_name;
	//_obt@
	LPDIRECT3DVERTEXBUFFER9 m_vb;
	//
	int m_mirror_axis;
	//X[WOpx
	float m_facet;
	//_z
	vector < D3DXVECTOR3 > m_vertices;
	//ʔz
	vector < CFace > m_faces;
	//ʂ̃O[v
	vector < int > m_groups;
	//Aj[V
	vector < vector<D3DXMATRIX> > m_animations;
	//gXtH[
	D3DXMATRIX m_transform;

public:
	//ʃCfbNX̎擾
	int GetFaceIndex(int i,int j);
	//_W̎擾
	D3DXVECTOR3 GetVertexPos(int i);
	//f̃Zbg
	void SetName(std::string name);
	//f擾
	std::string GetName();
	//ʃZbg
	void SetMirrorAxis(int mirror_axis);
	//ʎ擾
	int GetMirrorAxis();
	//X[WOpxZbg
	void SetFacet(float facet);
	//X[WOpx擾
	float GetFacet();
	//_zɒǉ
	void PushBackVertex(const D3DXVECTOR3& v);
	//ʔzɒǉ
	void PushBackFace(const CFace& f);
	//_z̃TCY擾
	int GetVerticesSize();
	//ʔz̃TCY擾
	int GetFacesSize();
	//ʂ̖@vZ
	void CalcFlatFaceNormal();
	//_̖@vZ
	void CalcFaceVertexNormal();
	//_ʂvZ
	void FacesVertexBelongsTo();
	//Aj[Vzɒǉ
	void PushBackAnimation();
	//Aj[Vzɒǉ2
	void PushBackAnimation(int i,const D3DXMATRIX& m);
	//Aj[V擾
	D3DXMATRIX GetAnimation(int i,int j);
	//Aj[Vz̃TCY擾
	int GetAnimationSize();
	//Aj[Vz̃TCY擾2
	int GetAnimationSize(int i);
	//蔻
	bool Collision(D3DXVECTOR3 pos,D3DXVECTOR3 dir,float* distance=NULL,D3DXVECTOR3* normal=NULL);
	//}EXƂ̓蔻
	int MousePick(int x,int y,LPDIRECT3DDEVICE9 dev,D3DXVECTOR3* pos=NULL);
	//v~eBu̕`
	void DrawPrimitive(LPDIRECT3DDEVICE9 dev,D3DXMATRIX *matWorld,std::vector<CMaterial> &materials);
	//_obt@̍쐬
	void CreateVertexBuffer(LPDIRECT3DDEVICE9 dev,std::vector<CMaterial> &materials);
	//_obt@̉
	void ReleaseVB();

public:
	//Zq̃I[o[[h
	CModel& operator=(const CModel& pt);
	//Zq̃I[o[[h
	CModel (const CModel& pt);
};

//------------------------------------------------------------------------
//LN^[NX
//------------------------------------------------------------------------
class CCharacter
{
public:
	//RXgN^
	CCharacter();
	//RXgN^
	CCharacter(std::string s);
	//fXgN^
	~CCharacter();

private:
	//fz
	vector < CModel > m_models;
	//蔻pf
	int m_collision_model;
	//}eAz
	vector < CMaterial > m_materials;
	//Aj[Vz
	vector < std::string > m_animation_names;
	//gXtH[
	D3DXMATRIX m_transform;
	//ړ(ʒuWł͂Ȃ)
	D3DXVECTOR3 m_move;
	//]
	D3DXVECTOR3 m_rotate;
	//XP[
	D3DXVECTOR3 m_scale;
	//Aj[V
	float m_animation;
	//݂̃Aj[V
	int m_current_animation;
	//Aj[V[vtO
	bool m_animation_loop;
	//Aj[VŌŒ~(true)Aŏɖ߂(false)
	bool m_animation_last;
	//Aj[VĐH
	bool m_animation_playing;

public:
	//Aj[V擾
	const char* GetAnimationName(int i);
	//Aj[Vǉ
	void PushBackAnimationName(std::string s);
	//Aj[VĐ
	void PlayAnimation(int current,bool loop = true,bool last = false);
	//Aj[V~
	void StopAnimation();
	//Aj[VĐ擾
	bool GetAnimationPlaying();
	//Aj[VŌŒ~邩擾
	bool GetAnimationLast();
	//݂̃Aj[V擾
	int GetCurrentAnimation();
	//Aj[V擾
	float GetAnimation();
	//gXtH[Zbg
	void SetTransform(D3DXMATRIX m);
	//gXtH[擾
	D3DXMATRIX GetTransform();
	//gXtH[猻݈ʒu擾
	D3DXVECTOR3 GetPosition();
	//fz̍ŏ
	vector<CModel>::iterator GetModelsBegin();
	//fz̏I擾
	vector<CModel>::iterator GetModelsEnd();
	//fz̃TCY擾
	int GetModelsSize();
	//fz̃TCYύX
	void ResizeModels(int i);
	//fz̍Ō擾
	CModel* GetModelsBack();
	//f擾
	CModel* GetModel(int i);
	//f̃|C^擾
	CModel GetModel2(int i);
	//fzɒǉ
	void PushBackModel(CModel m);
	//f擾
	std::string GetModelName(int i);
	//蔻胂fT
	void SearchCollisionModel();
	//蔻
	bool Collision(D3DXVECTOR3 pos,D3DXVECTOR3 dir,float* distance=NULL,D3DXVECTOR3* normal=NULL);
	//}EXƂ̓蔻
	bool MousePick(int x,int y,LPDIRECT3DDEVICE9 dev,D3DXVECTOR3* pos=NULL);
	//gXtH[ƕ`
	void TransformAndDrawModels(LPDIRECT3DDEVICE9 dev);
	//_obt@쐬
	void CreateVertexBuffer(LPDIRECT3DDEVICE9 dev);
	//ړZbg
	void SetMove(float x,float y,float z);
	//ړZ
	void AddMove(float x,float y,float z);
	//ړZ
	D3DXVECTOR3 MultiplyMove(float x,float y,float z);
	//ړ擾
	D3DXVECTOR3 GetMove();
	//Xړ擾
	float GetMoveX();
	//Yړ擾
	float GetMoveY();
	//Zړ擾
	float GetMoveZ();
	//]Zbg
	void SetRotate(float x,float y,float z);
	//]Z
	void AddRotate(float x,float y,float z);
	//]擾
	D3DXVECTOR3 GetRotate();
	//X]擾
	float GetRotateX();
	//Y]擾
	float GetRotateY();
	//Z]擾
	float GetRotateZ();
	//XP[Zbg
	void SetScale(float x,float y,float z);
	//XP[Z
	void AddScale(float x,float y,float z);
	//XP[擾
	D3DXVECTOR3 GetScale();
	//}eAzɒǉ
	void PushBackMaterial(const CMaterial& mat);
	//}eAZbg
	void SetMaterials(std::vector<CMaterial> &mat);
	//}eAzTCY擾
	int GetMaterialSize();
	//}eA|C^擾
	CMaterial* GetMaterial(int i);
	//eNX`ǂݍ
	void LoadTexture(LPDIRECT3DDEVICE9 dev);
	// MQAt@C̓ǂݍ
	bool LoadMQAFile(std::string file_name,LPDIRECT3DDEVICE9 dev);
	//LN^[̃Rs[
	void Copy(CCharacter* pt);
	// 3DW2DWɃgXtH[܂B
	POINT GetScreenPosition(LPDIRECT3DDEVICE9 dev);
	//Zq̃I[o[[h
	CCharacter& operator=(const CCharacter& pt);
	//Zq̃I[o[[h
	CCharacter (const CCharacter& pt);
};

//------------------------------------------------------------------------
//CDirectXGraphicsNX
//------------------------------------------------------------------------
class CDirectXGraphics
{
public:
	//RXgN^
	CDirectXGraphics();
	//RXgN^
	CDirectXGraphics(HWND hWnd,bool window,int width,int height);
	//fXgN^
	~CDirectXGraphics();

private:
	//wiF
	D3DCOLOR m_bgColor;
	//A_v^[
	int   m_adapter;
	//ʕ
	float m_width;
	//ʍ
	float m_height;
	//Direct3D
	LPDIRECT3D9 m_pD3D;
	//Direct3DfoCX
	LPDIRECT3DDEVICE9 m_pD3DDevice;
	//Direct3Dp[^[
	D3DPRESENT_PARAMETERS m_d3dpp;
	//Cg
	D3DLIGHT9 m_light;
	//XvCg|C^
	LPD3DXSPRITE m_pSprite;	

public:
	//Direct3DfoCX̎擾
	LPDIRECT3DDEVICE9 GetD3DDevice();
	//wiFZbg
	void SetBgColor(int r,int g,int b);
	//ʃTCYύX
	void OnSize(int cx, int cy);
	//_OJn
	void BeginRendering(float nearZ=100.0f,float farZ=10000.0f,float fov=10.0f);
	//JZbg
	void SetCamera(D3DXVECTOR3 eye,D3DXVECTOR3 at);
	//CgZbg
	void SetLight(D3DXVECTOR3 dir);
	//_OI
	void EndRendering();
	//Zobt@NA
	void ClearZBuffer();
	//XvCg쐬
	BOOL CreateSprite();
	//XvCgJn
	void BeginSprite();
	//XvCgI
	void EndSprite();
	//XvCg擾
	LPD3DXSPRITE GetSprite();
	//tHg쐬
	BOOL CreateFont(LPD3DXFONT *ppFont,int w,int h,bool bold,std::string font);
	//tHg`
	void DrawText(ID3DXFont* pFont,std::string text,int left,int top,int right,int bottom,DWORD format,D3DCOLOR color);
};

//------------------------------------------------------------------------
//XvCgNX
//------------------------------------------------------------------------
class CSprite
{
public:
	//RXgN^
	CSprite(void);
	//RXgN^
	CSprite(HWND hWnd,LPDIRECT3DDEVICE9 dev,char* fileName,int width,int height,bool alpha);
	//fXgN^
	~CSprite(void);

private:
	//eNX`IuWFNg
	LPDIRECT3DTEXTURE9 m_pImage;
	//ʒuW
	D3DXVECTOR3		   m_position;

public:
	//C[W̓ǂݍ
	void CreateImage(HWND hWnd,LPDIRECT3DDEVICE9 dev,char* fileName,int width,int height,bool alpha);
	//C[W`
	void Draw(LPD3DXSPRITE sprite,int left,int top,int right,int bottom);
	//ʒuZbg
	void SetPosition(float x,float y,float z);
};

//------------------------------------------------------------------------
//CDirectInputNX
//------------------------------------------------------------------------

#define FREE_KEY 0//L[ĂȂ
#define PUSH_KEY 1//L[ꂽu
#define PULL_KEY 2//L[ꂽu
#define HOLD_KEY 3//L[Ă

class CDirectInput
{
public:
	//RXgN^
	CDirectInput(void);
	//fXgN^
	~CDirectInput(void);

private:
	//DirectInput
	LPDIRECTINPUT8			m_pDirectInput;         
	//DirectInputfoCX
	LPDIRECTINPUTDEVICE8	m_pKeyboard;

public:
	//DirectInput쐬
	HRESULT CreateDirectInput(HWND hWnd);
	//L[{[hԎ擾
	bool GetKeyboardInput(int key,int& flag);
	//ANZX̃Zbg
	void SetAcquire(bool b);
};

//------------------------------------------------------------------------
//yt@CǂݍōĐNX
//------------------------------------------------------------------------
class CDirectMusic
{
public:
	//RXgN^
	CDirectMusic();
	//fXgN^
	~CDirectMusic();

private:
	//DirectMusic[_[
	IDirectMusicLoader8*		m_pLoader;
	//DirectMusicptH[}X
	IDirectMusicPerformance8*	m_pPerformance;
	//DirectMusicZOg
	IDirectMusicSegment8*		m_pSegment[MUSIC_MAX];

public:
	//̉
	VOID DeleteObj();			
	//
	HRESULT Init();	
	//t@C[h
	bool fileLoad(int sound,char* fileName);
	//Đ
	HRESULT Play(int sound,BOOL bRepeats);
	//ĐH
	HRESULT IsPlaying(int sound);
	//~
	HRESULT Stop(int sound);
};

//------------------------------------------------------------------------
//WAVTEhĐNX
//------------------------------------------------------------------------
class CDirectSound
{
private:
	// DirectSound8
	LPDIRECTSOUND8		m_lpDS;	
	// vC}TEhobt@
	LPDIRECTSOUNDBUFFER	m_lpPrimary;
	// ZJ_TEhobt@
	LPDIRECTSOUNDBUFFER	m_lpSecondary[SOUND_MAX];

public:
	//RXgN^
	CDirectSound();
	//fXgN^
	~CDirectSound();
	//
	BOOL Init(HWND hWnd);
	//vC}TEhobt@쐬
	BOOL CreatePrimaryBuffer(void);
	//WAVt@Cǂݍ
	BOOL LoadSound(int sound,char *fileName);
	//
	BOOL Release(void);
	//Đ
	void Play(int sound,BOOL loop=false);
	//~
	void Stop(int sound);
	//Đʒuw
	void SetCurrentPosition(int sound,int pos);
};
