﻿var Material = function(r,g,b,a,dif,amb,emi,spc,power,texture)
{
	this._r = r;
	this._g = g;
	this._b = b;
	this._a = a;
	this._dif = dif;
	this._amb = amb;
	this._emi = emi;
	this._spc = spc;
	this._power = power;
	if ( texture == "Fukidashi" )
	{
		this._fukidashi = true;
		this._texture = _gl.createTexture(1024, 1024);
	}
	else
	{
		this._fukidashi = false;
		this._texture = texture;
	}
	this._imageData = null;
};

Material.prototype =
{
	init : function()
	{
	},
	getMaterial : function()
	{
		return this;
	},
	setColor : function(r,g,b,a)
	{
		this._r = r;
		this._g = g;
		this._b = b;
		this._a = a;
	},
	setTexture : function()
	{
		if ( this._texture )
		{
			_gl.activeTexture(_gl.TEXTURE0);
			_gl.bindTexture(_gl.TEXTURE_2D, this._texture);
			_gl.uniform1i(_shaderProgram.u_sampler, 0);
		}
		else
		{
			return false;
		}

		return true;
	},
	changeTexture : function(texture)
	{
		if ( this._texture )
		{
			_gl.deleteTexture(this._texture);
			this._texture = texture;
		}
	},
	setText : function(text,scale)
	{
		if ( !this._fukidashi )
		{
			return;
		}
		var canvas = document.getElementById('PsychoVision3D-Canvas2D');
		if ( ! canvas || ! canvas.getContext ) { return false; }
		var ctx = canvas.getContext('2d');
		ctx.fillStyle = "rgba("+this._r*255+","+this._g*255+","+this._b*255+","+this._a*255+")";
		ctx.fillRect(0, 0, canvas.width, canvas.height);
		ctx.fillStyle= _fontColor;
		ctx.textAlign = "center";
		var average = (scale.x>0)?scale.x:1;
		ctx.font = (_boldFont?"bold ":"")+_fukidashiFontSize/average+"px 'メイリオ'";
		var txt = text.split("￥ｎ");
		var top = (_fukidashiFontSize-18)/average+(1024-txt.length*(_fukidashiFontSize+12)/average)/2;
		for ( var i = 0; i < txt.length; i++ )
		{
			ctx.fillText(txt[i], 512, top+i*(_fukidashiFontSize+12)/average);
		}
		this._imageData = ctx.getImageData(0, 0, 1024, 1024);

		_gl.bindTexture(_gl.TEXTURE_2D, this._texture);
		_gl.texImage2D(_gl.TEXTURE_2D, 0, _gl.RGBA, _gl.RGBA, _gl.UNSIGNED_BYTE, this._imageData);
		_gl.texParameteri(_gl.TEXTURE_2D, _gl.TEXTURE_MAG_FILTER, _gl.LINEAR);
		_gl.texParameteri(_gl.TEXTURE_2D, _gl.TEXTURE_MIN_FILTER, _gl.LINEAR);
		_gl.bindTexture(_gl.TEXTURE_2D, null);
	}
};
