const _glslVertex = `
attribute vec3 a_VertexPosition;
attribute vec3 a_VertexNormal;
attribute vec2 a_TextureCoord;
attribute vec4 a_Bone;
attribute vec4 a_Weight;
uniform mat4 u_MVMatrix;
uniform mat4 u_PMatrix;
uniform mat3 u_NMatrix;
uniform mat4 u_BoneMatrix[28];
uniform bool u_UseBone;
varying vec3 v_TransformedNormal;
varying vec4 v_Position;
varying vec2 v_TextureCoord;
varying vec3 v_VertexNormal;

void main(void)
{
	if (u_UseBone)
	{
		mat4 m = u_BoneMatrix[int(a_Bone.x)]*a_Weight.x;
		m += u_BoneMatrix[int(a_Bone.y)]*a_Weight.y;
		m += u_BoneMatrix[int(a_Bone.z)]*a_Weight.z;
		m += u_BoneMatrix[int(a_Bone.w)]*a_Weight.w;
		v_Position = u_MVMatrix * m * vec4(a_VertexPosition, 1.0);
		v_TransformedNormal = u_NMatrix * mat3(m) * a_VertexNormal;
	}
	else
	{
		v_Position = u_MVMatrix * vec4(a_VertexPosition, 1.0);
		v_TransformedNormal = u_NMatrix * a_VertexNormal;
	}
	gl_Position = u_PMatrix * v_Position;
	v_TextureCoord = a_TextureCoord;
	v_VertexNormal = a_VertexNormal;
}
`;

const _glslFragment = `
precision mediump float;
varying vec3 v_TransformedNormal;
varying vec4 v_Position;
varying vec2 v_TextureCoord;
varying vec3 v_VertexNormal;
uniform sampler2D u_Sampler;
uniform vec4 u_AmbientColor;
uniform float u_Emissive;
uniform float u_Diffuse;
uniform float u_Power;
uniform vec4 u_SpecularColor;
uniform vec4 u_Color;
uniform bool u_UseTexture;

void main(void)
{
	vec3 lightDirection = normalize(vec3(-1.0,-2.0,-4.0));
	vec3 normal = normalize(v_TransformedNormal);
	float diffuseLightWeighting = dot(normal,lightDirection);
	diffuseLightWeighting = 0.5+diffuseLightWeighting/2.0;
	vec3 reflect = normalize(2.0*diffuseLightWeighting*normal-lightDirection);
	float specular = pow(clamp(dot(reflect,lightDirection),0.0,1.0),u_Power);
	if ( u_UseTexture )
	{
		vec4 textureColor = texture2D(u_Sampler,vec2(v_TextureCoord.s,v_TextureCoord.t));
		vec4 colorTex = u_AmbientColor+textureColor*u_Color*(u_Emissive+u_Diffuse*clamp(diffuseLightWeighting,0.0,1.0))+u_SpecularColor*specular;
		gl_FragColor = vec4(colorTex.rgb,textureColor.a*u_Color.a);
	}
	else
	{
		vec4 normalMap = vec4(vec3(v_VertexNormal+vec3(1.0,1.0,1.0))/2.0,1.0);
		vec4 color = u_AmbientColor+normalMap*(u_Emissive+u_Diffuse*clamp(diffuseLightWeighting,0.0,1.0))+u_SpecularColor*specular;
		gl_FragColor = vec4(color.rgb,u_Color.a);
	}
}
`;
