﻿var Sprite2D = function(width,height,u,v,uWidth,vHeight,texture)
{
	this._vertices = [];
	this._uvs = [];
	this._material = 0;
	this._vertexPositionBuffer = null;
	this._textureCoordBuffer = null;
	this._visible = true;
	this._pos = new Vector3D(0,0,0);
	this._material = new Material(1,1,1,1,1,1,1,1,1,initTexture(texture));
	this.initBuffers(width,height);
	this.initUVs(u,v,uWidth,vHeight);
};

Sprite2D.prototype =
{
	setVertex : function(x,y)
	{
		this._vertices.push(x,y,0);
	},
	getVerticesLength : function()
	{
		return ~~(this._vertices.length/3);
	},
	initBuffers : function(width,height)
	{
		this._width = width;
		this._height = height;
		this._vertices = [];
		this.setVertex(0    ,height);
		this.setVertex(0    ,0     );
		this.setVertex(width,0     );
		this.setVertex(width,0     );
		this.setVertex(width,height);
		this.setVertex(0    ,height);
		this._vertexPositionBuffer = _gl.createBuffer();
		_gl.bindBuffer(_gl.ARRAY_BUFFER, this._vertexPositionBuffer);
		_gl.bufferData(_gl.ARRAY_BUFFER, new Float32Array(this._vertices), _gl.STATIC_DRAW);
		this._vertexPositionBuffer.itemSize = 3;
		this._vertexPositionBuffer.numItems = this.getVerticesLength();
	},
	initUVs : function(u,v,uWidth,vHeight)
	{
		this._u = u;
		this._v = v;
		this._uWidth = uWidth;
		this._vHeight = vHeight;
		this._uvs = [];
		this._uvs.push(u       ,v+vHeight);
		this._uvs.push(u       ,v);
		this._uvs.push(u+uWidth,v);
		this._uvs.push(u+uWidth,v);
		this._uvs.push(u+uWidth,v+vHeight);
		this._uvs.push(u       ,v+vHeight);
		this._textureCoordBuffer = _gl.createBuffer();
		_gl.bindBuffer(_gl.ARRAY_BUFFER, this._textureCoordBuffer);
		_gl.bufferData(_gl.ARRAY_BUFFER, new Float32Array(this._uvs), _gl.STATIC_DRAW);
		this._textureCoordBuffer.itemSize = 2;
		this._textureCoordBuffer.numItems = this.getVerticesLength();
	},
	draw : function()
	{
		if ( !this._visible )
		{
			return;
		}
		mvPushMatrix();

		_mvMatrix.identity();
		_mvMatrix.translate(this._pos);

		_gl.bindBuffer(_gl.ARRAY_BUFFER, this._vertexPositionBuffer);
		_gl.vertexAttribPointer(_shaderProgram.a_vertexPosition, this._vertexPositionBuffer.itemSize, _gl.FLOAT, false, 0, 0);

		_gl.bindBuffer(_gl.ARRAY_BUFFER, this._textureCoordBuffer);
		_gl.vertexAttribPointer(_shaderProgram.a_textureCoord, this._textureCoordBuffer.itemSize, _gl.FLOAT, false, 0, 0);

		this._material.setTexture();

		_gl.uniform1i(_shaderProgram.u_useTexture, true);
		_gl.uniform1i(_shaderProgram.u_useBone, false);
		_gl.uniform4f(_shaderProgram.u_color,this._material._r,this._material._g,this._material._b,this._material._a);
		_gl.uniform1f(_shaderProgram.u_diffuse,1);
		_gl.uniform1f(_shaderProgram.u_emissive,1);
		_gl.uniform4f(_shaderProgram.u_ambientColor,0,0,0,1);
		_gl.uniform1f(_shaderProgram.u_power,1);
		_gl.uniform4f(_shaderProgram.u_specularColor,0,0,0,1);

		_gl.enableVertexAttribArray(_shaderProgram.a_textureCoord);
		_gl.disableVertexAttribArray(_shaderProgram.a_bone);
		_gl.disableVertexAttribArray(_shaderProgram.a_weight);
		_gl.disableVertexAttribArray(_shaderProgram.a_vertexNormal);

		var pMatrix = new Matrix3D();
		pMatrix.ortho(0,_gl.viewportWidth,_gl.viewportHeight,0,10000,-10000);
		setMatrixUniforms(pMatrix._e);

		_gl.drawArrays(_gl.TRIANGLES, 0, this.getVerticesLength());

		mvPopMatrix();
	},
	getPos : function()
	{
		return new Vector3D(this._pos.x,this._pos.y,this._pos.z);
	},
	mouseClick : function(x,y)
	{
		if ( x >= this._pos.x && x < this._pos.x+this._width && y >= this._pos.y && y < this._pos.y+this._height )
		{
			return true;
		}
		return false;
	}
};
