class BoneModel3D extends Model3D {
  constructor() {
    super();
    this.matrices = [];
    this.matrices2 = [];
    this.matrices3 = [];
    this.currentAnimation = 0;
    this.animationFrame = 0.0;
    this.loopAnimation = true;
    this.playing = true;
  }
  setB(x,y,z,nx,ny,nz,material,u,v,bone,parent,weight) {
    this.preVertices.push(x,y,z,nx,ny,nz,material,u,v,bone);
  }
  setBI(i0,i1,i2) {
    var indices = [];
    indices.push(i0,i1,i2);
    for ( let i = 0; i < indices.length; i++ ) {
      const  j = indices[i];
      const  x = this.preVertices[j*10  ];
      const  y = this.preVertices[j*10+1];
      const  z = this.preVertices[j*10+2];
      const nx = this.preVertices[j*10+3];
      const ny = this.preVertices[j*10+4];
      const nz = this.preVertices[j*10+5];
      const  m = this.preVertices[j*10+6];
      const  r = this.materials[m].r;
      const  g = this.materials[m].g;
      const  b = this.materials[m].b;
      const  a = this.materials[m].a;
      const  s = this.materials[m].spc;
      const  u = this.preVertices[j*10+7];
      const  v = this.preVertices[j*10+8];
      const bn = this.preVertices[j*10+9];
      this.vertices.push(x,y,z,1,nx,ny,nz,r,g,b,a,s,u,v,bn);
    }
  }
  setMatrix(matrix) {
    this.matrices.push(matrix);
  }
  setMatrix2() {
    let array = new Float32Array(this.matrices.length*16);
    for (let i = 0; i < this.matrices.length; i++ )
      for (let j = 0; j < 16; j++ )
        array[i*16+j] = this.matrices[i][j];
    this.matrices2.push(array);
    this.matrices = [];
  }
  setMatrix3(materials) {
    this.matrices3.push(this.matrices2);
    this.matrices2 = [];
  }
  initBuffers() {
    this.vertexArray = new Float32Array(this.vertices);
    // Create a vertex buffer from the quad data.
    this.verticesBuffer = _device.createBuffer({
      size: this.vertexArray.byteLength,
      usage: GPUBufferUsage.VERTEX,
      mappedAtCreation: true,
    });
    new Float32Array(this.verticesBuffer.getMappedRange()).set(this.vertexArray);
    this.verticesBuffer.unmap();
    if ( this.materials[0].texture ) this.initTexture();
    else this.init();
  }
  async init() {
    this.uniformBindGroup = _device.createBindGroup({
      layout: _pipelineBone.getBindGroupLayout(0),
      entries: [
        {
          binding: 0,
          resource: {
            buffer: _uniformBuffer,
            offset: OFFSET_SIZE*this.num,
            size: uniformBufferSize,
          },
        },
      ],
    });
  }
  async initTexture() {
    let imageTexture = await loadTexture(this.materials[0].texture);
    // Create a sampler with linear filtering for smooth interpolation.
    const sampler = _device.createSampler({
      magFilter: 'linear',
      minFilter: 'linear',
    });
    this.uniformBindGroup = _device.createBindGroup({
      layout: _pipelineBoneTexture.getBindGroupLayout(0),
      entries: [
        {
          binding: 0,
          resource: {
            buffer: _uniformBuffer,
            offset: OFFSET_SIZE*this.num,
            size: uniformBufferSize,
          },
        },{
          binding: 1,
          resource: sampler,
        },{
          binding: 2,
          resource: imageTexture.createView(),
        },
      ],
    });
  }
  draw(passEncoder) {
    if (this.uniformBindGroup) {
      if ( this.materials[0].texture ) passEncoder.setPipeline(_pipelineBoneTexture);
      else passEncoder.setPipeline(_pipelineBone);
      this.setTransform();
      this.setAnimation();
      passEncoder.setBindGroup(0,this.uniformBindGroup);
      passEncoder.setVertexBuffer(0,this.verticesBuffer);
      passEncoder.draw(this.getVertexCount());
    }
  }
  setAnimation() {
    if ( this.playing ) this.animationFrame += _elapsed*30;
    const length = this.matrices3[this.currentAnimation].length;
    if ( this.animationFrame >= length ) {
      if ( this.loopAnimation ) {
        this.animationFrame = 0;
      } else {
        this.animationFrame = length - 1;
        this.playing = false;
      }
    }
    _device.queue.writeBuffer(
      _uniformBuffer,
      4 * 16 * 4 + OFFSET_SIZE*this.num,
      this.matrices3[this.currentAnimation][~~this.animationFrame].buffer,
      0,
      4 * this.matrices3[0][0].length
    );
  }
  playAnimation(current,loop) {
    this.currentAnimation = current;
    this.animationFrame = 0;
    this.loopAnimation = loop;
    this.playing = true;
  }
}