﻿class Matrix3D {
  constructor(e) {
    this.e = new Float32Array([
      1,0,0,0,
      0,1,0,0,
      0,0,1,0,
      0,0,0,1]);
  }
  identity() {
    this.e = new Float32Array([
      1,0,0,0,
      0,1,0,0,
      0,0,1,0,
      0,0,0,1]);
  }
  translate(v) {
    var a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;
    a00 = this.e[0]; a01 = this.e[1]; a02 = this.e[ 2]; a03 = this.e[ 3];
    a10 = this.e[4]; a11 = this.e[5]; a12 = this.e[ 6]; a13 = this.e[ 7];
    a20 = this.e[8]; a21 = this.e[9]; a22 = this.e[10]; a23 = this.e[11];
    this.e[0] = a00; this.e[1] = a01; this.e[ 2] = a02; this.e[ 3] = a03;
    this.e[4] = a10; this.e[5] = a11; this.e[ 6] = a12; this.e[ 7] = a13;
    this.e[8] = a20; this.e[9] = a21; this.e[10] = a22; this.e[11] = a23;
    this.e[12] = a00 * v.x + a10 * v.y + a20 * v.z + this.e[12];
    this.e[13] = a01 * v.x + a11 * v.y + a21 * v.z + this.e[13];
    this.e[14] = a02 * v.x + a12 * v.y + a22 * v.z + this.e[14];
    this.e[15] = a03 * v.x + a13 * v.y + a23 * v.z + this.e[15];
  }
  rotateX(angle) {
    var s = Math.sin(angle);
    var c = Math.cos(angle);
    var a10 = this.e[4];
    var a11 = this.e[5];
    var a12 = this.e[6];
    var a13 = this.e[7];
    var a20 = this.e[8];
    var a21 = this.e[9];
    var a22 = this.e[10];
    var a23 = this.e[11];
    this.e[4] = a10 * c + a20 * s;
    this.e[5] = a11 * c + a21 * s;
    this.e[6] = a12 * c + a22 * s;
    this.e[7] = a13 * c + a23 * s;
    this.e[8] = a10 * -s + a20 * c;
    this.e[9] = a11 * -s + a21 * c;
    this.e[10] = a12 * -s + a22 * c;
    this.e[11] = a13 * -s + a23 * c;
  }
  rotateY(angle) {
    var s = Math.sin(angle);
    var c = Math.cos(angle);
    var a00 = this.e[0];
    var a01 = this.e[1];
    var a02 = this.e[2];
    var a03 = this.e[3];
    var a20 = this.e[8];
    var a21 = this.e[9];
    var a22 = this.e[10];
    var a23 = this.e[11];
    this.e[0] = a00 * c + a20 * -s;
    this.e[1] = a01 * c + a21 * -s;
    this.e[2] = a02 * c + a22 * -s;
    this.e[3] = a03 * c + a23 * -s;
    this.e[8] = a00 * s + a20 * c;
    this.e[9] = a01 * s + a21 * c;
    this.e[10] = a02 * s + a22 * c;
    this.e[11] = a03 * s + a23 * c;
  }
  rotateZ(angle) {
    var s = Math.sin(angle);
    var c = Math.cos(angle);
    var a00 = this.e[0];
    var a01 = this.e[1];
    var a02 = this.e[2];
    var a03 = this.e[3];
    var a10 = this.e[4];
    var a11 = this.e[5];
    var a12 = this.e[6];
    var a13 = this.e[7];
    this.e[0] = a00 * c + a10 * s;
    this.e[1] = a01 * c + a11 * s;
    this.e[2] = a02 * c + a12 * s;
    this.e[3] = a03 * c + a13 * s;
    this.e[4] = a00 * -s + a10 * c;
    this.e[5] = a01 * -s + a11 * c;
    this.e[6] = a02 * -s + a12 * c;
    this.e[7] = a03 * -s + a13 * c;
  }
  scale(v) {
    this.e[ 0] *= v.x;
    this.e[ 1] *= v.x;
    this.e[ 2] *= v.x;
    this.e[ 3] *= v.x;
    this.e[ 4] *= v.y;
    this.e[ 5] *= v.y;
    this.e[ 6] *= v.y;
    this.e[ 7] *= v.y;
    this.e[ 8] *= v.z;
    this.e[ 9] *= v.z;
    this.e[10] *= v.z;
    this.e[11] *= v.z;
  }
  transform(v) {
        var x = v.x * this.e[0] + v.y * this.e[4] + v.z * this.e[8]  + v.w * this.e[12];
        var y = v.x * this.e[1] + v.y * this.e[5] + v.z * this.e[9]  + v.w * this.e[13];
        var z = v.x * this.e[2] + v.y * this.e[6] + v.z * this.e[10] + v.w * this.e[14];
        var w = v.x * this.e[3] + v.y * this.e[7] + v.z * this.e[11] + v.w * this.e[15];
        return new Vector4D(x,y,z,w);
  }
  static multiply(a,b) {
    const matrix = new Matrix3D();
    matrix.e[ 0] = a.e[ 0]*b.e[0] + a.e[ 1]*b.e[4] + a.e[ 2]*b.e[ 8] + a.e[ 3]*b.e[12];
    matrix.e[ 1] = a.e[ 0]*b.e[1] + a.e[ 1]*b.e[5] + a.e[ 2]*b.e[ 9] + a.e[ 3]*b.e[13];
    matrix.e[ 2] = a.e[ 0]*b.e[2] + a.e[ 1]*b.e[6] + a.e[ 2]*b.e[10] + a.e[ 3]*b.e[14];
    matrix.e[ 3] = a.e[ 0]*b.e[3] + a.e[ 1]*b.e[7] + a.e[ 2]*b.e[11] + a.e[ 3]*b.e[15];
    matrix.e[ 4] = a.e[ 4]*b.e[0] + a.e[ 5]*b.e[4] + a.e[ 6]*b.e[ 8] + a.e[ 7]*b.e[12];
    matrix.e[ 5] = a.e[ 4]*b.e[1] + a.e[ 5]*b.e[5] + a.e[ 6]*b.e[ 9] + a.e[ 7]*b.e[13];
    matrix.e[ 6] = a.e[ 4]*b.e[2] + a.e[ 5]*b.e[6] + a.e[ 6]*b.e[10] + a.e[ 7]*b.e[14];
    matrix.e[ 7] = a.e[ 4]*b.e[3] + a.e[ 5]*b.e[7] + a.e[ 6]*b.e[11] + a.e[ 7]*b.e[15];
    matrix.e[ 8] = a.e[ 8]*b.e[0] + a.e[ 9]*b.e[4] + a.e[10]*b.e[ 8] + a.e[11]*b.e[12];
    matrix.e[ 9] = a.e[ 8]*b.e[1] + a.e[ 9]*b.e[5] + a.e[10]*b.e[ 9] + a.e[11]*b.e[13];
    matrix.e[10] = a.e[ 8]*b.e[2] + a.e[ 9]*b.e[6] + a.e[10]*b.e[10] + a.e[11]*b.e[14];
    matrix.e[11] = a.e[ 8]*b.e[3] + a.e[ 9]*b.e[7] + a.e[10]*b.e[11] + a.e[11]*b.e[15];
    matrix.e[12] = a.e[12]*b.e[0] + a.e[13]*b.e[4] + a.e[14]*b.e[ 8] + a.e[15]*b.e[12];
    matrix.e[13] = a.e[12]*b.e[1] + a.e[13]*b.e[5] + a.e[14]*b.e[ 9] + a.e[15]*b.e[13];
    matrix.e[14] = a.e[12]*b.e[2] + a.e[13]*b.e[6] + a.e[14]*b.e[10] + a.e[15]*b.e[14];
    matrix.e[15] = a.e[12]*b.e[3] + a.e[13]*b.e[7] + a.e[14]*b.e[11] + a.e[15]*b.e[15];
    return matrix;
  }
  perspective(fov, aspect, near, far) {
    let top = near * Math.tan(fov * Math.PI / 360.0);
    let bottom = -top;
    let right = top * aspect;
    let left = -right;
    let rl = (right - left);
    let tb = (top - bottom);
    let fn = (far - near);
    this.e[ 0] = (near * 2) / rl;
    this.e[ 1] = 0;
    this.e[ 2] = 0;
    this.e[ 3] = 0;
    this.e[ 4] = 0;
    this.e[ 5] = (near * 2) / tb;
    this.e[ 6] = 0;
    this.e[ 7] = 0;
    this.e[ 8] = (right + left) / rl;
    this.e[ 9] = (top + bottom) / tb;
    this.e[10] = -(far + near) / fn;
    this.e[11] = -1;
    this.e[12] = 0;
    this.e[13] = 0;
    this.e[14] = -(far * near * 2) / fn;
    this.e[15] = 0;
  }
  static inverse(mat) {
    var matrix = new Matrix3D();
		var a = mat.e[0],  b = mat.e[1],  c = mat.e[2],  d = mat.e[3],
			e = mat.e[4],  f = mat.e[5],  g = mat.e[6],  h = mat.e[7],
			i = mat.e[8],  j = mat.e[9],  k = mat.e[10], l = mat.e[11],
			m = mat.e[12], n = mat.e[13], o = mat.e[14], p = mat.e[15],
			q = a * f - b * e, r = a * g - c * e,
			s = a * h - d * e, t = b * g - c * f,
			u = b * h - d * f, v = c * h - d * g,
			w = i * n - j * m, x = i * o - k * m,
			y = i * p - l * m, z = j * o - k * n,
			A = j * p - l * n, B = k * p - l * o,
			ivd = 1 / (q * B - r * A + s * z + t * y - u * x + v * w);
		matrix.e[ 0] = ( f * B - g * A + h * z) * ivd;
		matrix.e[ 1] = (-b * B + c * A - d * z) * ivd;
		matrix.e[ 2] = ( n * v - o * u + p * t) * ivd;
		matrix.e[ 3] = (-j * v + k * u - l * t) * ivd;
		matrix.e[ 4] = (-e * B + g * y - h * x) * ivd;
		matrix.e[ 5] = ( a * B - c * y + d * x) * ivd;
		matrix.e[ 6] = (-m * v + o * s - p * r) * ivd;
		matrix.e[ 7] = ( i * v - k * s + l * r) * ivd;
		matrix.e[ 8] = ( e * A - f * y + h * w) * ivd;
		matrix.e[ 9] = (-a * A + b * y - d * w) * ivd;
		matrix.e[10] = ( m * u - n * s + p * q) * ivd;
		matrix.e[11] = (-i * u + j * s - l * q) * ivd;
		matrix.e[12] = (-e * z + f * x - g * w) * ivd;
		matrix.e[13] = ( a * z - b * x + c * w) * ivd;
		matrix.e[14] = (-m * t + n * r - o * q) * ivd;
		matrix.e[15] = ( i * t - j * r + k * q) * ivd;
    return matrix;
	}
  transpose() {
		var mat = new Matrix3D();
		mat.e[ 0] = this.e[ 0];
		mat.e[ 1] = this.e[ 4];
		mat.e[ 2] = this.e[ 8];
		mat.e[ 3] = this.e[12];
		mat.e[ 4] = this.e[ 1];
		mat.e[ 5] = this.e[ 5];
		mat.e[ 6] = this.e[ 9];
		mat.e[ 7] = this.e[13];
		mat.e[ 8] = this.e[ 2];
		mat.e[ 9] = this.e[ 6];
		mat.e[10] = this.e[10];
		mat.e[11] = this.e[14];
		mat.e[12] = this.e[ 3];
		mat.e[13] = this.e[ 7];
		mat.e[14] = this.e[11];
		mat.e[15] = this.e[15];
		return mat;
	}
  lookAt(eye, at, up) {
		var z2 = eye.subtract(at);
		z2.normalize();
		var x2 = up.crossProduct(z2);
		x2.normalize();
		var y2 = z2.crossProduct(x2);
		this.e[ 0] = x2.x;
    this.e[ 1] = y2.x;
    this.e[ 2] = z2.x;
    this.e[ 3] = 0;
		this.e[ 4] = x2.y;
    this.e[ 5] = y2.y;
    this.e[ 6] = z2.y;
    this.e[ 7] = 0;
		this.e[ 8] = x2.z;
    this.e[ 9] = y2.z;
    this.e[10] = z2.z;
    this.e[11] = 0;
		this.e[12] = -x2.dotProduct(eye);
		this.e[13] = -y2.dotProduct(eye);
		this.e[14] = -z2.dotProduct(eye);
		this.e[15] = 1;
	}
}
