class Model3D {
  constructor() {
    this.materials = [];
    this.preVertices = [];
    this.vertices = [];
    this.indices = [];
    this.pos = new Vector3D(0,0,0);
    this.rotate = new Vector3D(0,0,0);
    this.scale = new Vector3D(1,1,1);
    this.num = _num;
    _num++;
  }
  setMaterial(r,g,b,a,dif,amb,emi,spc,power,texture) {
		this.materials.push(new Material(r,g,b,a,dif,amb,emi,spc,power,texture));
	}
  setV(x,y,z,nx=0,ny=0,nz=1,material=0,u=0,v=0) {
    this.preVertices.push(x,y,z,nx,ny,nz,material,u,v);
  }
  setI(i0,i1,i2) {
    var indices = [];
    indices.push(i0,i1,i2);
    for ( let i = 0; i < indices.length; i++ ) {
      const  j = indices[i];
      const  x = this.preVertices[j*9  ];
      const  y = this.preVertices[j*9+1];
      const  z = this.preVertices[j*9+2];
      const nx = this.preVertices[j*9+3];
      const ny = this.preVertices[j*9+4];
      const nz = this.preVertices[j*9+5];
      const  m = this.preVertices[j*9+6];
      const  r = this.materials[m].r;
      const  g = this.materials[m].g;
      const  b = this.materials[m].b;
      const  a = this.materials[m].a;
      const  s = this.materials[m].spc;
      const  u = this.preVertices[j*9+7];
      const  v = this.preVertices[j*9+8];
      const bn = 0;
      this.vertices.push(x,y,z,1,nx,ny,nz,r,g,b,a,s,u,v,bn);
    }
  }
  initBuffers() {
    this.vertexArray = new Float32Array(this.vertices);
    // Create a vertex buffer from the quad data.
    this.verticesBuffer = _device.createBuffer({
      size: this.vertexArray.byteLength,
      usage: GPUBufferUsage.VERTEX,
      mappedAtCreation: true,
    });
    new Float32Array(this.verticesBuffer.getMappedRange()).set(this.vertexArray);
    this.verticesBuffer.unmap();
    if ( this.materials[0].texture ) this.initTexture();
    else this.init();
  }
  async init() {
    this.uniformBindGroup = _device.createBindGroup({
      layout: _pipeline.getBindGroupLayout(0),
      entries: [
        {
          binding: 0,
          resource: {
            buffer: _uniformBuffer,
            offset: OFFSET_SIZE*this.num,
            size: uniformBufferSize,
          },
        },
      ],
    });
  }
  async initTexture() {
    let imageTexture = await loadTexture(this.materials[0].texture);
    // Create a sampler with linear filtering for smooth interpolation.
    const sampler = _device.createSampler({
      magFilter: 'linear',
      minFilter: 'linear',
    });
    this.uniformBindGroup = _device.createBindGroup({
      layout: _pipelineTexture.getBindGroupLayout(0),
      entries: [
        {
          binding: 0,
          resource: {
            buffer: _uniformBuffer,
            offset: OFFSET_SIZE*this.num,
            size: uniformBufferSize,
          },
        },{
          binding: 1,
          resource: sampler,
        },{
          binding: 2,
          resource: imageTexture.createView(),
        },
      ],
    });
  }
  getVertexCount() {
    return ~~(this.vertexArray.length/15);
  }
  draw(passEncoder) {
    if (this.uniformBindGroup) {
      if ( this.materials[0].texture ) passEncoder.setPipeline(_pipelineTexture);
      else passEncoder.setPipeline(_pipeline);
      this.setTransform();
      passEncoder.setBindGroup(0,this.uniformBindGroup);
      passEncoder.setVertexBuffer(0,this.verticesBuffer);
      passEncoder.draw(this.getVertexCount());
    }
  }
  setTransform() {
    const projectionMatrix = this.getProjectionMatrix();
    _device.queue.writeBuffer(
      _uniformBuffer,
      4 * 16 * 0 + OFFSET_SIZE*this.num,
      projectionMatrix.e.buffer,
      0,
      4 * 16
    );
    _device.queue.writeBuffer(
      _uniformBuffer,
      4 * 16 * 1 + OFFSET_SIZE*this.num,
      _camera.e.buffer,
      0,
      4 * 16
    );
    const worldMatrix = this.getWorldMatrix();
    _device.queue.writeBuffer(
      _uniformBuffer,
      4 * 16 * 2 + OFFSET_SIZE*this.num,
      worldMatrix.e.buffer,
      0,
      4 * 16
    );
    let wvMatrix = this.getWorldViewMatrix();
    let normalMatrix = Matrix3D.inverse(wvMatrix);
    normalMatrix = normalMatrix.transpose();
    _device.queue.writeBuffer(
      _uniformBuffer,
      4 * 16 * 3 + OFFSET_SIZE*this.num,
      normalMatrix.e.buffer,
      0,
      4 * 16
    );

  }
  getProjectionMatrix() {
    const projectionMatrix = new Matrix3D();
    const aspect = _canvas.width/_canvas.height;
    projectionMatrix.perspective(_fov, aspect, 1, 100000.0);
    return projectionMatrix;
  }
  getWorldMatrix() {
    const worldMatrix = new Matrix3D();
    worldMatrix.translate(this.pos);
    worldMatrix.rotateX(degree2radian(this.rotate.x));
    worldMatrix.rotateY(degree2radian(this.rotate.y));
    worldMatrix.rotateZ(degree2radian(this.rotate.z));
    worldMatrix.scale(this.scale);
    return worldMatrix;
  }
  getWorldViewMatrix() {
    const worldMatrix = this.getWorldMatrix();
    return Matrix3D.multiply(_camera,worldMatrix);
  }
  addRotateX(delta) {
    this.rotate.addX(delta * _elapsed);
  }
  addRotateY(delta) {
    this.rotate.addY(delta * _elapsed);
  }
  addRotateZ(delta) {
    this.rotate.addZ(delta * _elapsed);
  }
}