﻿class Vector2D {
  constructor(x,y) {
    this.x = x;
    this.y = y;
  }
}

class Vector4D {
  constructor(x,y,z,w) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.w = w;
  }
}

class Vector3D {
  constructor(x,y,z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }
  length() {
    return Math.sqrt(this.x*this.x + this.y*this.y + this.z*this.z);
  }
  add(v) {
    const x = this.x + v.x;
    const y = this.y + v.y;
    const z = this.z + v.z;
    return new Vector3D(x,y,z);
  }
  subtract(v) {
    const x = this.x - v.x;
    const y = this.y - v.y;
    const z = this.z - v.z;
    return new Vector3D(x,y,z);
  }
  mul(v) {
    const x = this.x * v;
    const y = this.y * v;
    const z = this.z * v;
    return new Vector3D(x,y,z);
  }
  normalize() {
    var l = this.length();
    if ( l == 0 ) {
      this.x = 0;
      this.y = 0;
      this.z = 1;
    } else {
      this.x /= l;
      this.y /= l;
      this.z /= l;
    }
  }
  dotProduct(v) {
    return (v.x * this.x + v.y * this.y + v.z * this.z);
  }
  crossProduct(v) {
    const x = (this.y*v.z) - (this.z*v.y);
    const y = (this.z*v.x) - (this.x*v.z);
    const z = (this.x*v.y) - (this.y*v.x);
    return new Vector3D(x,y,z);
  }
  addX(delta) {
		this.x += delta;
		if ( this.x < 0 ) this.x += 360;
		if ( this.x >= 360 ) this.x -= 360;
	}
	addY(delta) {
		this.y += delta;
		if ( this.y < 0 ) this.y += 360;
		if ( this.y >= 360 ) this.y -= 360;
	}
	addZ(delta) {
		this.z += delta;
		if ( this.z < 0 ) this.z += 360;
		if ( this.z >= 360 ) this.z -= 360;
	}
}
