Texture2D g_texDecal: register(t0);
SamplerState g_samLinear : register(s0);

cbuffer global
{
	matrix g_mWorld;
	matrix g_mWVP;
	matrix g_mBone[36];
	float4 g_vLightDir;
	float4 g_vViewDir;
	float4 g_vColor;
	float4 g_vAmbient;
	float4 g_vSpecular;
	float4 g_vDiffuse;
	float4 g_vEmissive;
	float4 g_vPower;
};

struct VS_OUTPUT
{
	float4 m_Pos    : SV_POSITION;
	float3 m_Normal : TEXCOORD0;
    float2 m_Tex    : TEXCOORD1;
	float  m_Bone   : TEXCOORD2;
};

VS_OUTPUT VS( float4 Pos : POSITION ,float3 Normal : NORMAL, float2 Tex : TEXCOORD, float Bone : BONE)
{
	VS_OUTPUT output = (VS_OUTPUT)0;
	
	if ( (int)(Bone) >= 0 )
	{
		matrix mat = mul(g_mBone[(int)(Bone)],g_mWVP);
		output.m_Pos = mul(Pos,mat);
		matrix mat2 = mul(g_mBone[(int)(Bone)],g_mWorld);
		output.m_Normal = mul(Normal,(float3x3)mat2);
	}
	else
	{
		output.m_Pos = mul(Pos,g_mWVP);
		output.m_Normal = mul(Normal,(float3x3)g_mWorld);
	}

	output.m_Tex = Tex;

	return output;
}

float4 PS( VS_OUTPUT input ) : SV_Target
{
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float3 Reflect = (float3)normalize(2 * dif_coef * Normal - (float3)g_vLightDir);
	float spc_coef = pow(saturate(dot(Reflect, (float3)g_vViewDir)), g_vPower.x);

	float4 col = g_vAmbient + g_vColor * (g_vEmissive.x + g_vDiffuse.x * saturate(dif_coef)) + g_vSpecular * spc_coef;
	col.a = g_vColor.a;

	return saturate(col);
}

float4 PS_MONO( VS_OUTPUT input ) : SV_Target
{
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float mono = max(max(g_vColor.r,g_vColor.g),g_vColor.b);
	mono = round(mono * saturate(dif_coef));
	float4 col = float4(mono,mono,mono,g_vColor.a);

	return saturate(col);
}

float4 PS_TOON( VS_OUTPUT input ) : SV_Target
{
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float toon = g_vDiffuse.x * saturate(dif_coef);
	toon = round(toon*9.0f/3.0f)*3.0f/9.0f;
	float4 col = g_vColor * toon;
	col.a = g_vColor.a;

	return saturate(col);
}

float4 PS_TEX( VS_OUTPUT input ) : SV_Target
{
	float4 tex_col = g_texDecal.Sample( g_samLinear, input.m_Tex );
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float3 Reflect = (float3)normalize(2 * dif_coef * Normal - (float3)g_vLightDir);
	float spc_coef = pow(saturate(dot(Reflect, (float3)g_vViewDir)), g_vPower.x);

	float4 col = g_vAmbient + tex_col * g_vColor * (g_vEmissive.x + g_vDiffuse.x * saturate(dif_coef)) + g_vSpecular * spc_coef;
	col.a = tex_col.a * g_vColor.a;

	return saturate(col);
}

float4 PS_MONO_TEX( VS_OUTPUT input ) : SV_Target
{
	float4 tex_col = g_texDecal.Sample( g_samLinear, input.m_Tex );
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float mono = max(max(tex_col.r,tex_col.g),tex_col.b);
	mono = round(mono * saturate(dif_coef));
	float4 col = float4(mono,mono,mono,tex_col.a*g_vColor.a);

	return saturate(col);
}

float4 PS_TOON_TEX( VS_OUTPUT input ) : SV_Target
{
	float4 tex_col = g_texDecal.Sample( g_samLinear, input.m_Tex );
	float3 Normal = normalize(input.m_Normal);
	float dif_coef = dot(Normal, (float3)g_vLightDir);
	float toon = round(saturate(dif_coef)*9.0f/3.0f)*3.0f/9.0f;
	float4 col = tex_col * g_vColor * toon;
	col.a = tex_col.a * g_vColor.a;

	return saturate(col);
}
