doc = MQSystem.getDocument()
scene = doc.getScene(0)

dlg = MQWidget.SaveFileDialog(MQWidget.getMainWindow())
dlg.addFilter("Camera file (*.camera)|*.camera")
dlg.defaultExt = "camera"
dlg.filterIndex = 0
if dlg.execute():
	with open(dlg.filename, 'w') as file:
		p = scene.getCameraPos()
		pos = "pos {0} {1} {2}\n".format(p.x,p.y,p.z)
		file.write(pos)
		a = scene.getCameraAngle()
		angle = "angle {0} {1} {2}\n".format(a.head,a.pitch,a.bank)
		file.write(angle)
		l = scene.getLookAtPos()
		at = "at {0} {1} {2}\n".format(l.x,l.y,l.z)
		file.write(at)
		c = scene.getRotationCenter()
		center = "center {0} {1} {2}\n".format(c.x,c.y,c.z)
		file.write(center)
		fov = "fov {0}\n".format(scene.fov)
		file.write(fov)
		g = scene.globalDirectionalLight
		light = "light {0} {1} {2}\n".format(g.x,g.y,g.z)
		file.write(light)
