import colorsys

doc = MQSystem.getDocument()

def makeBox(obj,size,x,y,z,color):

	size /= 2.0
	v0 = obj.addVertex(x-size,y-size,z+size)
	v1 = obj.addVertex(x+size,y-size,z+size)
	v2 = obj.addVertex(x+size,y+size,z+size)
	v3 = obj.addVertex(x-size,y+size,z+size)
	v4 = obj.addVertex(x-size,y-size,z-size)
	v5 = obj.addVertex(x-size,y+size,z-size)
	v6 = obj.addVertex(x+size,y+size,z-size)
	v7 = obj.addVertex(x+size,y-size,z-size)
	
	face = []
	face.append(obj.addFace([v0,v3,v2,v1]))
	face.append(obj.addFace([v1,v2,v6,v7]))
	face.append(obj.addFace([v4,v7,v6,v5]))
	face.append(obj.addFace([v0,v4,v5,v3]))
	face.append(obj.addFace([v3,v5,v6,v2]))
	face.append(obj.addFace([v0,v1,v7,v4]))

	mat = MQSystem.newMaterial()
	mat.color.red   = float(color[0])
	mat.color.green = float(color[1])
	mat.color.blue  = float(color[2])
	mat.specular    = 0.2
	index = doc.addMaterial(mat)

	for f in face:
		obj.face[f].material = index
		
num = 5
obj = MQSystem.newObject()
for x in range(num):
	for z in range(num):
		h = float(x)/float(num)
		s = float(num-z)/float(num)
		v = 1.0
		tuple = colorsys.hsv_to_rgb(h,s,v)
		makeBox(obj,90,x*100,0,z*100,tuple)
doc.addObject(obj)