import random

doc = MQSystem.getDocument()

class Intersect():
	def __init__(self):
		self.distance = 0
		self.intersectU = 0
		self.intersectV = 0

	def triangles(self, obj, origin, dir):
		flg = False
		distance = 10000000
		if obj is None: return False
		numFace = obj.numFace
		for fi in range(0, numFace):
			face = obj.face[fi]
			numVertex = face.numVertex
			if numVertex >= 3:
				v0 = obj.vertex[face.index[0]]
				v1 = obj.vertex[face.index[1]]
				v2 = obj.vertex[face.index[2]]
				if self.intersect(origin,dir,v0,v1,v2):
					flg = True
					if distance > self.distance:
						distance = self.distance
			if numVertex >= 4:
				v0 = obj.vertex[face.index[2]]
				v1 = obj.vertex[face.index[3]]
				v2 = obj.vertex[face.index[0]]
				if self.intersect(origin,dir,v0,v1,v2):
					flg = True
					if distance > self.distance:
						distance = self.distance
		self.distance = distance
		return flg

	def intersect(self, origin, dir, v0, v1, v2):
		v0 = v0.getPos()
		v1 = v1.getPos()
		v2 = v2.getPos()
		e1 = v1-v0
		e2 = v2-v0
		pv = dir.crossProduct(e2)
		det = e1.dotProduct(pv)

		if det > (1e-3):
			tv =  origin-v0
			u = tv.dotProduct(pv)
			if u < 0.0 or u > det:
				return False
			qv = tv.crossProduct(e1)
			v = dir.dotProduct(qv)
			if v < 0.0 or u + v > det:
				return False
		elif det < -(1e-3):
			tv =  origin-v0
			u = tv.dotProduct(pv)
			if u > 0.0 or u < det:
				return False
			qv = tv.crossProduct(e1)
			v = dir.dotProduct(qv)
			if v > 0.0 or u + v < det:
				return False
		else:
			return False

		inv_det = 1.0 / det
		t = e2.dotProduct(qv)
		t *= inv_det
		u *= inv_det
		v *= inv_det
		self.distance = t
		self.intersectU = u
		self.intersectV = v
		return True

class ComboDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Duplicate Object"
		self.frame0 = self.createHorizontalFrame(self)
		self.label0 = MQWidget.Label(self.frame0)
		self.label0.text = "Source"
		self.combo0 = MQWidget.ComboBox(self.frame0)
		numObject = doc.numObject
		for i in range(numObject):
			obj = doc.object[i]
			if obj is None: continue
			self.combo0.addItem(obj.name)
		self.frame1 = self.createHorizontalFrame(self)
		self.label1 = MQWidget.Label(self.frame1)
		self.label1.text = "Destination"
		self.combo1 = MQWidget.ComboBox(self.frame1)
		numObject = doc.numObject
		for i in range(numObject):
			obj = doc.object[i]
			if obj is None: continue
			self.combo1.addItem(obj.name)
		self.frame2 = self.createHorizontalFrame(self)
		self.okbtn = MQWidget.Button(self.frame2)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame2)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1

def objectIndexByName(name):
	numObject = doc.numObject
	for i in range(numObject):
		obj = doc.object[i]
		if obj is None: continue
		if obj.name == name: return obj
	return None

dlg = ComboDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	name = dlg.combo0.getItem(dlg.combo0.currentIndex)
	obj0 = objectIndexByName(name)
	if obj0 is None:
		MQSystem.println("Error")
	else:
		minY = 1000000
		numVertex = obj0.numVertex
		for i in range(numVertex):
			p0 = obj0.vertex[i].getPos()
			if minY > p0.y:
				minY = p0.y

		intersect = Intersect()
		for j in range(20):
			x = random.randint(0,200)
			y = minY
			z = random.randint(0,200)
			origin = MQSystem.newPoint(x,y,z)
			dir = MQSystem.newPoint(0,-1,0)
			name = dlg.combo1.getItem(dlg.combo1.currentIndex)
			obj1 = objectIndexByName(name)
			if intersect.triangles(obj1,origin,dir):
				obj2 = obj0.clone()
				obj2.name = "duplicate"+str(j)
				index = doc.addObject(obj2)
				obj3 = doc.object[index]
				numVertex = obj3.numVertex
				for i in range(numVertex):
					p0 = obj3.vertex[i].getPos()
					p1 = dir * intersect.distance
					p0.x = origin.x + p0.x + p1.x
					p0.y = p0.y + p1.y
					p0.z = origin.z + p0.z + p1.z
					obj3.vertex[i].setPos(p0.x,p0.y,p0.z)
			else:
				MQSystem.println("False")