doc = MQSystem.getDocument()
Point = MQSystem.newPoint
class Intersect():
	def __init__(self):
		self.distance = 0
		self.intersectU = 0
		self.intersectV = 0
		
	def triangles(self,origin, dir):
		flg = False
		triangle = {'v0':Point(0,0,-100),
			'v1':Point(100,0,100),
			'v2':Point(-100,0,100)}
		v0 = triangle['v0']
		v1 = triangle['v1']
		v2 = triangle['v2']
		obj = MQSystem.newObject()
		doc.addObject(obj)
		v = []
		v.append(obj.addVertex(v0))
		v.append(obj.addVertex(v1))
		v.append(obj.addVertex(v2))
		obj.addFace(v)
		if self.intersect(origin,dir,v0,v1,v2):
			flg = True
		return flg
		
	def intersect(self, origin, dir, v0, v1, v2):
		e1 = v1 - v0
		e2 = v2 - v0
		pv = dir.crossProduct(e2)
		det = e1.dotProduct(pv)
		if det > (1e-3):
			tv =  origin - v0
			u = tv.dotProduct(pv)
			if u < 0.0 or u > det:
				return False
			qv = tv.crossProduct(e1)
			v = dir.dotProduct(qv)
			if v < 0.0 or u + v > det:
				return False
		elif det < -(1e-3):
			tv =  origin - v0
			u = tv.dotProduct(pv)
			if u > 0.0 or u < det:
				return False
			qv = tv.crossProduct(e1)
			v = dir.dotProduct(qv)
			if v > 0.0 or u + v < det:
				return False
		else:
			return False
		inv_det = 1.0 / det
		t = e2.dotProduct(qv)
		t *= inv_det
		u *= inv_det
		v *= inv_det
		self.distance = t
		self.intersectU = u
		self.intersectV = v
		return True

origin = MQSystem.newPoint(0,100,0)
dir = MQSystem.newPoint(0,-1,0)
intersect = Intersect()
if intersect.triangles(origin,dir):
	MQSystem.println(str(intersect.distance))
else:
	MQSystem.println("None")
