import math
import random

doc = MQSystem.getDocument()
rotation = 0
minHeight = 1
maxHeight = 1

class ComboDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Duplicate Object"
		self.frame0 = self.createHorizontalFrame(self)
		self.label0 = MQWidget.Label(self.frame0)
		self.label0.text = "Location"
		self.combo0 = MQWidget.ComboBox(self.frame0)
		numObject = doc.numObject
		for i in range(numObject):
			obj = doc.object[i]
			if obj is None: continue
			self.combo0.addItem(obj.name)
		self.frame1 = self.createHorizontalFrame(self)
		self.label1 = MQWidget.Label(self.frame1)
		self.label1.text = "Source"
		self.combo1 = MQWidget.ComboBox(self.frame1)
		numObject = doc.numObject
		for i in range(numObject):
			obj = doc.object[i]
			if obj is None: continue
			self.combo1.addItem(obj.name)
		self.frame2 = self.createHorizontalFrame(self)
		self.okbtn = MQWidget.Button(self.frame2)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame2)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1

def objectIndexByName(name):
	numObject = doc.numObject
	for i in range(numObject):
		obj = doc.object[i]
		if obj is None: continue
		if obj.name == name: return obj
	return None

dlg = ComboDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	name = dlg.combo0.getItem(dlg.combo0.currentIndex)
	obj0 = objectIndexByName(name)
	name = dlg.combo1.getItem(dlg.combo1.currentIndex)
	obj1 = objectIndexByName(name)
	numVertex0 = obj0.numVertex
	numVertex1 = obj1.numVertex
	for i0 in range(numVertex0):
		p0 = obj0.vertex[i0].getPos()
		obj2 = obj1.clone()
		angle = math.radians(random.randint(-rotation,rotation))
		sin0 = math.sin(angle)
		cos0 = math.cos(angle)
		height = random.uniform(minHeight,maxHeight)
		for i1 in range(numVertex1):
			p1 = obj1.vertex[i1].getPos()
			x = p1.x*cos0-p1.z*sin0
			z = p1.z*cos0+p1.x*sin0
			obj2.vertex[i1].setPos(p0.x+x,p0.y+p1.y*height,p0.z+z)
			obj2.name = "duplication"+str(i0)
		doc.addObject(obj2)
