doc = MQSystem.getDocument()
obj = MQSystem.newObject()
obj.name = "Graph"
doc.addObject(obj)

dlg = MQWidget.OpenFileDialog(MQWidget.getMainWindow())
dlg.addFilter("Wavefront file (*.obj)|*.obj")
if dlg.execute():
	with open(dlg.filename) as file:
		lines = file.read()

lines = lines.split('\n')
for line in lines:
	line = line.split(' ')
	if line[0].lower() == "v":
		x = float(line[1])
		y = float(line[2])
		z = float(line[3])
		obj.addVertex(x,y,z)
	elif line[0].lower() == "f":
		length = len(line)
		v = []
		for i in range(1,length):
			v.append(int(line[i])-1)
		obj.addFace(v)
