doc = MQSystem.getDocument()

dlg = MQWidget.SaveFileDialog(MQWidget.getMainWindow())
dlg.addFilter("Wavefront file (*.obj)|*.obj")
dlg.defaultExt = "obj"
dlg.filterIndex = 0
if dlg.execute():
	with open(dlg.filename, 'w') as file:
		num = doc.numObject
		for n in range(0,num):
			obj = doc.object[n]
			if obj is None: continue
			numVert = obj.numVertex
			for i in range(0,numVert):
				x = obj.vertex[i].pos.x
				y = obj.vertex[i].pos.y
				z = obj.vertex[i].pos.z
				v = "v {0} {1} {2}\n".format(x,y,z)
				file.write(v)
			numFace = obj.numFace
			for i in range(0,numFace):
				face = obj.face[i]
				vert_num = face.numVertex
				if vert_num == 0: continue
				f = "f"
				for j in range(vert_num):
					f = f + " " + str(face.index[j]+1)
				f = f + '\n'
				file.write(f)
