print = MQSystem.println
doc = MQSystem.getDocument()

class SelectDialog(MQWidget.Dialog):
	def listCallback(self, sender):
		objName = sender.getItem(sender.currentIndex)
		print("------------------------------------")
		print(objName)
		obj = self.getObjIndex(objName)
		min = self.minInfo(obj)
		max = self.maxInfo(obj)
		self.centerInfo(min,max)
		
	def minInfo(self,obj):
		x = 1000000.0
		y = 1000000.0
		z = 1000000.0
		for v in obj.vertex:
			p = v.getPos()
			if x > p.x: x = p.x
			if y > p.y: y = p.y
			if z > p.z: z = p.z
		if x < 1000000.0:
			print("min("+str(x)+","+str(y)+","+str(z)+")")
		return (x,y,z)

	def maxInfo(self,obj):
		x = -1000000.0
		y = -1000000.0
		z = -1000000.0
		for v in obj.vertex:
			p = v.getPos()
			if x < p.x: x = p.x
			if y < p.y: y = p.y
			if z < p.z: z = p.z
		if x > -1000000.0:
			print("max("+str(x)+","+str(y)+","+str(z)+")")
		return (x,y,z)

	def centerInfo(self,min,max):
		x = (min[0]+max[0])/2.0
		y = (min[1]+max[1])/2.0
		z = (min[2]+max[2])/2.0
		print("center("+str(x)+","+str(y)+","+str(z)+")")
		
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Object Info"
		self.frame0 = self.createHorizontalFrame(self)
		self.list0 = MQWidget.ListBox(self.frame0)
		self.list0.addChangedEvent(self.listCallback)
		numObj = doc.numObject
		for i in range(numObj):
			obj = doc.object[i]
			if obj is None: continue
			self.list0.addItem(obj.name)

	def getObjIndex(self, name):
		numObj = doc.numObject
		for i in range(numObj):
			obj = doc.object[i]
			if obj is None: continue
			if obj.name == name:
				return obj
				
dlg = SelectDialog(MQWidget.getMainWindow())
dlg.execute()
