import random

doc = MQSystem.getDocument()

class NumberDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "RandomVertex"
		self.frame1 = self.createHorizontalFrame(self)
		self.label = MQWidget.Label(self.frame1)
		self.label.text = "Random"
		self.spin = MQWidget.SpinBox(self.frame1)
		self.spin.min = 1
		self.spin.max = 100
		self.spin.position = 1
		self.frame2 = self.createHorizontalFrame(self)
		self.frame2.uniformSize = True
		self.okbtn = MQWidget.Button(self.frame2)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame2)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1
		
dlg = NumberDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	rnd = dlg.spin.position
	for oi in range(0,doc.numObject):
		obj = doc.object[oi]
		if obj is None: continue
		for vi in range(0, obj.numVertex):
			vert = obj.vertex[vi]
			if vert is None: continue
			if vert.select == 1:
				p = vert.getPos()
				x = p.x+random.uniform(-rnd,rnd)
				y = p.y+random.uniform(-rnd,rnd)
				z = p.z+random.uniform(-rnd,rnd)
				vert.setPos(x,y,z)