class NumberDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Select n-sided polygon"
		
		self.frame0 = self.createHorizontalFrame(self)
		self.frame0.uniformSize = True
		self.numSpin = MQWidget.SpinBox(self.frame0)
		self.numSpin.min = 3
		self.numSpin.position = 3
		self.frame4 = self.createHorizontalFrame(self)
		self.frame4.uniformSize = True
		self.okbtn = MQWidget.Button(self.frame4)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame4)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1
		
		
dlg = NumberDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	num = dlg.numSpin.position
	doc = MQSystem.getDocument()
	
	numObj = doc.numObject
	for oi in range(0,numObj):
		obj = doc.object[oi]
		if obj is None: continue
	
		numFace = obj.numFace
		
		for fi in range(0, numFace):
			if obj.face[fi].numVertex == num:
				obj.face[fi].select = 1
			else:
				obj.face[fi].select = 0
