#Select Faces Polygonal Number.

class NumberDialog(MQWidget.Dialog):
	def minCheckCallback(self,sender):
		if self.minCheck.checked :
			self.minSpin.enabled = True
		else:
			self.minSpin.enabled = False
		if self.maxSpin.position < self.minSpin.position:
			self.minSpin.position = self.maxSpin.position
	def maxCheckCallback(self,sender):
		if self.maxCheck.checked :
			self.maxSpin.enabled = True
		else:
			self.maxSpin.enabled = False
		if self.maxSpin.position < self.minSpin.position:
			self.maxSpin.position = self.minSpin.position
	def minSpinCallback(self,sender):
		if self.maxCheck.checked :
			if self.minSpin.position > self.maxSpin.position:
				self.minSpin.position = self.maxSpin.position
	def maxSpinCallback(self,sender):
		if self.minCheck.checked :
			if self.maxSpin.position < self.minSpin.position:
				self.maxSpin.position = self.minSpin.position
				
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Select n-sided polygon"

		self.frame2 = self.createVerticalFrame(self)
		self.frame2.uniformSize = True
		
		self.frame3_0 = self.createHorizontalFrame(self.frame2)
		self.frame3_0.uniformSize = True
		
		self.minCheck = MQWidget.CheckBox(self.frame3_0)
		self.minCheck.text = "Min"
		self.minCheck.checked = True
		self.minSpin = MQWidget.SpinBox(self.frame3_0)
		self.minSpin.min = 3
		self.minSpin.position = 3
		
		self.frame3_1 = self.createHorizontalFrame(self.frame2)
		self.frame3_1.uniformSize = True
		
		self.maxCheck = MQWidget.CheckBox(self.frame3_1)
		self.maxCheck.text = "Max"
		self.maxCheck.checked = True
		self.maxSpin = MQWidget.SpinBox(self.frame3_1)
		self.maxSpin.min = 3
		self.maxSpin.position = 3
			
		self.minCheck.addChangedEvent(self.minCheckCallback)
		self.maxCheck.addChangedEvent(self.maxCheckCallback)
		self.minSpin.addChangingEvent(self.minSpinCallback)
		self.maxSpin.addChangingEvent(self.maxSpinCallback)
		
		self.frame4 = self.createHorizontalFrame(self)
		self.frame4.uniformSize = True
		self.okbtn = MQWidget.Button(self.frame4)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame4)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1
		
		
dlg = NumberDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	min	= dlg.minSpin.position
	max = dlg.maxSpin.position
	
	minCheck = dlg.minCheck.checked
	maxCheck = dlg.maxCheck.checked
	doc = MQSystem.getDocument()
	
	numObj = doc.numObject
	for oi in range(0,numObj):
		obj = doc.object[oi]
		if obj is None: continue
	
		numFace = obj.numFace
		
		#Select Faces Polygonal Number
		for fi in range(0, numFace):
			face = obj.face[fi]
			num = face.numVertex
			if minCheck and maxCheck :
				if num >= min and num <= max :
					face.select = 1
				else:
					face.select = 0
			elif minCheck and not maxCheck :
				if num >= min :
					face.select = 1
				else:
					face.select = 0
			elif not minCheck and maxCheck :
				if num <= max :
					face.select = 1
				else:
					face.select = 0
					