import random

class RGB:
	def __init__(self,red,green,blue):
		self._red = red
		self._green = green
		self._blue = blue
		
	def setRGB(self,red,green,blue):
		self._red = red
		self._green = green
		self._blue = blue
	
	def setRandom(self):
		self._red = random.random()
		self._green = random.random()
		self._blue = random.random()

	def __add__(self,other):
		red = self._red + other._red
		green = self._green + other._green
		blue = self._blue + other._blue
		return RGB(red,green,blue)

	def __sub__(self,other):
		red = self._red - other._red
		green = self._green - other._green
		blue = self._blue - other._blue
		return RGB(red,green,blue)

	def __mul__(self,other):
		red = self._red * other._red
		green = self._green * other._green
		blue = self._blue * other._blue
		return RGB(red,green,blue)

	def __truediv__(self,other):
		red = self._red / other._red
		green = self._green / other._green
		blue = self._blue / other._blue
		return RGB(red,green,blue)

	def __eq__(self,other):
		red = self.equal(self._red, other._red)
		green = self.equal(self._green, other._green)
		blue = self.equal(self._blue, other._blue)
		if red and green and blue:
			return True
		else:
			return False

	def equal(self,a,b):
		if a == b:
			return True
		else:
			return False

	def __str__(self):
		r = self._red
		g = self._green
		b = self._blue
		return "({0},{1},{2})".format(r,g,b)

	@property
	def red(self):
		return self._red
	
	@red.setter
	def red(self,value):
		if value <= 1:
			self._red = value
		else:
			self._red = 1

	@property
	def green(self):
		return self._green
	
	@green.setter
	def green(self,value):
		if value <= 1:
			self._green = value
		else:
			self._green = 1

	@property
	def blue(self):
		return self._blue
	
	@blue.setter
	def blue(self,value):
		if value <= 1:
			self._blue = value
		else:
			self._blue = 1
			
			