import random

doc = MQSystem.getDocument()

class NumberDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Clone Random"
		self.frame1 = self.createHorizontalFrame(self)
		self.label = MQWidget.Label(self.frame1)
		self.label.text = "Num"
		self.spin = MQWidget.SpinBox(self.frame1)
		self.spin.min = 1
		self.spin.max = 100
		self.spin.position = 10
		self.frame2 = self.createHorizontalFrame(self)
		self.frame2.uniformSize = True
		self.okbtn = MQWidget.Button(self.frame2)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame2)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1

rangeXYZ = 1000
dlg = NumberDialog(MQWidget.getMainWindow())
index = doc.currentObjectIndex
if dlg.execute() == "ok" and index >= 0 and index < doc.numObject:
	obj0 = doc.object[index]
	if obj0 is None:
		MQSystem.println("None")
	else:
		for i in range(dlg.spin.position):
			obj1 = obj0.clone()
			numVertex = obj1.numVertex
			h = random.randint(-90,90)
			p = random.randint(-90,90)
			b = random.randint(-90,90)
			angle = MQSystem.newAngle(h,p,b).getMatrix()
			x = random.randint(-rangeXYZ,rangeXYZ)
			y = random.randint(-rangeXYZ,rangeXYZ)
			z = random.randint(-rangeXYZ,rangeXYZ)
			for vi in range(0, numVertex):
				p = obj1.vertex[vi].getPos()
				p = angle.mult(p)
				obj1.vertex[vi].setPos(p.x+x,p.y+y,p.z+z)
			doc.addObject(obj1)
				