import math

doc = MQSystem.getDocument()

def makeBox(size,x,y,z):

	obj = MQSystem.newObject()
	size /= 2.0
	v0 = obj.addVertex(x-size,y-size,z+size)
	v1 = obj.addVertex(x+size,y-size,z+size)
	v2 = obj.addVertex(x+size,y+size,z+size)
	v3 = obj.addVertex(x-size,y+size,z+size)
	v4 = obj.addVertex(x-size,y-size,z-size)
	v5 = obj.addVertex(x-size,y+size,z-size)
	v6 = obj.addVertex(x+size,y+size,z-size)
	v7 = obj.addVertex(x+size,y-size,z-size)
	obj.addFace([v0,v3,v2,v1])
	obj.addFace([v1,v2,v6,v7])
	obj.addFace([v4,v7,v6,v5])
	obj.addFace([v0,v4,v5,v3])
	obj.addFace([v3,v5,v6,v2])
	obj.addFace([v0,v1,v7,v4])
	doc.addObject(obj)
	return obj

obj0 = makeBox(30,0,0,0)

#u-360vdĂ̂1
xSet = {-360,-360,-330,-300,-270,-240,-210,
	-180,-150,-120,-90,-60,-30,30,60,90,
	120,150,180,210,240,270,300,330,360}

for x in xSet: 
	obj1 = obj0.clone()
	y = math.sin(math.radians(x))*90
	numVertex = obj1.numVertex
	for i in range(numVertex):
		p = obj1.vertex[i].getPos()
		obj1.vertex[i].setPos(p.x+x,p.y+y,p.z)
	doc.addObject(obj1)
