import math

doc = MQSystem.getDocument()
class ComboDialog(MQWidget.Dialog):
	def __init__(self, parent):
		MQWidget.Dialog.__init__(self, parent)
		self.title = "Sin Duplicate"
		self.frame0 = self.createHorizontalFrame(self)
		self.label0 = MQWidget.Label(self.frame0)
		self.label0.text = "Source"
		self.combo0 = MQWidget.ComboBox(self.frame0)
		numObject = doc.numObject
		for i in range(numObject):
			obj = doc.object[i]
			if obj is None: continue
			self.combo0.addItem(obj.name)
		self.frame2 = self.createHorizontalFrame(self)
		self.okbtn = MQWidget.Button(self.frame2)
		self.okbtn.text = "OK"
		self.okbtn.modalResult = "ok"
		self.okbtn.default = 1
		self.okbtn.fillBeforeRate = 1
		self.cancelbtn = MQWidget.Button(self.frame2)
		self.cancelbtn.text = "Cancel"
		self.cancelbtn.modalResult = "cancel"
		self.cancelbtn.default = 1
		self.cancelbtn.fillAfterRate = 1

def objectIndexByName(name):
	numObject = doc.numObject
	for i in range(numObject):
		obj = doc.object[i]
		if obj is None: continue
		if obj.name == name: return obj
	return None

num = 0
dlg = ComboDialog(MQWidget.getMainWindow())
if dlg.execute() == "ok":
	name = dlg.combo0.getItem(dlg.combo0.currentIndex)
	obj0 = objectIndexByName(name)
	if obj0 is None:
		MQSystem.println("Error")
	else:
		for x in range(-720,720,30): 
			obj1 = obj0.clone()
			obj1.name = "duplicate"+str(num)
			num += 1
			y = math.sin(math.radians(x))*90
			numVertex = obj1.numVertex
			for i in range(numVertex):
				p = obj1.vertex[i].getPos()
				obj1.vertex[i].setPos(p.x+x,p.y+y,p.z)
			doc.addObject(obj1)
