import MQSystem

def interpolate(t,p0,p1,p2,p3):
	p = MQSystem.newPoint()
	p.x = spline(t,p0.x,p1.x,p2.x,p3.x)
	p.y = spline(t,p0.y,p1.y,p2.y,p3.y)
	p.z = spline(t,p0.z,p1.z,p2.z,p3.z)
	return p

def spline(t,x0,x1,x2,x3):
	t2 = t * t
	t3 = t2 * t
	alpha = 0.0
	x    = ((1-alpha)/2.0)*((x1-x0)+x2-x1)
	xx   = ((1-alpha)/2.0)*((x2-x1)+x3-x2)
	xxx  = (((2*t3)-(3*t2)+1)*x1)
	xxx += ((t3-(2*t2)+t)*x)+((t3-t2)*xx)
	xxx += (((-2*t3)+(3*t2))*x2)
	return xxx
