import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.applet.Applet;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.zip.*;
import raytrans.*;

public class Stairway extends Applet implements Runnable
{
	int SCREENW;	//XN[
	int SCREENH;	//XN[

	private Thread		th;

	private Model   player   = null;
	private Model[] stairway = null;

	private rtRender render = null;

	private Image    imaBuff;
	private Graphics graBuff;

	private float rotatePlayer;
	private float count;
	private float rotateStair;
	private float rotateCamera;
	private int   score;
	
	private int gameState;
	
	final int GS_TITLE      = 0;
	final int GS_TITLE2MAIN = 1;
	final int GS_MAIN       = 2;
	final int GS_FALL       = 3;
	final int GS_GAME_OVER  = 4;
	
	// 
	// 
	// 	p[^f[^Webǂݍ݂܂B
	//
	public void init()
	{
		SCREENW = getSize().width;
		SCREENH = getSize().height;

		render = new rtRender(this,SCREENW,SCREENH);

		rtLoader loader = new rtLoader(this);

		//zipɈkmqst@CAȂmqst@Cǂݍ(Aj[Vtf)
		player = new Model(loader.LoadMQSFile("Boy"));
//		player.setTexture(loader);
	
		loader.init(this);
		
		stairway = new Model[20];
		//zipɈkmqot@CAȂmqot@Cǂݍ(Î~f)
		rtObject[] obj = loader.LoadMQOFile("Stair");
		for ( int i = 0; i < 20; i++ )
		{
			stairway[i] = new Model(obj);
		}

		loader = null;

		imaBuff	= createImage(SCREENW,SCREENH);
		graBuff = imaBuff.getGraphics();
		
		initialize();
	}
	
	private void initialize()
	{
		Matrix m = new Matrix();
		player.move.set(0,0,0);
		player.rotate.set(0,180,0);
		m.Translate(player.move);
		player.setTransform(m);
//		player.SetAnimation(0,16,2,true);	

		for ( int i = 0; i < 20; i++ )
		{
			Matrix m2 = new Matrix();
			stairway[i].move.set(0,0,20*20-i*20);
			stairway[i].rotate.set(0,180,0);
			m2.Translate(stairway[i].move);
			stairway[i].setTransform(m2);
		}

		rotatePlayer = 0;	
		count = 20;
		rotateStair = 0;
		rotateCamera = 0;
		score = 0;
		gameState = GS_TITLE;
	}

	public void start()
	{
		th = new Thread(this);
		th.setPriority(th.MIN_PRIORITY);
		if (th!=null) th.start();
	}

	public void stop()
	{
        if (th!=null) th = null;
    }

	public void destroy()
	{
	}
	
	public void run()
	{
		try
		{
			while(true)
			{
				repaint();
				th.sleep(200);
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	public void update(Graphics g)
	{
		switch ( gameState )
		{
		case GS_TITLE:
		case GS_TITLE2MAIN:
			titleScreen(g);
			break;
		case GS_MAIN:
			mainScreen(g);
			break;
		case GS_FALL:
			fallScreen(g);
			break;
		case GS_GAME_OVER:
			initialize();
			gameState = GS_TITLE;
			break;
		}
	}
	
	private void titleScreen(Graphics g)
	{
		int i;
		Vector pos = player.getPosition();

		//vC[̃gXtH[
		Matrix m = new Matrix();

		pos.z -= 3; 
		m.Translate(pos);
		player.setTransform(m);

		imaBuff.flush();

		if ( gameState == GS_TITLE2MAIN )
		{
			rotateCamera += 45;
			if ( rotateCamera >= 180 )
			{
				gameState = GS_MAIN;
				for ( i = 0; i < stairway.length; i++ )
				{
					Matrix m2 = new Matrix();
					stairway[i].move.set(0,i*4,pos.z+i*15+15);
					stairway[i].rotate.set(0,180,0);
					m2.Translate(stairway[i].move);
					stairway[i].setTransform(m2);
				}
			}
		}
		else
		{
			rotateCamera = 0;
		}

		//KĩgXtH[
		for ( i = 0; i < stairway.length; i++ )
		{
			Matrix m2 = new Matrix();
			m2.Translate(stairway[i].move);
			stairway[i].setTransform(m2);
			if ( stairway[i].move.z > pos.z + 300 )
			{
				stairway[i].move.z -= 20*(stairway.length-1); 
			}
		}
		
		double radian = Math.toRadians(rotateCamera);
		//Jl̑O
		Vector dest = player.getPosition();
		Vector eye = new Vector();
		eye.x = dest.x - (float)(Math.sin(radian)*125);
		eye.y = dest.y + 20;
		eye.z = dest.z - (float)(Math.cos(radian)*125);
		dest.y += 15;
		render.setCamera(eye,dest);
		
		render.BeginScene(getSkyColor());
		//Ki`
		for ( i = 0; i < stairway.length; i++ )
		{
			stairway[i].Draw(render);
		}
		//l`
		player.Draw(render);
		paint(g);	
	}
	
	private void mainScreen(Graphics g)
	{
		int i;
		Vector pos = player.getPosition();

		score++;
		
		imaBuff.flush();

		//vC[̃gXtH[
		Matrix m = new Matrix();
		double rad = player.addRotateY(rotatePlayer);

		pos.x -= (float)(Math.sin(rad)*3);//-(count*0.01))); 
		pos.y += 1;
		pos.z -= (float)(Math.cos(rad)*3);//-(count*0.01))); 
		m.RotateY((float)rad);
		m.Translate(pos);
		player.setTransform(m);

		//KĩgXtH[
		for ( i = 0; i < stairway.length; i++ )
		{
			Matrix m2 = new Matrix();
			double rad2 = Math.toRadians(stairway[i].rotate.y);
			m2.RotateY((float)rad2);
			m2.Translate(stairway[i].move);
			stairway[i].setTransform(m2);
			if ( stairway[i].move.y < pos.y - 20 )
			{
				count += 0.1f;
				rotateStair += Math.random()*count-Math.random()*count;
				rad2 = stairway[i].addRotateY(rotateStair);
				Vector v = stairway[(i+19)%stairway.length].move;
				stairway[i].move.x = v.x - (float)(Math.sin(rad2)*12); 
				stairway[i].move.y = v.y + 4;
				stairway[i].move.z = v.z - (float)(Math.cos(rad2)*12);
			}
		}

		//Jl̔w
		Vector dest = player.getPosition();
		Vector eye = new Vector();
		eye.x = dest.x + (float)(Math.sin(rad)*125);
		eye.y = dest.y + 20;
		eye.z = dest.z + (float)(Math.cos(rad)*125);
		dest.y += 15;
		render.setCamera(eye,dest);
		
		render.BeginScene(getSkyColor());
		//Ki`
		for ( i = 0; i < stairway.length; i++ )
		{
			stairway[i].Draw(render);
		}
		//l`
		player.Draw(render);
		paint(g);	

		//KilĂȂ`FbN
		Vector pPos = player.getPosition();
		for ( i = 0; i < stairway.length; i++ )
		{
			Vector sPos = stairway[i].getPosition();
			
			sPos.x = sPos.x - pPos.x;
			sPos.z = sPos.z - pPos.z;
			
			if ( sPos.x*sPos.x + sPos.z*sPos.z < 21*21 )
			{
				break;
			}
		}		
		if ( i >= stairway.length )
		{
			count = 0;
			gameState = GS_FALL;
		}
	}
	
	//Ki痎
	private void fallScreen(Graphics g)
	{
		Matrix m = new Matrix();
		float rad = player.addRotateY(40);
		Vector pos = player.getPosition();

		imaBuff.flush();

		m.RotateY(rad);
		pos.y -= 2;
		m.Translate(pos);
		player.setTransform(m);			
		
		render.BeginScene(getSkyColor());

		//Ki`
		for ( int i = 0; i < stairway.length; i++ )
		{
			stairway[i].Draw(render);
		}
		//l`
		player.Draw(render);
		paint(g);	
		
		count++;
		if ( count > 60 )
		{
			gameState = GS_GAME_OVER;
		}
	}
	
	private float color   = 0;
	private int   current = 0;

	private int getSkyColor()
	{
		color = color + 2;
		  
		if ( color > 255 )
		{
			color = 0;
		    current = current + 1;
		    
		    if ( current >= 7 )
		    {
		      current = 0;
		    } 
		}	  
		
		final int colorR[] = {153,100,160,255, 64, 1, 1,153};  
		final int colorG[] = {208,160,160,153, 64, 1, 1,208};  
		final int colorB[] = {255,255,255,  1,128,64,32,255}; 
		  
		float col = colorR[current+1]-colorR[current];  
		int colR = (int)(colorR[current] + col*color/255);

		col = colorG[current+1]-colorG[current];  
		int colG = (int)(colorG[current] + col*color/255);
		  
		col = colorB[current+1]-colorB[current];
		int colB = (int)(colorB[current] + col*color/255);

		return 0xff000000 | colR << 16 | colG << 8 | colB;
	}

	public void paint(Graphics g)
	{
		graBuff.drawImage(render.endScene(), 0, 0, this);

		g.drawImage(imaBuff, 0, 0, this);		
	}

	public boolean mouseDown(Event evt,int x,int y)
	{
		if ( gameState == GS_TITLE )
		{
			gameState = GS_TITLE2MAIN;
		}
		return true;
	}
	
	public boolean keyDown(Event evt,int key)
	{
		switch ( key )
		{
		case Event.LEFT:
			rotatePlayer = -1;
			break;
		case Event.RIGHT:
			rotatePlayer = 1;
			break;
		}
		
		return true;
	}

	public boolean keyUp(Event evt,int key)
	{
		switch ( key )
		{
		case Event.LEFT:
			rotatePlayer = 0;
			break;
		case Event.RIGHT:
			rotatePlayer = 0;
			break;
		}
		
		return true;
	}
}
