package raytrans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BMPReader extends ImageReader
{

	public BMPReader() {
		super();
	}

	public void setImage(URL url)
	{
		flush();

		byte[] data = URLtoByteArray(url);

		if(data != null)
		{
			ByteArrayInputStream in = new ByteArrayInputStream(data);
			readData(in);
			closeStream(in);
			in = null;
		}
	}

	public void setImage(InputStream in)
	{
		flush();

		readData(in);
	}

	private void readData(InputStream in){
		//wb_[̓ǂݍ
		byte[] head = new byte[54];
		try{
			in.read(head);
		}catch(IOException e){
			return;
		}
		if(byteToShort(head,0) != 19778){  //BM  0- 2byte
			return;
		}
		
		int fileSize = byteToInt(head,2);  //t@CTCY 2- 4byte
		//skip(4);  //\ 6- 4byte
		//int offSet = readInt(); //摜f[^̃ItZbg 10- 4byte
		//int length = readInt(); //ubN̒  14- 4byte
		width = byteToInt(head,18); //摜̕ 18- 4byte
		height = byteToInt(head,22); //摜̍ 22- 4byte
		//int plain = readShort(); //v[̃TCY 26- 2byte
		int bitSize = byteToShort(head,28); //PsNZ̃f[^  28- 2byte
		int comp = byteToInt(head,30);  //摜̈k  30- 4byte
		//int imgSize =readInt(); //摜TCY 34- 4byte
		//in.skip(8);  //ۂ̑傫igĂȂj28- 8byte
		int pletNumber = byteToInt(head,46); //pbg 46- 4byte
		//in.skip(4); //dvȃpbg̃CfbNX 50- 4byte
		
		if(comp != 0){
			return;
		}
		
		//int[] pixel = null;
		switch(bitSize){
			case 24:
				pixel = readFullColor(in);
				break;
			case 8:
				pixel = read256Color(in,pletNumber);
				break;
			case 4:
				pixel = read16Color(in);
				break;
			case 1:
				pixel = read2Color(in);
				break;
		}
	}
	
	private int[] readFullColor(InputStream in){
		System.out.println("readFullColor");

		int lineWidth = normalizeMod(3*width,4);
		byte[] buff = new byte[lineWidth];
		
		int offset = height*width;
		int[] pixelBuff = new int[offset];
		
		for(int j = height-1;j>=0;j--){
			try{
				in.read(buff);
			}catch(IOException e){
				return null;
			}
			int p = 0;
			offset -= width;
			for(int i=0;i<width;i++){
				pixelBuff[offset+i] = (buff[p++]&0xFF) | ((buff[p++]&0xFF) << 8 ) | ((buff[p++]&0xFF) << 16);
			}
		}
		
		return pixelBuff;
	}
	private int[] read256Color(InputStream in,int pletNumber){
		System.out.println("read256Color");

		if(pletNumber <= 0){
			return null;
		}
		byte[] buff = new byte[4*pletNumber];
		try{
			in.read(buff);
		}catch(IOException e){
			return null;
		}
		int[] color = new int[pletNumber];
		int p = 0;
		for(int i=0;i<pletNumber;i++){
			color[i] = (buff[p++]&0xFF) | ((buff[p++]&0xFF) << 8 ) | ((buff[p++]&0xFF) << 16);
			p++;
		}
		int lineWidth = normalizeMod(width,4);
		buff = new byte[lineWidth];
		int offset = height*width;
		int[] pixelBuff = new int[offset];

		for(int j = height-1;j>=0;j--){
			try{
				in.read(buff);
			}catch(IOException e){
				return null;
			}
			offset -= width;
			p = 0;
			for(int i=0;i<width;i++){
				pixelBuff[offset+i] = ( color[buff[p++] & 0x00FF] ) | 0xff000000;
			}
		}
		
		return pixelBuff;
	}
	private int[] read16Color(InputStream in){
		System.out.println("read16Color");

		byte[] buff = new byte[4*16];
		try{
			in.read(buff);
		}catch(IOException e){
			return null;
		}
		int p = 0;
		int[] color = new int[16];
		for(int i=0;i<16;i++){
			color[i] = (buff[p++]&0xFF) | ((buff[p++]&0xFF) << 8 ) | ((buff[p++]&0xFF) << 16);
			p++;
		}
		int lineWidth = normalizeMod((width+1)/2,4);
		buff = new byte[lineWidth];
		int offset = height*width;
		int[] pixelBuff = new int[offset];
		
		int wd2 = width/2;
		boolean flag = (width%2 == 1);
		
		for(int j = height-1;j>=0;j--){
			try{
				in.read(buff);
			}catch(IOException e){
				return null;
			}
			offset -= width;
			p = 0;
			int pixelPoint = offset;
			for(int i=0;i<wd2;i++){
				pixelBuff[pixelPoint++]	= ( color[(buff[i] >> 4) & 0x0F] ) | 0xff000000;
				pixelBuff[pixelPoint++] = ( color[ buff[i]       & 0x0F] ) | 0xff000000;
			}
			if(flag){
				pixelBuff[pixelPoint] = ( color[(buff[wd2] >> 4) & 0x0F] ) | 0xff000000;
			}
		}

		return pixelBuff;
	}
	private int[] read2Color(InputStream in){
		System.out.println("read2Color");

		byte[] buff = new byte[8];
		try{
			in.read(buff);
		}catch(IOException e){
			return null;
		}
		int falseColor = (buff[0]&0xFF) | ((buff[1]&0xFF) << 8 ) | ((buff[2]&0xFF) << 16);
		int trueColor  = (buff[4]&0xFF) | ((buff[5]&0xFF) << 8 ) | ((buff[6]&0xFF) << 16);
		
		int lineWidth = normalizeMod((width+7)/8,4);
		buff = new byte[lineWidth];
		int offset = height*width;
		int[] pixelBuff = new int[offset];
		
		boolean[] result = new boolean[8];
		int wp8 = width/8;
		boolean flag = width%8 != 0;
		int wa8 = width%8;
		
		for(int j = height-1;j>=0;j--){
			try{
				in.read(buff);
			}catch(IOException e){
				return null;
			}
			offset -= width;
			int pixelPoint = offset;
			for(int i=0;i<wp8;i++){
				byteToBoolean(result,buff[i]);
				for(int k=0;k<8;k++){
					pixelBuff[pixelPoint++] = (result[k] ? trueColor:falseColor) | 0xff000000;
				}
			}
			if(flag){
				byteToBoolean(result,buff[wp8]);
				for(int k=0;k<8;k++){
					pixelBuff[pixelPoint++] = (result[k] ? trueColor:falseColor) | 0xff000000;
				}
			}
		}
		return pixelBuff;
	}
	private void byteToBoolean(boolean[] result,byte b){
		int mask = 0x80;
		for(int i=0;i<8;i++){
			result[i] = ((b & mask) != 0);
			mask = mask >> 1;
		}
	}
	private int normalizeMod(int n,int m){
		return (n + m -1)/m*m;
	}
	protected int byteToInt(byte[] b,int st){
		return (b[st]&0xFF)
				| ((b[st+1]&0xFF) << 8)
				| ((b[st+2]&0xFF) << 16)
				| ((b[st+3]&0xFF) << 24);
	}
	protected int byteToShort(byte[] b,int st){
		return (b[st]&0xFF)
				| ((b[st+1]&0xFF) << 8);
	}

}
