package raytrans;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public abstract class ImageReader
{
	protected int[] pixel;
	protected int width;
	protected int height;

	public ImageReader()
	{
		flush();
	}

	public final int getWidth()
	{
		return width;
	}

	public final int getHeight()
	{
		return height;
	}

	public final int[] getPixel()
	{
		return pixel;
	}

	protected void flush()
	{
		pixel = null;
		width = -1;
		height= -1;

	}

	public abstract void setImage(URL url);

	public abstract void setImage(InputStream in);

	//f[^bytezɕϊĊi[
	protected final byte[] URLtoByteArray(URL url)
	{
		byte[] data = null;

		InputStream url_in = null;
		BufferedInputStream buffin = null;

		try
		{
			URLConnection connect = url.openConnection();

			url_in = connect.getInputStream();
			buffin = new BufferedInputStream(url_in);

			final int url_len = connect.getContentLength();

			data = new byte[url_len];

			//łɓǂݍݏIf[^̒B
			int data_len = 0;

			//rbytesɓǂݍ񂾃oCgL^
			do
			{
				int rbytes = buffin.read(data, data_len, url_len - data_len);
				if(rbytes < 0) { break; }
				data_len += rbytes;
			}while(data_len < url_len);
	
		}
		catch (MalformedURLException e)
		{
			System.out.println("MalformedURLException");
		}
		catch (UnknownServiceException e)
		{
			System.out.println("UnknownServiceException");
		}
		catch (IOException e )
		{
			System.out.println("IOException");
		}
		catch (Exception e)
		{
			e.printStackTrace();
	   	}
		finally{
    		if(url_in != null)
			{
				closeStream(url_in);
				closeStream(buffin);
				url_in = null;
				buffin = null;
			}
		}

		return data;
	}


	protected final void closeStream(InputStream in)
	{
		try
		{
        	in.close();
       	}
		catch(IOException e)
		{
			e.printStackTrace();
		}
		catch(NullPointerException e)
		{
			e.printStackTrace();
		}
	}
}
