package raytrans;

import java.awt.Image;

public class Material
{
	private String name = null;

	private rtColor color = null;

	int Amb;
	int Emi;
	int D;		//gU
	int S;		//ˌ
	float PW;		//ˌ̋

	private rtSurface texture;
	private rtSurface alpha;
	private rtSurface bump;

	public Material()
	{
		texture = new rtSurface();
		alpha   = new rtSurface();
		bump    = new rtSurface();
	}

	public Material(String matName)
	{
		this();
		setName(matName);
	}

	public Material(double dr,double dg,double db,double da)
	{
		this();
		set(dr,dg,db,da);
	}

	public Material(Material mat)
	{
		this();
		set(mat);
	}

	public void setZERO()
	{
		Amb = 0;
		Emi = 0;
		D = 0;		//gU
		S = 0;		//ˌ
		PW = 0f;
	}

	public void set(Material mat)
	{
		setColor(mat.color);

		this.Amb = mat.Amb;
		this.Emi = mat.Emi;
		this.D   = mat.D;		//gU
		this.S   = mat.S;		//ˌ
		this.PW  = mat.PW;		//ˌ̋

		this.texture.set(mat.texture);
		this.alpha.set(mat.alpha);
		this.bump.set(mat.bump);

		setName(mat.name);
	}

	public void setColor(rtColor C)
	{
		if(color == null){color = new rtColor(C);}
		else color.set(C);
	}

	public void set(double dr,double dg,double db,double da)
	{
		this.color = new rtColor(dr,dg,db,da);
	}

	public void setName(String matName)
	{
		if(matName != null)
		{
			this.name = new String(matName);
		}
	}

	public void setTextureName(String s)
	{
		texture.setName(s);
	}

	public void setAlphaName(String s)
	{
		alpha.setName(s);
	}

	public void setTexture(Image image)
	{
		texture.create(image);
	}

	public void setTexture(rtSurface surface)
	{
		texture.set(surface);
	}
	
	public void setAlpha(Image image)
	{
		alpha.create(image);
	}

	public void setAlpha(rtSurface surface)
	{
		alpha.set(surface);
	}

	public String getName()
	{
		return name;
	}

	public int[] getTextureBuffer()
	{
		return texture.getBuffer();
	}

	public int getTextureWidth()
	{
		return texture.getWidth();
	}

	public int getTextureHeight()
	{
		return texture.getHeight();
	}

	public String getTextureName()
	{
		return texture.getName();
	}

	public int[] getAlphaBuffer()
	{
		return alpha.getBuffer();
	}

	public int getAlphaWidth()
	{
		return alpha.getWidth();
	}

	public int getAlphaHeight()
	{
		return alpha.getHeight();
	}

	public String getAlphaName()
	{
		return alpha.getName();
	}

	public rtColor getColor()
	{
		return color;
	}
}