package raytrans;

//-----------------------------------------------------------
//}gNXNX
//
//-----------------------------------------------------------
public class Matrix
{
	//-----------------------------------------------------------
	//oϐ
	//
	//-----------------------------------------------------------
	public float m00,m01,m02,m03;
	public float m10,m11,m12,m13;
	public float m20,m21,m22,m23;
	public float m30,m31,m32,m33;
	
	public Matrix(){ this.Initialize(); }
	
	//-----------------------------------------------------------
	//Pʍsŏ
	//
	//-----------------------------------------------------------
	public void Initialize()
	{
		//|  1  0  0  0|
		//|  0  1  0  0|
		//|  0  0  1  0|
		//|  0  0  0  1|

		m00 = 1;m01 = 0;m02 = 0;m03 = 0;
		m10 = 0;m11 = 1;m12 = 0;m13 = 0;
		m20 = 0;m21 = 0;m22 = 1;m23 = 0;
		m30 = 0;m31 = 0;m32 = 0;m33 = 1;
	}

	//-----------------------------------------------------------
	//
	//
	//-----------------------------------------------------------
	public void Initialize(Matrix m)
	{
		m00 = m.m00;m01 = m.m01;m02 = m.m02;m03 = m.m03;
		m10 = m.m10;m11 = m.m11;m12 = m.m12;m13 = m.m13;
		m20 = m.m20;m21 = m.m21;m22 = m.m22;m23 = m.m23;
		m30 = m.m30;m31 = m.m31;m32 = m.m32;m33 = m.m33;
	}

	//-----------------------------------------------------------
	//s̊|Zij
	//
	//Matrix m ...}gNX
	//-----------------------------------------------------------
	public void Mult(Matrix m)
	{
		final float _00 = m00*m.m00 + m01*m.m10 + m02*m.m20 + m03*m.m30;
		final float _01 = m00*m.m01 + m01*m.m11 + m02*m.m21 + m03*m.m31;
		final float _02 = m00*m.m02 + m01*m.m12 + m02*m.m22 + m03*m.m32;
		final float _03 = m00*m.m03 + m01*m.m13 + m02*m.m23 + m03*m.m33;
		final float _10 = m10*m.m00 + m11*m.m10 + m12*m.m20 + m13*m.m30;
		final float _11 = m10*m.m01 + m11*m.m11 + m12*m.m21 + m13*m.m31;
		final float _12 = m10*m.m02 + m11*m.m12 + m12*m.m22 + m13*m.m32;
		final float _13 = m10*m.m03 + m11*m.m13 + m12*m.m23 + m13*m.m33;
		final float _20 = m20*m.m00 + m21*m.m10 + m22*m.m20 + m23*m.m30;
		final float _21 = m20*m.m01 + m21*m.m11 + m22*m.m21 + m23*m.m31;
		final float _22 = m20*m.m02 + m21*m.m12 + m22*m.m22 + m23*m.m32;
		final float _23 = m20*m.m03 + m21*m.m13 + m22*m.m23 + m23*m.m33;
		final float _30 = m30*m.m00 + m31*m.m10 + m32*m.m20 + m33*m.m30;
		final float _31 = m30*m.m01 + m31*m.m11 + m32*m.m21 + m33*m.m31;
		final float _32 = m30*m.m02 + m31*m.m12 + m32*m.m22 + m33*m.m32;
		final float _33 = m30*m.m03 + m31*m.m13 + m32*m.m23 + m33*m.m33;
		
		m00 = _00; m01 = _01;m02 = _02;m03 = _03;
		m10 = _10; m11 = _11;m12 = _12;m13 = _13;
		m20 = _20; m21 = _21;m22 = _22;m23 = _23;
		m30 = _30; m31 = _31;m32 = _32;m33 = _33;
	}

	//-----------------------------------------------------------
	//gk
	//
	//float sx ...w{
	//float sy ...x{
	//float sz ...y{
	//-----------------------------------------------------------
	public void Scale(float sx,float sy,float sz)
	{		
		//| sx  0  0  0|
		//|  0 sy  0  0|
		//|  0  0 sz  0|
		//|  0  0  0  1|

		final Matrix m = new Matrix();
		m.m00 = sx;m.m01 =  0;m.m02 =  0;m.m03 = 0;
		m.m10 =  0;m.m11 = sy;m.m12 =  0;m.m13 = 0;
		m.m20 =  0;m.m21 =  0;m.m22 = sz;m.m23 = 0;
		m.m30 =  0;m.m31 =  0;m.m32 =  0;m.m33 = 1;

		//s̍
		this.Mult(m);
	}
	
	//-----------------------------------------------------------
	//w]
	//
	//float r ...]piPʃWAj
	//-----------------------------------------------------------
	public void RotateX(float r)
	{
		final float sinx = (float)Math.sin(r);
		final float cosx = (float)Math.cos(r);	

		//X]
		//| 1     0    0 0|
		//| 0  cosX sinX 0|
		//| 0 -sinX cosX 0|
		//| 0     0    0 1|	

		final Matrix m = new Matrix();
		m.m00 = 1;m.m01 =    0;m.m02 =    0;m.m03 = 0;
		m.m10 = 0;m.m11 = cosx;m.m12 = sinx;m.m13 = 0;
		m.m20 = 0;m.m21 =-sinx;m.m22 = cosx;m.m23 = 0;
		m.m30 = 0;m.m31 =    0;m.m32 =    0;m.m33 = 1;

		//s̍
		this.Mult(m);
	}
	
	//-----------------------------------------------------------
	//x]
	//
	//float r ...]piPʃWAj
	//-----------------------------------------------------------
	public void RotateY(float r)
	{
		final float siny = (float)Math.sin(r);
		final float cosy = (float)Math.cos(r);

		//Y]
		//| cosY 0 -sinY 0|
		//|    0 1     0 0|
		//| sinY 0  cosY 0|
		//|    0 0     0 1|

		final Matrix m = new Matrix();
		m.m00 = cosy;m.m01 = 0;m.m02 =-siny;m.m03 = 0;
		m.m10 =    0;m.m11 = 1;m.m12 =    0;m.m13 = 0;
		m.m20 = siny;m.m21 = 0;m.m22 = cosy;m.m23 = 0;
		m.m30 =    0;m.m31 = 0;m.m32 =    0;m.m33 = 1;

		//s̍
		this.Mult(m);
	}

	//-----------------------------------------------------------
	//y]	
	//
	//float r ...]piPʃWAj
	//-----------------------------------------------------------
	public void RotateZ(float r)
	{
		final float sinz = (float)Math.sin(r);
		final float cosz = (float)Math.cos(r);	

		//Z]
		//|  cosZ sinZ 0 0|
		//| -sinZ cosZ 0 0|
		//|     0    0 1 0|
		//|     0    0 0 1|	

		final Matrix m = new Matrix();
		m.m00 = cosz;m.m01 = sinz;m.m02 = 0;m.m03 = 0;
		m.m10 =-sinz;m.m11 = cosz;m.m12 = 0;m.m13 = 0;
		m.m20 =    0;m.m21 =    0;m.m22 = 1;m.m23 = 0;
		m.m30 =    0;m.m31 =    0;m.m32 = 0;m.m33 = 1;

		//s̍
		this.Mult(m);
	}

	//-----------------------------------------------------------
	//sړ
	//
	//float dx ...wړ
	//float dy ...xړ
	//float dz ...yړ
	//-----------------------------------------------------------
	public void Translate(Vector v)
	{
		Translate(v.x,v.y,v.z);
	}

	public void Translate(float dx,float dy,float dz)
	{
		//|  1  0  0  0|
		//|  0  1  0  0|
		//|  0  0  1  0|
		//| dx dy dz  1|

		final Matrix m = new Matrix();
		m.m00 =  1;m.m01 =  0;m.m02 =  0;m.m03 = 0;
		m.m10 =  0;m.m11 =  1;m.m12 =  0;m.m13 = 0;
		m.m20 =  0;m.m21 =  0;m.m22 =  1;m.m23 = 0;
		m.m30 = dx;m.m31 = dy;m.m32 = dz;m.m33 = 1;

		//s̍
		this.Mult(m);	
	}

	static public Matrix Translation(float dx,float dy,float dz)
	{
		//|  1  0  0  0|
		//|  0  1  0  0|
		//|  0  0  1  0|
		//| dx dy dz  1|

		final Matrix m = new Matrix();
		m.m00 =  1;m.m01 =  0;m.m02 =  0;m.m03 = 0;
		m.m10 =  0;m.m11 =  1;m.m12 =  0;m.m13 = 0;
		m.m20 =  0;m.m21 =  0;m.m22 =  1;m.m23 = 0;
		m.m30 = dx;m.m31 = dy;m.m32 = dz;m.m33 = 1;

		return m;	
	}

	//-----------------------------------------------------------
	//ꎟϊ
	//
	//Vector a ...ϊW
	//
	//ߒlFϊꂽWԂB
	//-----------------------------------------------------------
	public Vector Transform(Vector a)
	{
		Vector v = new Vector();
		v.x = m00 * a.x + m10 * a.y + m20 * a.z + m30;
		v.y = m01 * a.x + m11 * a.y + m21 * a.z + m31;
		v.z = m02 * a.x + m12 * a.y + m22 * a.z + m32;

		return v;
	}

	public void Transform(Vector in,Vector out)
	{
		final float ax = in.x;
		final float ay = in.y;
		final float az = in.z;

		out.set(m00 * ax + m10 * ay + m20 * az + m30,
				m01 * ax + m11 * ay + m21 * az + m31,
				m02 * ax + m12 * ay + m22 * az + m32);
	}

	//-----------------------------------------------------------
	//]us̍쐬
	//
	//-----------------------------------------------------------
	public void Invert(Matrix v)
	{
		m00=v.m00;m01=v.m10;m02=v.m20;m03=0;
		m10=v.m01;m11=v.m11;m12=v.m21;m13=0;
		m20=v.m02;m21=v.m12;m22=v.m22;m23=0;
		m30=    0;m31=    0;m32=    0;m33=1f;
	}

	//-----------------------------------------------------------
	//ˉeϊs
	//
	//-----------------------------------------------------------
	public void Projection(float near,float far,float fov,float aspect)
	{
		final float w = aspect * (float)(Math.cos(fov * 0.5f) / Math.sin(fov * 0.5f));
		final float h = 1.0f   * (float)(Math.cos(fov * 0.5f) / Math.sin(fov * 0.5f));
		final float q = far / (far - near);
		
		Initialize();
		
		m00 = w;
		m11 = h;
		m22 = q;
		m23 = 1.0f;
		m32 = -q * near;
	}

	//-----------------------------------------------------------
	//r[ϊs̍쐬
	//
	//Vector from ...J̈ʒu
	//Vector at   ...^[Qbg̈ʒu
	//Vector wup  ...J̏
	//-----------------------------------------------------------
	public void View(Vector from,Vector at,Vector wup)
	{
		Vector view = new Vector();
		view.x = at.x - from.x;
		view.y = at.y - from.y;
		view.z = at.z - from.z;
		
		view.Normalize();
		
		float dot = wup.DotProduct(view);
		
		Vector up = new Vector();
		
		up.x = wup.x - dot * view.x;
		up.y = wup.y - dot * view.y;
		up.z = wup.z - dot * view.z;
		
		up.Normalize();
		
		Vector right = new Vector();
		right.CrossProduct(up,view);
		
		m00 = right.x;	m01 = up.x;	m02 = view.x;	m03 = 0;
		m10 = right.y;	m11 = up.y;	m12 = view.y;	m13 = 0;
		m20 = right.z;	m21 = up.z;	m22 = view.z;	m23 = 0;
		m30 = -from.DotProduct(right);
		m31 = -from.DotProduct(up   );
		m32 = -from.DotProduct(view );
		m33 =  1.0f;
	}

	static public Matrix RotationY(float r)
	{
		final float siny = (float)Math.sin(r);
		final float cosy = (float)Math.cos(r);

		//Y]
		//| cosY 0 -sinY 0|
		//|    0 1     0 0|
		//| sinY 0  cosY 0|
		//|    0 0     0 1|

		final Matrix m = new Matrix();
		m.m00 = cosy;m.m01 = 0;m.m02 =-siny;m.m03 = 0;
		m.m10 =    0;m.m11 = 1;m.m12 =    0;m.m13 = 0;
		m.m20 = siny;m.m21 = 0;m.m22 = cosy;m.m23 = 0;
		m.m30 =    0;m.m31 = 0;m.m32 =    0;m.m33 = 1;
		
		return m;
	}
}
