package raytrans;

public class Model
{	
	private rtObject[] object = null;
	private Matrix transform = null;
	
	public Vector move;
	public Vector rotate;
	public Vector scale;
	
	private float frame;
	private float begin;
	private float end;
	private float speed;
	private boolean loop;

	public Model(rtObject[] obj)
	{
		object = obj;
		transform = new Matrix();
		
		move = new Vector();
		rotate = new Vector();
		scale = new Vector();
		
		frame = 0;
		begin = 0;
		end = obj[0].getAnimationLength();
		speed = 1.0f;
		loop = true;
	}
	
	public void setTransform(Matrix m)
	{
		transform = m;
	}

	public Matrix getTransform()
	{
		return transform;
	}
	
	public Vector getPosition()
	{
		return new Vector(transform.m30,transform.m31,transform.m32);
	}
	
	public void setTexture(rtLoader loader)
	{
		//eNX`gpĂAȂZit@CǂݍłȂB
		for ( int i = 0; i < object.length; i++ )
		{
			object[i].setTexture(loader);
		}
	}
	
	public rtObject[] getObject()
	{
		return object;
	}

	public void SetAnimation(float b,float e,float s,boolean l)
	{
		if ( b < 0 )
		{
			b = 0;
		}
		if ( object.length >= 1 && (int)b >= object[0].getAnimationLength() )
		{
			b = object[0].getAnimationLength()-1;
		}
		frame = begin = b;

		if ( e < 0 )
		{
			e = 0;
		}
		if ( object.length >= 1 && (int)e >= object[0].getAnimationLength() )
		{
			e = object[0].getAnimationLength()-1;
		}
		end = e;

		speed = s;
		loop = l;
	}
	
	public void Draw(rtRender r)
	{
		Matrix m = new Matrix();

		//J̎pxɓĂ邩H
		Vector v = Vector.Subtract(r.cameraDest,r.cameraPos);
		Vector v2 = Vector.Subtract(getPosition(),r.cameraPos);
		v.Normalize();
		//ρ̃xNĝȂp
		double near = v.DotProduct(v2);
//		System.out.println("="+near);
		if ( near > 80 )
		{
			for ( int i = 0; i < object.length; i++ )
			{
				m.Initialize(object[i].getAnimation((int)frame));
				m.Mult(getTransform());
				r.SetTransform(r.TRANSFORM_WORLD,m);
				r.DrawIndexedPrimitive(object[i].getPrimitive());
			}
		}
		//Aj[V
		float frm = frame + speed;
		if ( (int)frm >= object[0].getAnimationLength() || (int)frm > end )
		{
			if ( loop )
			{
				frame = begin;
			}
			else
			{
				frame = end;
			}
		}
		else if ( frm < 0 )
		{
			if ( loop )
			{
				frame = end;
			}
			else
			{
				frame = 0;
			}
		}
		else
		{
			frame = frm;
		}
	}
	
	// _猩ړIn̕WAŕԂ
	static public float GetDirRadian(Vector eye,Vector dest)
	{
		float radian;
		
		eye.Subtract(dest);
		if (eye.x > 0.0f)
			radian = (float)(-Math.atan(eye.z/eye.x)+Math.PI/2);
		else
			radian = (float)(-Math.atan(eye.z/eye.x)-Math.PI/2);

		return radian;
	}

	// _猩ړIn̕xŕԂ
	static public float GetDirDegree(Vector eye,Vector dest)
	{
		float degree;

		degree = (float)Math.toDegrees(GetDirRadian(eye,dest));

		if ( degree < 0 )
			degree += 360;
		if ( degree >= 360 )
			degree -= 360;

		return degree;
	}
	
	//WAł͂Ȃpxő
	public float addRotateY(float degree)
	{
		rotate.y += degree;
		if ( rotate.y >= 360 )
		{
			rotate.y -= 360;
		}
		if ( rotate.y < 0 )
		{
			rotate.y += 360;
		}
		
		return (float)Math.toRadians(rotate.y);
	}
}
