package raytrans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PNGReader extends ImageReader
{
	//static
	//PNG`Header
	static private final byte[] pngHeader 
		= {(byte)0x89,(byte)0x50,(byte)0x4E,(byte)0x47,(byte)0x0D,(byte)0x0A,(byte)0x1A,(byte)0x0A};
	
	//tB^[
	static private final int PNG_FILTER_NONE    = 0;
	static private final int PNG_FILTER_SUB     = 1;
	static private final int PNG_FILTER_UP      = 2;
	static private final int PNG_FILTER_AVERAGE = 3;
	static private final int PNG_FILTER_PAETH   = 4;

	public PNGReader()
	{
		this.flush();
		
	}

	protected void flush()
	{
		super.flush();
		pletRGB = null;

	}

	public void setImage(URL url)
	{
		this.flush();

		byte[] data = URLtoByteArray(url);

		if(data != null)
		{
			ByteArrayInputStream in = new ByteArrayInputStream(data);
			readData(in);
			closeStream(in);
			in = null;
		}
	}

	public void setImage(InputStream in)
	{
		flush();

		readData(in);
	}


	public int getColorType(){
		return color_type;
	}
	public int getInterlace(){
		return interlace_method;
	}
	protected boolean readOther(InputStream in,String name,int size){
		try{
			in.skip(size+4);
		}catch(IOException e){
			return false;
		}
		return true;
	}
	protected boolean readOther(InputStream in,int name,int size){
		try{
			in.skip(size+4);
		}catch(IOException e){
			return false;
		}
		return true;
	}

	protected boolean readOther(byte[] data)
	{
		return true;
	}

	/**
	* byte[4]zintegerɂ܂
	* @param b oCgz
	* @param st Jnʒu
	* @return ǂݎinteger
	*/
	protected int byteToInt(byte[] b,int st){
		return ((b[st]&0xFF) << 24)
				| ((b[st+1]&0xFF) << 16)
				| ((b[st+2]&0xFF) << 8)
				| ( b[st+3]&0xFF);
	}

	/**
	* byte[4]zintegerɂ܂
	* Jnʒu0
	* @param b oCgz
	* @return ǂݎinteger
	*/
	protected int byteToInt(byte[] b)
	{
		return byteToInt(b,0);
	}
	
	//ȉprivate
    
	//IHDR
	
	private int bit_depth;//F
	private int color_type;//J[^Cv
	private int compression_method;//k
	private int filter_method;//tB^
	private int interlace_method;//C^[X
	
	private boolean useAlpha;
	private boolean usePalette;
	private boolean useColor;
	
	//tB^[p
	private int lineWidth;
	private int bytesPerPixel;
	
	//pbgp
	private int[] pletRGB;
	
	/**
	* PNG̉͂n߂܂B
	*/
	private void readData(InputStream in){
		checkRead(in);
		closeStream(in);
	}

	

	/*private void checkRead(InputStream in){

		if(!checkSignature(in)) return;
		
		Vector compList = new Vector();
		boolean flag = true;

		byte[] buff = new byte[8];
		
		//`Nǂ݂܂
		while(flag){
			try{
				in.read(buff);
			}catch(IOException e){
				return;
			}
			int size = byteToInt(buff,0);
			String strChunk = new String(buff,4,4);
			if(strChunk.equals("IHDR")){
				flag = readIHDR(in,size);
			}else if(strChunk.equals("IDAT")){
				flag = readIDAT(in,size,compList);
			}else if(strChunk.equals("IEND")){
				//readIEND();
				break;
			}else if(strChunk.equals("PLTE")){
				flag = readPLTE(in,size);
			}else if(strChunk.equals("tRNS")){
				flag = readTRNS(in,size);
			}else if(strChunk.equals("bKGD")){
				flag =readbKGD(in,size);
			}else{
				flag = readOther(in,strChunk,size);
			}
		}
		if(!flag){
			System.out.println("G[");
			return;
		}
		//`N͏I
		//bpp̐ݒ
		setConst();
		//
		Enumeration e = compList.elements();
		SequenceInputStream sepis = new SequenceInputStream(e);

		Inflater inflater = new Inflater();
		InflaterInputStream infis = new InflaterInputStream(sepis,inflater,bytesPerPixel*pixel.length);
	
		//쐬
		createIDAT(infis);

		closeStream(sepis);
		closeStream(infis);
	}*/

	private boolean checkRead(InputStream in){

		if(!checkSignature(in)){ return false; }
		
		Vector compList = new Vector();

		int rbytes;

		byte[] buff = new byte[8];

		int chunkSize;
		String chunkName;
		byte[] chunkData;

		byte[] chunkCRC = new byte[4];

		
		//`Nǂ݂܂
		while(true)
		{
			try{ rbytes = in.read(buff); }
			catch(IOException e) { return false; }
			if(rbytes < 8) break;

			chunkSize = byteToInt(buff,0);
			chunkName = new String(buff,4,4);
			chunkData = new byte[chunkSize];

			try{
				in.read(chunkData);
				in.read(chunkCRC);
			}
			catch(IOException e){ return false; }

			if(!checkCRC(chunkData,chunkCRC,chunkName)) return false;

			readChunk(chunkData,chunkName,compList);
		}
		//`N͏I

		//bpp̐ݒ
		setConst();
		//
		Enumeration e = compList.elements();
		SequenceInputStream sepis = new SequenceInputStream(e);

		Inflater inflater = new Inflater();
		InflaterInputStream infis = new InflaterInputStream(sepis,inflater,bytesPerPixel*pixel.length);
	
		//쐬
		createIDAT(infis);

		closeStream(sepis);
		closeStream(infis);

		return true;
	}

	private boolean checkSignature(InputStream in)
	{
		final byte[] pngHeader
		=	{(byte)0x89,
			 (byte)0x50,
			 (byte)0x4E,
			 (byte)0x47,
			 (byte)0x0D,
			 (byte)0x0A,
			 (byte)0x1A,
			 (byte)0x0A
			};

		final byte[] buff = new byte[8];
		try{
			in.read(buff);
		}catch(IOException e){
			return false;
		}
		for(int i=0;i<8;i++){
			if(buff[i] != pngHeader[i]){
				return false;
			}
		}
		return true;
	}

	private void readChunk(byte[] chunkData,String name,Vector compList)
	{

		if(name.equals("IHDR")){ readIHDR(chunkData);}
		else if(name.equals("IDAT")){ readIDAT(chunkData,compList);	}
		else if(name.equals("IEND")){ }
		else if(name.equals("PLTE")){ readPLTE(chunkData); }
		else if(name.equals("tRNS")){ readTRNS(chunkData); }
		else if(name.equals("bKGD")){ readbKGD(chunkData); }
		else{ readOther(chunkData);	}

	}

	/**
	* wb_[ǂݎ܂
	*/
	private boolean readIHDR(byte[] buff){
		System.out.println("readIHDR");
	
		//f[^
		width = byteToInt(buff,0);
		height = byteToInt(buff,4);

		pixel = new int[width * height];

		bit_depth = buff[8];
		System.out.println("bit depth: "+ bit_depth);
		
		if(bit_depth != 8){
			return false;
		}
		
		color_type = buff[9];
		System.out.println("color_type: "+ color_type);

		compression_method = buff[10];
		System.out.println("compression: "+ compression_method);

		filter_method = buff[11];
		System.out.println("filter: "+ filter_method);

		interlace_method = buff[12];
		System.out.println("interlace: "+ interlace_method);
		
		//color_type
		// 0000 0001 CfbNXJ[̎gp
		usePalette = ((color_type & 0x01) != 0);
		if(usePalette) System.out.println("Palette");
		// 0000 0010 tJ[A(0̏ꍇOCXP[)
		useColor = ((color_type  & 0x02) != 0);
		if(useColor) System.out.println("FullColor");
		else System.out.println("GrayScale");
		// 0000 0100 At@`l̎gp
		useAlpha = ((color_type & 0x04) != 0);
		if(useAlpha) System.out.println("Alpha");
		
		return true;
	}

	private boolean readIDAT(byte[] buff,Vector compList){
		System.out.println("readIDAT");
		//
		compList.addElement(new ByteArrayInputStream(buff));
		
		return true;
	}
	/**
	* pbg̓ǂݍ݂ł
	*/
	private boolean readPLTE(byte[] buff){
		System.out.println("readPLTE");

		//
		final int n = buff.length/3;
		pletRGB = new int[n];
		int p = 0;
		for(int i=0;i<n;i++){
			pletRGB[i] 
				= ((buff[p++]&0xFF) << 16)
				| ((buff[p++]&0xFF) << 8)
				| ( buff[p++]&0xFF);
		}
		
		return true;
	}
	/**
	* xł
	*/
	private boolean readTRNS(byte[] buff){
		System.out.println("readTRNS");

		final int end = buff.length;
		
		for(int i=0;i<end;i++){
			pletRGB[i] = ((buff[i]&0xFF) << 24) | (pletRGB[i] & 0x00FFFFFF);
		}
		
		return true;
	}

	private boolean readbKGD(byte[] buff)
	{
		System.out.println("readbKGD");

		/*if( ( COLOR_TYPE == GRAYSCALE ) || ( COLOR_TYPE == GRAYSCALE_ALPHA ))
		{
			int c = data[0] << 8  |  data[1] & 0xFF;
			System.out.println("BackColor : " + Integer.toHexString(c<< 16 | c<< 8 | c) );
			image.fill(0xFF << 24 | c<< 16 | c<<8 | c );
		}
		else if(( COLOR_TYPE == RGB ) || ( COLOR_TYPE == RGB_ALPHA ))
		{
			int r = data[0] & 0xFF << 8 |  data[1] & 0xFF;
			int g = data[2] & 0xFF << 8 |  data[3] & 0xFF;
			int b = data[4] & 0xFF << 8 |  data[5] & 0xFF;
			System.out.println("BackColor :" + Integer.toHexString(r << 16 | g << 8 | b));
			image.fill(0xFF << 24 | r << 16 | g<<8 | b);
		}*/

		return true;

	}

	private boolean checkCRC(byte[] buff,byte[] crcBuff,String chunkName)
	{
		CRC32 crc = new CRC32();
		crc.update(chunkName.getBytes());
		crc.update(buff,0,buff.length);
		if(byteToInt(crcBuff) != (int)crc.getValue()){
			System.out.println("CRCG[");
			return false;
		}
		else
		{
			System.out.println("CRC OK");
		}

		return true;
	}

	/**
	* PNG̏I܂
	*/
/*	private void readIEND() throws IOException{
		CRC32 crc = new CRC32();
		crc.update("IEND".getBytes());
		if(readInt()!=(int)crc.getValue()){
			throw new IOException("CRC Errer");
		}
		return;
	}*/
	
	/**
	* f[^͂ł̕KvȐݒ܂B
	*/
	private void setConst(){
		if(usePalette){
			bytesPerPixel = 1;
		}else{
			if(useColor){
				bytesPerPixel = 3;
			}else{
				bytesPerPixel = 1;
			}
			if(useAlpha){
				bytesPerPixel++;
			}
		}
		lineWidth = bytesPerPixel*width;
	}

	/**
	* Lf[^̉͂ł
	*/
	private void createIDAT(InputStream in){
		byte[] buffPixel;
		//DIB`̃oCgɂ܂B
		if(interlace_method==1){
			buffPixel = normalizeInterlace(in);
		}else{
			buffPixel = normalize(in);
		}
		closeStream(in);
		
		if(buffPixel == null){
			return;
		}
		
		if(usePalette){
			setPixelPlet(buffPixel);
		}
		else
		{
			if(useColor)
			{
				setPixelNormal(buffPixel);
			}
			else
			{
				setPixelGray(buffPixel);
			}
		}
		buffPixel = null;
	}
	private byte[] normalizeInterlace(InputStream in){

		System.out.println("normalizeInterlace");

		byte[] buffPixel = new byte[lineWidth*height];

		final int[] startX = {0,4,0,2,0,1,0};
		final int[] startY = {0,0,4,0,2,0,1};
		final int[] stepX  = {8,8,4,4,2,2,1};
		final int[] stepY  = {8,8,8,4,4,2,2};

		int widthTemp = width;
		int heightTemp = height;
		int n = 0;
		int size = 0;
		
		for(int k=0;k<7;k++){
			//摜̃TCY߂
			width = (widthTemp+stepX[k]-1-startX[k])/stepX[k];
			height = (heightTemp+stepY[k]-1-startY[k])/stepY[k];
			lineWidth = bytesPerPixel*width;
			byte[] temp = normalize(in);
			//ȉ摜̍쐬
			int p = 0;
			for(int j=startY[k];j<heightTemp;j+=stepY[k]){
				int jw = j*widthTemp*bytesPerPixel;
				for(int i=startX[k]*bytesPerPixel;i<widthTemp*bytesPerPixel;i+=stepX[k]*bytesPerPixel){
					for(int m=0;m<bytesPerPixel;m++){
						buffPixel[i+jw+m] = temp[p+m];
					}
					p += bytesPerPixel;
				}
			}
		}
		width = widthTemp;
		height = heightTemp;
		
		return buffPixel;
	}
	
	private byte[] normalize(InputStream in){

		System.out.println("normalize");

		byte[] buffPixel = new byte[lineWidth*height];

		byte[] raw = new byte[lineWidth];
		byte[] prior = new byte[lineWidth];
		byte[] swap;

		int pixelPoint = 0;
		int filter;
		
		for(int j=0;j<height;j++){
			//O̍s̕ۑ
			swap = prior;
			prior = raw;
			raw = swap;
			//ǂݍ
			try{
				filter = in.read();
				in.read(raw);
			}catch(IOException e){
				e.printStackTrace();
				return null;
			}
			
			//tB^O
			switch(filter){
				case PNG_FILTER_NONE:
					break;
				case PNG_FILTER_SUB:
					antiSub(raw);
					break;
				case PNG_FILTER_UP:
					antiUp(raw,prior);
					break;
				case PNG_FILTER_AVERAGE:
					antiAverage(raw,prior);
					break;
				case PNG_FILTER_PAETH:
					antiPaeth(raw,prior);
					break;
			}
			//tB^Õf[^̏
			System.arraycopy(raw,0,buffPixel,pixelPoint,lineWidth);
			pixelPoint += lineWidth;
		}
		
		raw = null;
		prior = null;
		
		return buffPixel;
	}
	
	private void setPixelPlet(byte[] buffPixel){
		System.out.println("setPixelPlet");

		int wh = width*height;

		//vAčl
		//ẍɂ
		for(int i=0;i<wh;i++){
			pixel[i] = (pletRGB[buffPixel[i]&0xFF] | 0xff000000);

		}
	}

	private void setPixelNormal(byte[] buffPixel){
		System.out.println("setPixelNormal");

		int wh = width*height;
		int p = 0;
		
		if(useAlpha)
		{
			for(int i=0;i<wh;i++){
				pixel[i] =
					   ((buffPixel[p++]&0xFF) << 16)
					|  ((buffPixel[p++]&0xFF) << 8)
					|  ( buffPixel[p++]&0xFF)
					|  ((buffPixel[p++]&0xFF) << 24);
			}
		}
		else
		{
			for(int i=0;i<wh;i++)
			{
				pixel[i] =
					   ((buffPixel[p++]&0xFF) << 16)
					|  ((buffPixel[p++]&0xFF) << 8)
					|  ( buffPixel[p++]&0xFF)
					|  0xFF000000;

			}
		}
	}
	private void setPixelGray(byte[] buffPixel){
		System.out.println("setPixelGray");

		int wh = width*height;

		int b;
		
		if(useAlpha){
			int p = 0;
			for(int i=0;i<wh;i++){
				b = buffPixel[p++]&0xFF;
				pixel[i] = (b << 16) | (b << 8) | b
					| ((buffPixel[p++]&0xFF) << 24);
			}
		}else{
			for(int i=0;i<wh;i++){
				b = buffPixel[i]&0xFF;
				pixel[i] = 0xFF<<24 | (b << 16) | (b << 8) | b;
			}
		}
	}
	/**
	* SubtB^[
	*/
	private void antiSub(byte[] bRaw)
	{
		for(int j=bytesPerPixel;j<lineWidth;j++){
			bRaw[j] = (byte)(bRaw[j] + bRaw[j-bytesPerPixel]);
		}
	}
	/**
	* UptB^[
	*/
	private void antiUp(byte[] bRaw, byte[] bPrior)
	{
		for(int j=0;j<lineWidth;j++){
			bRaw[j] = (byte)(bRaw[j] + bPrior[j]);
		}
	}
	/**
	* AveragetB^[
	*/
	private void antiAverage(byte[] bRaw, byte[] bPrior)
	{
		for(int j=0;j<bytesPerPixel;j++){
			bRaw[j] = (byte)( (bRaw[j]&0xFF) + (bPrior[j]&0xFF)/2 );
		}
		for(int j=bytesPerPixel;j<lineWidth;j++){
			bRaw[j] = (byte)( (bRaw[j]&0xFF) + ((bRaw[j-bytesPerPixel]&0xFF)+(bPrior[j]&0xFF))/2 );
		}
	}
	/**
	* PaethtB^[
	*/
	private void antiPaeth(byte[] bRaw, byte[] bPrior){
		for(int j=0;j<bytesPerPixel;j++){
			bRaw[j] = (byte)( (bRaw[j]&0xFF) + paethPredictor(0,bPrior[j]&0xFF,0) );
		}
		for(int j=bytesPerPixel;j<lineWidth;j++){
			bRaw[j] = (byte)( (bRaw[j]&0xFF) + paethPredictor(bRaw[j-bytesPerPixel]&0xFF,bPrior[j]&0xFF,bPrior[j-bytesPerPixel]&0xFF) );
		}
	/*	int raw, priorPixel, priorRow, priorRowPixel;
		for (int i = 0; i < bytesPerPixel; i++) {
			raw = bRaw[i] & 0xff;
			priorRow = bPrior[i] & 0xff;
			bRaw[i] = (byte)(raw + priorRow);
		}
		for (int i = bytesPerPixel; i < lineWidth; i++) {
			raw = bRaw[i] & 0xff;
			priorPixel = bRaw[i - bytesPerPixel] & 0xff;
			priorRow = bPrior[i] & 0xff;
			priorRowPixel = bPrior[i - bytesPerPixel] & 0xff;

			bRaw[i] = (byte)(raw + paethPredictor(priorPixel,priorRow,priorRowPixel));
		}*/
	}
	/**
	* PaethASY
	*/
	private int paethPredictor(int a,int b,int c){
		//a = left, b = above, c = upper left
		int p = a + b - c;	//initial estimate
		int pa = abs(p - a);  //distances to a, b, c
		int pb = abs(p - b);
		int pc = abs(p - c);
		if((pa <= pb) && (pa <= pc)){
			return a;
		}else if(pb <= pc){
			return b;
		}else{
			return c;
		}
	}

	private int abs(int x){
		return (x < 0) ? -x : x;
	}
}
