package raytrans;

//-----------------------------------------------------------
//xNgNX
//
//-----------------------------------------------------------
public class Vector
{
	//-----------------------------------------------------------
	//oϐ
	//
	//-----------------------------------------------------------
	public float x;
	public float y;
	public float z;

	//-----------------------------------------------------------
	//RXgN^
	//
	//-----------------------------------------------------------
	public Vector(){}

	public Vector(float vx,float vy,float vz)
	{
		set(vx,vy,vz);
	}

	public Vector(Vector v)
	{
		set(v);
	}
	
	//-----------------------------------------------------------
	//xNg̏
	//
	//Vector v ...Rs[xNg
	//-----------------------------------------------------------
	public void Initialize(Vector v)
	{
		set(v.x,v.y,v.z);
	}

	public final void set(float vx,float vy,float vz)
	{
		this.x = vx;
		this.y = vy;
		this.z = vz;
	}

	public final void set(Vector v)
	{
		set(v.x,v.y,v.z);
	}

	//-----------------------------------------------------------
	//Z
	//
	//-----------------------------------------------------------
	public void Add(Vector v)
	{
		x += v.x;
		y += v.y;
		z += v.z;
	}

	//-----------------------------------------------------------
	//Z
	//-----------------------------------------------------------
	public void Subtract(Vector v)
	{
		x -= v.x;
		y -= v.y;
		z -= v.z;
	}

	//-----------------------------------------------------------
	//Z
	//-----------------------------------------------------------
	static public Vector Subtract(Vector v1,Vector v2)
	{
		Vector v = new Vector();

		v.x = v1.x - v2.x;
		v.y = v1.y - v2.y;
		v.z = v1.z - v2.z;

		return v;
	}

	//-----------------------------------------------------------
	//PʃxNg
	//
	//-----------------------------------------------------------
	public void Normalize()
	{
		//PʃxNgƂ͒P̃xNĝƁB
		final float _l = (float)(1.0f / floatSqrt(x*x + y*y + z*z));
		x *= _l;
		y *= _l;
		z *= _l;
	}

	//float̕Bx͗B
	final private float floatSqrt(float f)
	{
		float s,last;

  		if(f<=0.0f) return 0.0f;

  		if (f > 1) s = f;  else s = 1;

  		do {
    		last = s;
    		s = (f / s + s) * 0.5f;
  		} while (s < last);

 		return last;
	}


	//-----------------------------------------------------------
	//
	//
	//-----------------------------------------------------------
	public float DotProduct(Vector v)
	{
		//ςƃxNgƃxNĝȂpx܂B
		return (x * v.x + y * v.y + z * v.z);
	}

	//-----------------------------------------------------------
	//O
	//
	//-----------------------------------------------------------
	public void CrossProduct(Vector a,Vector b)
	{
		//Oς͎ɖʂɐȖ@xNg߂邽߂ɎgpB
		crossProduct(a.x,a.y,a.z,b.x,b.y,b.z);
	}

	private void crossProduct(float ax,float ay,float az,
							  float bx,float by,float bz)
	{
		set(ay * bz - az * by,az * bx - ax * bz,ax * by - ay * bx);
		//x = ay * bz - az * by;
		//y = az * bx - ax * bz;
		//z = ax * by - ay * bx;
	}

	public void calcNormal(Vector v1,Vector v2,Vector v3)
	{

		// ax = v1.x - v2.x;
		// ay = v1.y - v2.y;
		// az = v1.z - v2.z;
		// bx = v1.x - v3.x;
		// by = v1.y - v3.y;
		// bz = v1.z - v3.z;

		//OςB
		crossProduct(v1.x - v2.x,v1.y - v2.y,v1.z - v2.z,
					 v1.x - v3.x,v1.y - v3.y,v1.z - v3.z);
		
		//K
		Normalize();
	}

	//-----------------------------------------------------------
	//xNg𔽓]
	//
	//-----------------------------------------------------------
	public void Invert()
	{
		set(-x,-y,-z);
	}

}
