package raytrans;

public class rtColor
{
	int r;
	int g;
	int b;
	int a;

	public rtColor()
	{
		set(0,0,0,0);
	}

	public rtColor(int r,int g,int b)
	{
		set(r,g,b);
	}

	public rtColor(rtColor c)
	{
		set(c);
	}

	public rtColor(int r,int g,int b,int a)
	{
		set(r,g,b,a);
	}

	public rtColor(double dr,double dg,double db,double da)
	{
		set(dr,dg,db,da);
	}

	public rtColor(double dr,double dg,double db)
	{
		set(dr,dg,db);
	}

	public void set(float fr,float fg,float fb,float fa)
	{
		int sr,sg,sb,sa;

		if(fr > 0)
		{
			sr = (int)(fr * 255); 
			if(sr > 255) sr = 255;
		}
		else sr = 0;

		if(fg > 0)
		{
			sg = (int)(fg * 255); 
			if(sg > 255) sg = 255;
		}
		else sg = 0;
		
		if(fb > 0)
		{
			sb = (int)(fb * 255); 
			if(sb > 255) sb = 255;
		}
		else sb = 0;

		if(fa > 0)
		{
			sa = (int)(fa * 255); 
			if(sa > 255) sa = 255;
		}
		else sa = 0;

		set(sr,sg,sb,sa);

	}

	public void set(float fr,float fg,float fb)
	{
		set(fr,fg,fb,1.0f);
	}

	public final void set(double dr,double dg,double db,double da)
	{
		set((float)dr,(float)dg,(float)db,(float)da);
	}

	public void set(double dr,double dg,double db)
	{
		set((float)dr,(float)dg,(float)db);
	}

	public void set(int r,int g,int b)
	{
		set(r,g,b,255);
	}

	public final void set(int r,int g,int b,int a)
	{
		this.r = r;
		this.g = g;
		this.b = b;
		this.a = a;
	}

	public final void set(rtColor c)
	{
		set(c.r,c.g,c.b,c.a);
	}

	public final String printColor()
	{
		return "R "+r+",G "+g+",B "+b+",A "+a;
	}
}