package raytrans;

public class rtImageTranscoder
{
	private int TransMode;

	static final private int PIC_UP_RED    =  1;
	static final private int PIC_UP_GREEN  =  2;
	static final private int PIC_UP_BLUE   =  3;
	static final private int PIC_OUT_RED   =  4;
	static final private int PIC_OUT_GREEN =  5;
	static final private int PIC_OUT_BLUE  =  6;
	static final private int NEGA          =  7;
	static final private int MONO          =  8;
	static final private int EMBOSS        =  9;
	static final private int DEFAULT       =  0;

	static final int NUM_OF_COLOR = 10;

	public rtImageTranscoder()
	{
		TransMode = DEFAULT;
	}

	public final void TranscodeImage(rtSurface image)
	{

		switch(TransMode)
		{
			case PIC_UP_RED:
				picUpRed(image);
				break;
			case PIC_UP_GREEN:
				picUpGreen(image);
				break;
			case PIC_UP_BLUE:
				picUpBlue(image);
				break;
			case PIC_OUT_RED:
				picOutRed(image);
				break;
			case PIC_OUT_GREEN:
				picOutGreen(image);
				break;
			case PIC_OUT_BLUE:
				picOutBlue(image);
				break;
			case NEGA:
				nega(image);
				break;
			case MONO:
				mono(image);
				break;
			case EMBOSS:
				emboss(image);
				break;
			default:
				break;
		}
	}

	//Ԃ̂ݎo
	static final private void picUpRed(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xffff0000);
		}
	}

	static final private void picUpGreen(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xff00ff00);
		}
	}

	static final private void picUpBlue(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xff0000ff);
		}
	}

	static final private void picOutRed(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xff00ffff);
		}
	}

	static final private void picOutGreen(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xffff00ff);
		}
	}

	static final private void picOutBlue(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = (buf[i] & 0xffffff00);
		}
	}

	public final void setMode(int i)
	{
		TransMode = i % NUM_OF_COLOR;
	}

	public final int getMode()
	{
		return TransMode;
	}

	public final void changeMode()
	{
		TransMode++;
		TransMode %= NUM_OF_COLOR;
	}

	public static final void nega(rtSurface image)
	{
		int[] buf = image.getBuffer();

		for(int i=0;i<buf.length;i++)
		{
			buf[i] = ( 0xff000000 | (~(buf[i] & 0xffffff)) );
		}
	}

	public static final void mono(rtSurface image)
	{
		int[] buf = image.getBuffer();
		int br,bg,bb;
		int c;

		for(int i=0;i<buf.length;i++)
		{
			br = ( buf[i] & 0xff0000 ) >> 16;
			bg = ( buf[i] & 0x00ff00 ) >> 8;
			bb = ( buf[i] & 0x0000ff );
			c = (br + bg + bb) / 3;

			buf[i] = ( 0xff000000 | c << 16 | c << 8 | c );
		}

	}

	public static final void emboss(rtSurface image)
	{
		int[] buf = image.getBuffer();
		int[] tmp = new int[buf.length];

		for(int i=0;i<buf.length;i++)
		{
			tmp[i] = (~(buf[i] & 0xffffff));
		}

		int w = image.getWidth();
		int h = image.getHeight();

		int br,bg,bb;
		int tr,tg,tb;

		int offset;

		for(int i=0;i<h;i++)
		{
			offset = i * w;

			for(int j=0;j<w;j++)
			{
				br = ( buf[offset + j] & 0xff0000 ) >> 16;
				bg = ( buf[offset + j] & 0x00ff00 ) >> 8;
				bb = ( buf[offset + j] & 0x0000ff );

				if(i < (h-1) && j < (w-1) )
				{
					tr = ( buf[offset + w + j + 1] & 0xff0000 ) >> 16;
					tg = ( buf[offset + w + j + 1] & 0x00ff00 ) >> 8;
					tb = ( buf[offset + w + j + 1] & 0x0000ff );
				}
				else
				{
					tr = tg = tb = 128;
				}

				br = br - tr + 128;
				bg = bg - tg + 128;
				bb = bb - tb + 128;
				if(br > 255) br = 255;
				if(bg > 255) bg = 255;
				if(bb > 255) bb = 255;
				if(br <   0) br = 0;
				if(bg <   0) bg = 0;
				if(bb <   0) bb = 0;

				buf[offset + j] = 
				( 0xff000000 | br << 16 | bg << 8 | bb );
			}
		}

	}

}