package raytrans;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class rtLoader
{
	private Applet rtApplet;
	
	private URL path;
	
	private rtObject[] object = null;

	private byte	scBuf[] = null;		// t@Cǂݍ݃obt@
	private int		scSize;				// obt@LTCY
	private int		scX;				// obt@̓ǂݍ݈ʒu

	private String BackImageName = null;	//wi摜̖O

	public rtLoader(Applet a)
	{
		init(a);
	}
	
	public void init(Applet a)
	{		
		rtApplet = a;
		path = rtApplet.getCodeBase();
		
		scBuf	= new byte[1024];
		scX		= scSize = 0;

		object = new rtObject[0];
	}
/*
	//-----------------------------------------------------
	//init\bhœǂݏoA
	//p[^擾
	//-----------------------------------------------------
	public void getHTMLParameter(rtRender render)
	{
		setMqoFileName("Knight.mqo");
	 	render.setBackColor(0x484848);
		String s;

		//ftHgݒ
		mApplet.colLine	= new Color(50,50,50);
		mApplet.motion_speed = 3;

		//wi摜̃t@C擾
		if ((s = mApplet.getParameter("bgimage"))!= null)
		{
			setBackImageName(s);
		}

		//mqot@C̃t@C擾
		if ((s = mApplet.getParameter("mqofile")) != null)
		{
			setMqoFileName(s);
		}

		//Zipt@C̃t@C擾B
		if ((s = mApplet.getParameter("zipfile")) != null)
		{
			setZipFileName(s);
		}

		//wiF
		if ((s = mApplet.getParameter("bgcolor"))!= null)
			render.setBackColor(Integer.parseInt(s,16));
		else
		 	render.setBackColor(0xf8f8f8);

		//̐F
		if ((s = mApplet.getParameter("linecolor"))!= null)
		mApplet.colLine	= new Color(Integer.parseInt(s,16));
			
		//wiIuWFNg̃[Vx
		if ((s = mApplet.getParameter("motionspeed"))!= null)
		mApplet.motion_speed = Integer.parseInt(s);
	}
*/
	//wi摜̖OĂꍇAwi摜擾
	public Image getBackImage(MediaTracker tracker)
	{
		if(BackImageName == null) return null;
		return getImage(BackImageName,tracker);
	}

	public Image getBackImage(Applet applet)
	{
		MediaTracker tracker = new MediaTracker(applet);
	
		if(BackImageName == null) return null;
		return getImage(BackImageName,tracker);
	}

	public rtSurface createRTSurface(String ImageName)
	{
		rtSurface surface = null;

		if(ImageName != null)
		{
			try
			{

				URL url = new URL(path + ImageName);

				if(ImageName.toLowerCase().endsWith("png"))
				{
					System.out.println(ImageName);

					ImageReader reader = new PNGReader();
					reader.setImage(url);
					surface =
						new rtSurface(reader.getWidth(),reader.getHeight(),reader.getPixel());
				}
				else if(ImageName.toLowerCase().endsWith("bmp"))
				{
					System.out.println(ImageName);

					ImageReader reader = new BMPReader();
					reader.setImage(url);
					surface =
						new rtSurface(reader.getWidth(),reader.getHeight(),reader.getPixel());
				}
				else
				{
					MediaTracker tracker = new MediaTracker(rtApplet);
					Image image = getImage(ImageName,tracker);
					surface =
						new rtSurface(image);

				}

			}
			catch(MalformedURLException e)
			{
				e.printStackTrace();
			}
		}

		return surface;
	}

	//w肳ꂽ摜擾B
	public Image getImage(String ImageName,MediaTracker tracker)
	{
		Image image = null;
		URL url;
		InputStream in = null;

		try
		{
			url = new URL(path + ImageName);
			in = url.openConnection().getInputStream();
			image = rtApplet.getImage(url);
			System.out.println("load "+ ImageName);
			tracker.addImage(image,0);
			tracker.waitForAll();
		}
		catch (MalformedURLException e)
		{
			System.out.print("MalformedURLException ");
			System.out.println(ImageName + " is not found");
		}
		catch (UnknownServiceException e)
		{
			System.out.print("UnknownServiceException ");
			System.out.println(ImageName + " is not found");
		}
		catch (IOException e )
		{
			System.out.print("IOException ");
			System.out.println(ImageName + " is not found");
		}
		catch (InterruptedException e)
		{
			System.out.print("InterruptedException ");
			System.out.println(ImageName + " is not load");
		}
		catch (Exception e)
		{
			System.out.println(ImageName + " is not load");
			// ErrorHandling Here
			// java.net.UnknownHostException:
			// java.io.FileNotFoundException:
			// java.net.SocketException: Connection refused 
			// etc̃G[NȂOK
		}
		finally
		{
   	 		if(in != null)CloseStream(in);
    	}
		return image;
	}

	public Image getImage(String ImageName)
	{
		MediaTracker tracker = new MediaTracker(rtApplet);

		return getImage(ImageName,tracker);
	}

	public void setBackImageName(String s)
	{
		BackImageName = s;
	}

	public String getBackImageName()
	{
		return BackImageName;
	}

	//----------------------------------------------------------------
	//Xg[JAf[^ǂݍށB
	//
	//----------------------------------------------------------------
	public rtObject[] LoadMQOFile(String fileName)
	{
		LoadFile(fileName+".mqo",fileName+".zip");
		
		return object;
	}
	
	public rtObject[] LoadMQSFile(String fileName)
	{
		LoadFile(fileName+".mqs",fileName+".zip");
		
		return object;
	}

	public void LoadFile(String MqFileName,String ZipFileName)
	{
		InputStream         in     = null;
		BufferedInputStream bufIn  = null;
			
		if(ZipFileName != null)
		{
			ZipInputStream zipin  = null;
			try{

				URL mURL = new URL(path + ZipFileName);

				in    = mURL.openConnection().getInputStream();
        		bufIn = new BufferedInputStream(in);
				zipin = new ZipInputStream(bufIn);

				ZipEntry zipEntry;

 				while((zipEntry = zipin.getNextEntry()) != null)
				{

					if(zipEntry.getName().endsWith(MqFileName))
					{
						System.out.println("load " + MqFileName + " in "+ ZipFileName);
						mqoRead(zipin);
					}
				}
			}
			catch(MalformedURLException e)
			{
				System.out.println("can't load" + MqFileName + " in "+ ZipFileName);
				System.out.println("MalformedURLException");
			}
			catch(IOException e)
			{
				System.out.println("can't load" + MqFileName + " in "+ ZipFileName);
				System.out.println("IOException");
			}
			finally
			{
				CloseStream(zipin);
        	}
		}

		//ZIPt@C̓ǂݍ݂sꍇB
		if(object.length == 0)
		{

			DataInputStream dataIn = null;

			try{
				URL mURL = new URL(path + MqFileName);
				//Xg[擾
				in    = mURL.openConnection().getInputStream();
        		bufIn = new BufferedInputStream(in);
				dataIn = new DataInputStream(bufIn);
				System.out.println("load " + MqFileName);
				mqoRead(dataIn);
			}
			catch(MalformedURLException e)
			{
				System.out.println("can't load " + MqFileName);
				System.out.println("MalformedURLException");
				e.printStackTrace();
			}
			catch(IOException e)
			{
				System.out.println("can't load " + MqFileName);
				System.out.println("IOException");
				e.printStackTrace();

			}
			finally
			{
				CloseStream(dataIn);
        	}
		}
		CloseStream(bufIn);
		CloseStream(in);

		bufIn = null;
		in = null;
   }

	/*/Zipt@CC[WoB
	//͎gpȂ
	Image extractImageFromZip(ZipInputStream zipIn){
    	Image image = null;
    	byte buffer[] = new byte[1024];
  		int nBytesRead;
 		ByteArrayOutputStream imageData = null;
 		try{
		    imageData = new ByteArrayOutputStream();
  			while((nBytesRead = zipIn.read(buffer)) != -1)
			{
   				imageData.write(buffer,0,nBytesRead);
  		    }
 			image = getToolkit().createImage(imageData.toByteArray());
        }
		catch(IOException e){}
		finally{
            try{
                imageData.close();
            }
			catch(IOException e){}
			catch(NullPointerException e){}
        }
        return image;
    }*/

	private void CloseStream(InputStream in)
	{
		try
		{
                in.close();
        }
		catch(IOException e){}
		catch(NullPointerException e){}
	}
	
	//------------------------------------------------------
	// t@C1Pǂݍފ֐
	// mqoRead()Ă΂
	// P̓Xy[X^uŋ؂̂Ƃ
	//------------------------------------------------------
	private String searchNextWord(FilterInputStream mStream)
	{
		StringBuffer sb = new StringBuffer();
		boolean readSpace = false;
		int readFlag = 0;
		
		try
		{
			while(true)
			{
				// obt@ׂēǂݍ
				if ( scX >= scSize )
				{
					scSize = mStream.read(scBuf);
					
					if ( scSize == -1 )
					{
						//@ǂݍݕȂreadI
						//@΂̕Ԃ
						if (sb.length() == 0) return null;
						break;
					}

					scX=0; //J[\[
				}
				else if((char)scBuf[scX] == '"')
				{
					readSpace = !readSpace;

					sb.append((char)scBuf[scX]);
					scX++;
					readFlag = 1;
				}
				//؂蕶
				else if ( (char)scBuf[scX] == '\t' || scBuf[scX] == 10 || scBuf[scX] == 13)
				{
					// 󔒕ǂݍݒȂ玟ǂݍ
					// 󔒈ȊOǂݍݒȂPǂݍ݊
					if (readFlag == 0) scX++; else break;
				}
				else if( ( (char)scBuf[scX] == ' ' ) && (!readSpace) )
				{
					if (readFlag == 0) scX++; else break;
				}
				//ʂ̕
				//readSpacetrueȂ΁AXy[X
				else
				{
					sb.append((char)scBuf[scX]);
					scX++;
					readFlag = 1;
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
		return sb.toString();
	}

	// MQO`̃t@Cǂݍ
	private void mqoRead(FilterInputStream mStream)
	{
		int p= 0;
		String s;

		Material[] mat = null;
		
		while ((s = searchNextWord(mStream)) != null)
		{
			if (s.equals("Scene"))
			{
				readScene(mStream);
			}
			else if (s.equals("Material"))
			{
				mat = readMaterial(mStream);
			}
			else if (s.equals("Object"))
			{
				rtObject obj = null;
				obj = readObject(mStream);
				calcGuraud(obj.vertex,obj.face);
				addObject(convertObject(obj,mat));
			}
		}
	}

	private void readScene(FilterInputStream mStream)
	{
		String s;

		System.out.println("readScene is started.");

		while ((s = searchNextWord(mStream)) != null)
		{
			if (s.equals("}")) break;
		}
	}

	private rtObject readObject(FilterInputStream mStream)
	{
		System.out.println("readObject is started.");

		String s;

		rtObject obj = new rtObject();

		obj.name = searchNextWord(mStream);

		System.out.println("reading "+ obj.name);

		while ((s = searchNextWord(mStream)) != null)
		{
			if (s.equals("{")) {}
			else if (s.equals("}")) { break; }
			else if (s.equals("vertex"))
			{
				obj.vertex = readVertex(mStream);
			}
			else if (s.equals("face"))
			{
				 obj.face = readFace(mStream);
			}
			else if (s.equals("animation"))
			{
				 obj.animation = readAnimation(mStream);
			}

		}

		return obj;
	}


	private Vertex[] readVertex(FilterInputStream mStream)
	{
		System.out.println("readVertex is started.");

		String s;

		final Vertex[] vertex = new Vertex[Integer.parseInt(searchNextWord(mStream))];

		float x,y,z;

		//XLbv
		s = searchNextWord(mStream);

		for(int i=0;i<vertex.length;i++)
		{
			s = searchNextWord(mStream);
			x = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			y = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			z = Float.valueOf(s).floatValue();

			vertex[i] = new Vertex(x,y,-z);
		}

		//XLbv
		s = searchNextWord(mStream);

		return vertex;
	}

	//Face`N̓ǂݍ
	private Face[] readFace(FilterInputStream mStream)
	{
		System.out.println("readFace is started.");

		int	face_i;
		String s;
		int len;
		
		//ʂ̐擾
		int volume = Integer.parseInt(searchNextWord(mStream));

		final Face[] face = new Face[volume];

		s = searchNextWord(mStream);
		s = searchNextWord(mStream);

		//ʂ̐JԂ
		for(face_i=0;face_i<volume;face_i++)
		{
			face[face_i] = new Face();
			
			//R͂S
			len = Integer.parseInt(s);
			face[face_i].V = new int[len];

			s = searchNextWord(mStream);

			//_CfbNX
			if(s.startsWith("V("))
			{
				// "V`N̓ǂݍ݁B
				switch ( len )
				{
				case 2:
					break;
				case 3:
					face[face_i].V[2] = Integer.parseInt(s.substring(2));
					s = searchNextWord(mStream);
					face[face_i].V[1] = Integer.parseInt(s);
					s = searchNextWord(mStream);
					face[face_i].V[0] = Integer.parseInt(s.substring(0, s.length()-1));
					break;
				case 4:
					face[face_i].V[3] = Integer.parseInt(s.substring(2));
					s = searchNextWord(mStream);
					face[face_i].V[2] = Integer.parseInt(s);
					s = searchNextWord(mStream);
					face[face_i].V[1] = Integer.parseInt(s);
					s = searchNextWord(mStream);
					face[face_i].V[0] = Integer.parseInt(s.substring(0, s.length()-1));
					break;
				}

				s = searchNextWord(mStream);
			}

			//ގCfbNX
			//݂Ȃ΃ftHg̍ގݒ肷
			if (s.startsWith("M("))
			{
				face[face_i].M = Integer.parseInt(s.substring(2, s.length()-1));

				s = searchNextWord(mStream);
			}

			if(s.startsWith("UV("))
			{
				//Op|S͂U l_|S͂W
				int len2 = len << 1;
				face[face_i].UV = new int[len2];
				
				switch ( len2 )
				{
				case 6:
					face[face_i].UV[4] =
						(int)(Double.valueOf(s.substring(3)).doubleValue()*65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[5] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[2] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[3] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[0] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					break;
				case 8:
					face[face_i].UV[6] =
						(int)(Double.valueOf(s.substring(3)).doubleValue()*65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[7] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[4] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[5] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[2] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[3] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					s = searchNextWord(mStream);
					face[face_i].UV[0] = 
						(int)(Double.valueOf(s).doubleValue() * 65535.0);
					break;
				}

				s = searchNextWord(mStream);
				face[face_i].UV[1] =
					(int)(Double.valueOf(s.substring(0, s.length()-1)).doubleValue()*65535.0);

				s = searchNextWord(mStream);
			}
		}

		return face;
	}

	private Matrix[] readAnimation(FilterInputStream mStream)
	{
		System.out.println("readAnimation is started.");

		String s;

		final Matrix[] a = new Matrix[Integer.parseInt(searchNextWord(mStream))];

		//XLbv
		s = searchNextWord(mStream);

		for(int i = 0; i < a.length; i++ )
		{
			a[i] = new Matrix();

			s = searchNextWord(mStream);
			a[i].m00 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m01 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m02 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m03 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m10 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m11 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m12 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m13 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m20 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m21 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m22 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m23 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m30 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m31 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m32 = Float.valueOf(s).floatValue();
			s = searchNextWord(mStream);
			a[i].m33 = Float.valueOf(s).floatValue();
		}

		//XLbv
		s = searchNextWord(mStream);

//		System.out.println(a[0].m00+" "+a[0].m01+" "+a[0].m02+" "+a[0].m03+" "+a[0].m10+" "+a[0].m11+" "+a[0].m12+" "+a[0].m13+" "+a[0].m20+" "+a[0].m21+" "+a[0].m22+" "+a[0].m23+" "+a[0].m30+" "+a[0].m31+" "+a[0].m32+" "+a[0].m33+" ");
		
		return a;
	}
	
	private Material[] readMaterial(FilterInputStream mStream)
	{
		System.out.println("readMaterial is started.");

		//f[^̍ގ+ftHg
		final Material[] mat = new Material[Integer.parseInt(searchNextWord(mStream)) + 1];

		mat[mat.length-1] = new Material("default");

		mat[mat.length-1].set(0.5,0.5,0.5,1);

		int	mat_i = 0;
		String s;
		double dr,dg,db,da;

		while ((s = searchNextWord(mStream)) != null)
		{
			if (s.equals("{")){}
			else if (s.equals("}")){ break; }
			else if (s.startsWith("col("))
			{
				//
				dr = Double.valueOf(s.substring(4)).doubleValue();
				
				//
				s = searchNextWord(mStream);
				dg = Double.valueOf(s).doubleValue();

				//
				s = searchNextWord(mStream);
				db = Double.valueOf(s).doubleValue();

				//x
				s = searchNextWord(mStream);
				da = Double.valueOf(s.substring(0, s.length()-1)).doubleValue();

				mat[mat_i].set(dr,dg,db,da);

				System.out.println(mat[mat_i].getName()+":"+mat[mat_i].getColor().printColor());
			
			}
			else if (s.startsWith("amb("))
			{
				mat[mat_i].Amb = (int)(Double.valueOf(s.substring(4,s.length()-1)).doubleValue()*255.9);
			}
			else if (s.startsWith("emi("))
			{
				mat[mat_i].Emi = (int)(Double.valueOf(s.substring(4,s.length()-1)).doubleValue()*255.9);
			}
			else if (s.startsWith("dif("))
			{
				mat[mat_i].D = (int)(Double.valueOf(s.substring(4,s.length()-1)).doubleValue()*255.9);
			}
			else if (s.startsWith("spc("))
			{
				mat[mat_i].S = (int)(Double.valueOf(s.substring(4,s.length()-1)).doubleValue()*255.9);
			}
			else if (s.startsWith("power("))
			{
				mat[mat_i].PW = (float)Double.valueOf(s.substring(6,s.length()-1)).doubleValue();
				mat_i++;
			}
			else if (s.startsWith("tex("))
			{
				//eNX`
				mat[mat_i-1].setTextureName(getWord(s));
			}
			else if(s.startsWith("aplane("))
			{
				mat[mat_i-1].setAlphaName(getWord(s));
			}
			//}eA
			else if(0 == s.indexOf((int)'"'))
			{
				mat[mat_i] = new Material(getWord(s));
			}
	
		}

		return mat;
	}

	//w肳ꂽ񂩂_uNH[eF[Vň͂܂ꂽ؂oB
	private String getWord(String s)
	{
		//ŏ'"'̈ʒu擾

		int start,end;

		start = s.indexOf((int)'"');
		end   = s.lastIndexOf((int)'"');

		//O؂蕶iWin32VXeȂ'\'jTA
		//݂Ȃ΁AϐstartXVB
		if(s.lastIndexOf((int)File.separatorChar) != -1)
		start = s.lastIndexOf((int)File.separatorChar);

		return s.substring(start+1,end);
	}

	private void calcGuraud(Vertex[] vertex,Face[] face)
	{

		Vector n = new Vector();

		for(int i=0;i<face.length;i++)
		{
			if(face[i].V.length == 3)
			{
				int[] V = face[i].V;
				n.calcNormal(vertex[V[0]].v,vertex[V[1]].v,vertex[V[2]].v);
				vertex[V[0]].n.Add(n);
				vertex[V[1]].n.Add(n);
				vertex[V[2]].n.Add(n);
				vertex[V[0]].used++;
				vertex[V[1]].used++;
				vertex[V[2]].used++;
			}
			//{1,2,3,1,3,0}
			else
			{
				int[] V = face[i].V;
				n.calcNormal(vertex[V[1]].v,vertex[V[2]].v,vertex[V[3]].v);
				vertex[V[1]].n.Add(n);
				vertex[V[2]].n.Add(n);
				vertex[V[3]].n.Add(n);
				vertex[V[1]].used++;
				vertex[V[2]].used++;
				vertex[V[3]].used++;

				n.calcNormal(vertex[V[1]].v,vertex[V[3]].v,vertex[V[0]].v);
				vertex[V[1]].n.Add(n);
				vertex[V[3]].n.Add(n);
				vertex[V[0]].n.Add(n);
				vertex[V[1]].used++;
				vertex[V[3]].used++;
				vertex[V[0]].used++;
			}
		}
		for(int i=0;i<vertex.length;i++)
		{
			if (vertex[i].used > 0){
				vertex[i].n.x /= vertex[i].used;
				vertex[i].n.y /= vertex[i].used;
				vertex[i].n.z /= vertex[i].used;
			}
			vertex[i].n.Normalize();
		}
	}

	private rtObject convertObject(rtObject obj,Material[] mat)
	{
		System.out.println("convertObject is started");

		Vertex[] vertex = obj.vertex;
		Face[] face     = obj.face;
		String name     = obj.name;

		//̔z𐶐B
		final int length = face.length;

		final int[] V_b    = new int[(length * 3) << 1];
		final int[] M_b    = new int[(length * 3) << 1];

		final int[] UV_U_b = new int[(length * 3) << 1];
		final int[] UV_V_b = new int[(length * 3) << 1];

		int p = 0;

		for(int i=0;i<length;i++)
		{
			if(face[i].V.length == 3)
			{
				for(int j=0;j<3;j++)
				{
					V_b[p] = face[i].V[j];

					//M-1ĂꍇAftHg̍ގƂȂ
					if(face[i].M == -1)
					{
						M_b[p] = mat.length-1;
					}
					else
					{
						M_b[p] = face[i].M;
					}
					
					//0,2,4  1,3,5 ɕ
					if(face[i].UV == null)
					{
						UV_U_b[p] = UV_V_b[p] = 0;
					}
					else{
						UV_U_b[p] = face[i].UV[(j << 1)];
						UV_V_b[p] = face[i].UV[(j << 1) +1];
					}
					p++;
				}
			}
			else if(face[i].V.length == 4)
			{
				//1,2,3,1,3,0̏ɒǉB
				int[] k = {1,2,3,1,3,0};

				for(int j=0;j<6;j++)
				{
					V_b[p] = face[i].V[k[j]];

					//M-1ĂꍇAftHg̍ގƂȂ
					if(face[i].M == -1)
					{
						M_b[p] = mat.length-1;
					}
					else
					{
						M_b[p] = face[i].M;
					}
					//0,2,4,6  1,3,5,7 ɕ
					if(face[i].UV == null)
					{
						UV_U_b[p] = UV_V_b[p] = 0;
					}
					else{
						UV_U_b[p] = face[i].UV[   k[j] << 1 ];
						UV_V_b[p] = face[i].UV[ ( k[j] << 1 )+1];
					}
					p++;
				}
			}
		}

		final int[] V    = new int[p];
		final int[] M    = new int[p];

		final int[] UV_U = new int[p];
		final int[] UV_V = new int[p];

		for(int i=0;i<p;i++)
		{
			V[i] = V_b[i];
			M[i] = M_b[i];
			UV_U[i] = UV_U_b[i];
			UV_V[i] = UV_V_b[i];
		}

		obj.setPrimitive(createObject(V,M,UV_U,UV_V,vertex,name,mat));
		
		return obj;
	}

	public void addObject(rtObject obj)
	{
		rtObject[] temp = new rtObject[object.length+1];

		for( int i = 0; i < object.length; i++ )
		{
			temp[i] = object[i];
		}

		temp[object.length] = obj;

		object = temp;
	}

	public Primitive[] createObject(int[] V_b,int[] M_b,int[] UV_U_b,int[] UV_V_b,
					  Vertex[] vertex,String name,Material[] mat
					 )
	{

		//ގƂ̒_L^z
		int[] MatCount = new int[mat.length];

		//
		for(int i=0;i<MatCount.length;i++)
		{
			MatCount[i] = 0;
		}

		//ގƂ̒_JEg
		for(int i=0;i<M_b.length;i++)
		{
			if(M_b[i] == -1)
			{
				MatCount[mat.length-1]++;
			}else
			{
				MatCount[M_b[i]]++;
			}
		}

		Primitive[] primi_b = new Primitive[mat.length];

		for(int i=0;i<primi_b.length;i++)
		{
			if(MatCount[i] != 0)
			{
				primi_b[i] = new Primitive();
				primi_b[i].vertex = vertex;
				primi_b[i].name = name;
				primi_b[i].V_index  = new int[MatCount[i]];
				primi_b[i].UV_U_ind = new int[MatCount[i]];
				primi_b[i].UV_V_ind = new int[MatCount[i]];
				primi_b[i].setMaterial(mat[i]);
			}
			else{
				primi_b[i] = null;
			}
		}

		//
		for(int i=0;i<MatCount.length;i++)
		{
			MatCount[i] = 0;
		}

		int j;

		for(int i=0;i<M_b.length;i++)
		{
			j = M_b[i];

			if(j == -1) j = mat.length-1;

			primi_b[j].V_index [ MatCount[j] ] = V_b[i];
			primi_b[j].UV_U_ind[ MatCount[j] ] = UV_U_b[i];
			primi_b[j].UV_V_ind[ MatCount[j] ] = UV_V_b[i];
			MatCount[j]++;
		}

		int p=0;
		
		for(int i=0;i<primi_b.length;i++)
		{
			if(primi_b[i] != null) p++;
		}

		Primitive[] primi = new Primitive[p];
	
		p=0;
		
		for(int i=0;i<primi_b.length;i++)
		{
			if(primi_b[i] != null)
			{
				primi[p++] = primi_b[i];
			}
		}

		return primi;
	}
}